/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.ui.components;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javax.activation.MimetypesFileTypeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.corelib.base.AbstractLink;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.chorem.pollen.ui.base.ContextLink;
import org.chorem.pollen.ui.components.FileLink;
import org.slf4j.Logger;

public class FileLink
extends AbstractLink {
    @Parameter(required=true)
    private String _filename;
    @Parameter
    private String _type;
    @Inject
    private Logger logger;
    @Inject
    private ComponentResources _resources;
    @Parameter(required=true)
    private ContextLink _context;

    @Log
    void beginRender(MarkupWriter writer) {
        Link link = this._resources.createEventLink("createLink", new Object[]{this._filename, this._type});
        this.writeLink(writer, link, new Object[0]);
    }

    void afterRender(MarkupWriter writer) {
        writer.end();
    }

    public StreamResponse onCreateLink(String filename, String type) {
        if (StringUtils.isEmpty((String)filename) || filename.contains("..")) {
            return null;
        }
        File file = this._context.getFile(filename);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            this.logger.error("Fichier inexistant : " + file.getAbsolutePath(), (Throwable)e);
        }
        if (!this._resources.isBound("type")) {
            MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
            type = mimes.getContentType(file);
        }
        return new FileStreamResponse(this, (InputStream)stream, type);
    }
}

