/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetParticipatedPolls.java 3702 2012-09-23 13:48:42Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetParticipatedPolls.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.apache.commons.lang3.tuple.Pair;
import org.chorem.pollen.PollenUserSecurityContext;
import org.chorem.pollen.bean.PollUri;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.services.impl.SecurityService;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain participated polls to put in grid for the connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetParticipatedPolls extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] data;

    @Override
    public Map<String, Object>[] getData() {
        return data;
    }

    @Override
    public String execute() throws Exception {

        PollService pollService = getPollService();

        List<Pair<Poll, PollAccount>> participatedPolls =
                pollService.getParticipatedPolls(pager, getPollenUserAccount());

        data = new Map[participatedPolls.size()];
        Binder<Poll, Poll> binder =
                PollenBinderHelper.getSimpleTopiaBinder(Poll.class);
        int index = 0;

        for (Pair<Poll, PollAccount> entry : participatedPolls) {

            Poll poll = entry.getKey();
            Map<String, Object> map = pollService.pollToMap(poll, binder);
            PollAccount account = entry.getValue();

            PollUri pollUri = PollUri.newPollUri(poll.getPollId(),
                                                 account.getAccountId());

            // Keep accountId to allow vote update
            map.put("voteId", pollUri.getUri());

            // For Free poll, it's not necessary to keep the accountId
            String resultId = poll.isPollFree()
                              ? pollUri.getPollId()
                              : pollUri.getUri();
            map.put("resultId", resultId);
            map.put("adminId", poll.getAdminId());

            Set<String> functions = getPollFunctions(poll, pollUri);
            map.put("functions", functions);
            data[index++] = map;
        }
        return SUCCESS;
    }

    private Set<String> getPollFunctions(Poll poll,
                                         PollUri pollUri) {
        Set<String> result = Sets.newHashSet();

        PollenUserSecurityContext securityContext =
                PollenUserSecurityContext.newContext(
                        getPollenUserAccount(),
                        pollUri, poll);
        SecurityService securityService = getSecurityService();

        securityContext.loadUserRoles(securityService);

        result.add("vote");

        boolean canAccessResult =
                securityService.isCanAccessResult(securityContext);

        if (canAccessResult) {

            // only if results are public
            result.add("result");
        } else {
            result.add("noresult");

        }

        boolean canAdminResult = securityContext.isCreator();
        if (canAdminResult) {
            result.add("summary");
        }
        return result;
    }
}
