<%--
  #%L
  Pollen :: UI (struts2)
  $Id: pollsList.jsp 3702 2012-09-23 13:48:42Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/admin/pollsList.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@page contentType="text/html" pageEncoding="UTF-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sjg" uri="/struts-jquery-grid-tags" %>
<script type="text/javascript">
  var redirectUrl = '<s:url namespace="/admin" action="pollsList"/>';
</script>
<%@include file="/WEB-INF/jsp/pollListHelper.jsp" %>

<title><s:text name="pollen.title.pollsList"/></title>

<h1 class="title<s:property value='%{pageLogo}'/>">
  <s:text name="pollen.title.pollsList"/>
</h1>

<s:url id="loadUrl" action="getPolls" namespace="/json" escapeAmp="false"/>

<sjg:grid id="polls" dataType="json" href="%{loadUrl}" gridModel="data"
          sortable="true" pager="true" pagerButtons="true" pagerInput="true"
          navigator="true" rownumbers="false" autowidth="true"
          onSelectRowTopics='users-rowSelect' editurl="%{loadUrl}"
          onCompleteTopics='users-cleanSelect'
          navigatorEdit="false" navigatorDelete="false"
          navigatorSearch="false" navigatorRefresh="false"
          navigatorAdd="false" viewrecords="true"
          rowList="10,15,20,50,100" rowNum="10">
  <sjg:gridColumn name="id" title="id" hidden="true"/>

  <sjg:gridColumn name="title" title='%{getText("pollen.common.title")}'/>
  <sjg:gridColumn name="description"
                  title='%{getText("pollen.common.description")}'/>
  <sjg:gridColumn name="addingChoices"
                  title='%{getText("pollen.common.addingChoices")}'/>
  <sjg:gridColumn name="beginDate"
                  title='%{getText("pollen.common.beginDate")}'/>
  <sjg:gridColumn name="endDate" title='%{getText("pollen.common.endDate")}'/>
  <sjg:gridColumn name="functions" title='%{getText("pollen.common.functions")}'
                  formatter="pollFunctions" width="55" sortable="false"/>
</sjg:grid>
