/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: ModeratePoll.java 3611 2012-08-13 14:11:15Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.5.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/vote/ModeratePoll.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll.vote;

/**
 * To moderate votes and comment of a given poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.4
 */
public class ModeratePoll extends AbstractVoteAction {

    private static final long serialVersionUID = 1L;

    @Override
    public String input() throws Exception {

        prepareVotePage();

        addFlashWarning(_("pollen.information.moderate.page"));
        return INPUT;
    }

    @Override
    public boolean isModerate() {
        return true;
    }
}
