/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: favoriteLists.js 3579 2012-07-31 16:21:30Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/webapp/js/favoriteLists.js $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
function initFavoritesPage(action) {

    if (action == 'create') {
        $('#createForm').show();
    }

    // listen row selection
    $.addRowSelectTopic('favoriteLists', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".userForm").hide();
    });

    $.addClearSelectTopic('favoriteLists', function () {
        if (action != '') {
            // come back from action
            action = '';
            return;
        }
        $(".userForm").hide();
    });

    // to create a new row
    $.listenRowTopic('favoriteLists-addRow', function (event) {

        $('#createForm .errorMessage').hide();
        $('#createForm [name="favoriteList.name"]').val("");
        $('#createForm [name="csvImport"]').val("");
        $('#createForm [name="ldapImport"]').val("");
        $('#deleteForm').hide();
        $('#createForm').show();
    });

    $('img[src$="tooltip.png"]').addClass("tooltip");
    $('.tooltip').tipTip({   maxWidth:'340px',
                             defaultPosition:'right' });
}

function favoriteListsFunctions(cellvalue, options, rowObject) {

    var id = rowObject.id;

    var result = "";

    var script = 'return editFavoriteList("' + id + '");';
    result += formatLinkByScript(script, editImg, "Edit", editTitle);

    script = 'return confirmDelete("' + id + '");';
    result += formatLinkByScript(script, deleteImg, "Delete", deleteTitle);
    return result;
}

function formatLinkByScript(script, image, imageAlt, imageTitle) {
    return "<a href='#' onclick='" + script + "'><image alt='" + imageAlt + "' title='" + imageTitle + "' src='" + image + "'> </a>";
}

function editFavoriteList(id) {
    $('#editForm [name="favoriteListId"]').val(id);
    $('#editForm').submit();
    return false;
}

function confirmDelete(id) {
    $('.ui-dialog-title').html(deleteTitle)
    var dialog = $("#confirmDialog");
    var url = deleteUrl + '?' + $.param({favoriteListId:id,
                                            redirectUrl:redirectUrl});
    dialog.load(url);
    dialog.dialog('open');
    return false;
}
