<%@ page import="org.chorem.pollen.ui.actions.PollenActionSupport" %>
<%--
#%L
  Pollen :: UI (struts2)
  $Id: layout-default.jsp 3521 2012-06-19 08:53:57Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/webapp/WEB-INF/decorators/layout-default.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
--%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<%@ page language="java" contentType="text/html; charset=utf-8"
         pageEncoding="utf-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>
<%@ taglib prefix="d" uri="http://www.opensymphony.com/sitemesh/decorator" %>
<html xmlns="http://www.w3.org/1999/xhtml">
<script type="text/javascript">
  var StrutsUtils = new Object();
    StrutsUtils.showValidationErrors = function(){};
</script>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
  <title>Pollen - <d:title default="Pollen"/></title>
  <d:head/>
  <link rel="stylesheet" type="text/css" href="<s:url value='/css/main.css' />"/>
  <link rel="stylesheet" type="text/css" href="<s:url value='/css/common.css' />"/>
  <link rel="icon" type="image/png" href="<s:url value='/favicon.png' />"/>
  <sj:head locale="%{locale}" jqueryui="true" jquerytheme="%{jqueryTheme}"/>
</head>

<%-- TODO AThimel 24/01/2012 Remove this when refactoring is over --%>
<div id="in-progress">
    <a href="http://chorem.org/projects/pollen">
      <s:text name="pollen.banner.newVersion"/>
    </a>
</div>


<script type="text/javascript">

  jQuery(document).ready(function () {

    // apply common style
    $('fieldset').addClass('ui-widget-content ui-corner-all');

    // Popup for lostPassword
    $('#lostPasswordLink').click(function() {

        $('.ui-dialog-title').html('<s:text name="pollen.link.lostPassword"/>');

        var url = '<s:url action="lostPassword" method="input" namespace="/user"/>';
        var dialog = $("#lostPasswordDialog");
        dialog.load(url);
        dialog.dialog('open');
        return false;
    });
  });
</script>
<s:set var="user" value="%{#session.pollenSession.userAccount}"/>
<s:set var="userExists" value="%{#user != null}"/>
<s:set var="userIsAdmin" value="%{#userExists && #user.administrator}"/>

<body id="<s:property value="%{pageLogo}"/>Body">

<!-- Langue -->
<div id="po-header-localization" class="<s:property value='%{pageLogo}'/>Localization">
  <s:a title="Contacter un administrateur"
       href="mailto:%{configuration.adminEmail}">
    <img src="<s:url value='/img/contact.png' />" alt="Contact"/>
  </s:a>
  | <%=PollenActionSupport.getCurrentDateTime()%> |
  <s:a action="changeLang" namespace="/user" id="localeFr">
    <s:param name="request_locale">fr_FR</s:param>
    <s:param name="redirectUrl" value="%{currentUrl}"/>
    <img src="<s:url value='/img/fr.png' />" alt="Français"/>
  </s:a> | <s:a action="changeLang" namespace="/user" id="localeEn">
  <s:param name="request_locale">en_GB</s:param>
  <s:param name="redirectUrl" value="%{currentUrl}"/>
  <img src="<s:url value='/img/en.png' />" alt="English"/>
</s:a>
</div>

<!-- Entête de la page -->
<p id="po-header-logo">
  <s:a action="home" namespace="/">
    <img src="<s:url value='/img/pollen%{pageLogo}_%{safeLanguage}.png' />"
         alt="Pollen"/>
  </s:a>
</p>

<div id="top" class="<s:property value="%{pageLogo}"/>">

  <!-- Login -->
  <div id="po-header-connection" class="<s:property value='%{pageLogo}'/>">
    <s:if test="userExists">
    <span class="menu_elt" onmouseover="$('#compte_menu').show()"
          onmouseout="$('#compte_menu').hide()">
        <s:property value='%{#user.displayName}'/>
        <div class="dropdown_menu" id="compte_menu" style="display: none;">
          <div class="top_right<s:property value='%{pageLogo}'/>"></div>
          <div class="top_left<s:property value='%{pageLogo}'/>"></div>
          <ul class="top_middle<s:property value='%{pageLogo}'/>">
            <li>
              <s:a action="show" namespace="/user">
                <s:text name="pollen.menu.preferences"/>
              </s:a>
            </li>
            <li>
              <s:a action="logout" namespace="/user">
                <s:text name="pollen.menu.logout"/>
              </s:a>
            </li>
          </ul>
        </div>
    </span>
    </s:if>
    <s:else>
      <span id='tologin' onClick="$('#login_menu').toggle()">
        <s:text name="pollen.menu.login"/>
      </span>

      <div class="dropdown_menu" id="login_menu" style="display: none;">
        <div class="top_right<s:property value='%{pageLogo}'/>"></div>
        <div class="top_left<s:property value='%{pageLogo}'/>"></div>

        <sj:dialog id="lostPasswordDialog" autoOpen="false" modal="true" width="500"/>

        <s:form id="connection" method="POST" namespace="/user" action="login">
          <s:hidden name="redirectUrl" value="%{currentUrl}"/>
          <ul class="top_middle<s:property value='%{pageLogo}'/>">
            <li>
              <label for="connection_login">
                <s:text name="pollen.common.login"/> :
              </label>
              <s:textfield key="login" size="10" required="true" theme="simple"
                           label='' id='connection_login'/>
            </li>
            <li>
              <label for="connection_password">
                <s:text name="pollen.common.password"/> :
              </label>
              <s:password key="password" size="10" required="true"
                          id='connection_password'
                          label="" theme="simple"/>
            </li>
            <li>
              <a id="lostPasswordLink">
                <s:text name="pollen.link.lostPassword"/>
              </a>
            </li>
            <li>
              <s:submit id="submitform" action="login" key="pollen.action.login"
                        align="right"/>
            </li>
          </ul>
        </s:form>
      </div>
      <s:text name="pollen.common.or"/>
      <s:a action="register" method="input" namespace="/user">
        <s:text name="pollen.menu.register"/>
      </s:a>
    </s:else>

  </div>

  <!-- Menu -->
  <ul id="menu">
    <li class="menu_elt">
      <s:a action="home" namespace="/">
        <s:text name="pollen.menu.home"/>
      </s:a>
    </li>
    <li class="menu_elt" onmouseout="$('#menu1').hide()"
        onmouseover="$('#menu1').show()">
      <a><s:text name="pollen.menu.polls"/></a>

      <div class="dropdown_menu" id="menu1" style="display:none">
        <div class="top_right<s:property value='%{pageLogo}'/>"></div>
        <div class="top_left<s:property value='%{pageLogo}'/>"></div>
        <ul class="top_middle<s:property value='%{pageLogo}'/>">
          <li>
            <s:a action="create" namespace="/poll">
              <s:text name="pollen.menu.createPoll"/>
            </s:a>
          </li>
          <s:if test="userExists">
            <li>
              <s:a action="createdList" namespace="/user">
                <s:text name="pollen.menu.pollsCreatedList"/>
              </s:a>
            </li>
            <li>
              <s:a action="invitedList" namespace="/user">
                <s:text name="pollen.menu.pollsInvitedList"/>
              </s:a>
            </li>
            <li>
              <s:a action="participatedList" namespace="/user">
                <s:text name="pollen.menu.pollsParticipatedList"/>
              </s:a>
            </li>
            <li>
              <s:a action="favoriteLists" namespace="/user">
                <s:text name="pollen.menu.userFavoriteLists"/>
              </s:a>
            </li>
          </s:if>
        </ul>
      </div>
    </li>
    <s:if test="userExists">
      <s:if test="userIsAdmin">
        <li class="menu_elt" onmouseout="$('#menu2').hide()"
            onmouseover="$('#menu2').show()">
          <a><s:text name="pollen.menu.admin"/></a>

          <div class="dropdown_menu" id="menu2" style="display:none">
            <div class="top_right<s:property value='%{pageLogo}'/>"></div>
            <div class="top_left<s:property value='%{pageLogo}'/>"></div>
            <ul class="top_middle<s:property value='%{pageLogo}'/>">
              <li>
                <s:a action="pollsList" namespace="/admin">
                  <s:text name="pollen.menu.managePolls"/>
                </s:a>
              </li>
              <li>
                <s:a action="usersList" namespace="/admin">
                  <s:text name="pollen.menu.manageUsers"/>
                </s:a>
              </li>
            </ul>
          </div>
        </li>
      </s:if>
    </s:if>
  </ul>
</div>

<!-- Corps de la page -->
<%--<div id="corps" class="cleanBoth clearfix">--%>
<div id="corps">

  <!-- Barre d'adresse -->
  <div id="po-header-addressBar" class="<s:property value='%{pageLogo}'/>Address">
    <%--<t:loop t:source="addressBar.items" t:value="item">--%>
    <%--&gt;--%>
    <%--<strong>--%>
    <%--<t:if test="item.address">--%>
    <%--<a t:type="pagelink" t:page="prop:item.address" href="index">${item.name}</a>--%>
    <%--<p:else>--%>
    <%--${item.name}--%>
    <%--</p:else>--%>
    <%--</t:if>--%>
    <%--</strong>--%>
    <%--</t:loop>--%>
  </div>

  <!-- Contenu -->
  <div id="<s:property value='%{pageBobyId}'/>" class="content">
    <noscript>
      <%--<div t:type="nuiton/feedback" t:id="errorJs" />--%>
    </noscript>
    <%--<div t:type="nuiton/feedback" t:id="borderFeedback" t:autoClear="false"/>--%>

    <s:if test="hasFlashMessages()">
      <div class="info_success clearfix">
        <ul class="actionMessages fleft">
          <s:iterator value="flashMessages" var="message">
            <li><span><s:property value="#message" escapeHtml="false"/></span></li>
          </s:iterator>
        </ul>
      </div>
    </s:if>

    <s:if test="hasFlashWarnings()">
      <div class="info_warning clearfix">
        <ul class="actionWarnings fleft">
          <s:iterator value="flashWarnings" var="message">
            <li><span><s:property value="#message" escapeHtml="false"/></span></li>
          </s:iterator>
        </ul>
      </div>
    </s:if>
    <s:if test="hasFlashErrors()">
      <div class="info_error clearfix">
        <ul class="actionErrors fleft">
          <s:iterator value="flashErrors" var="message">
            <li><span><s:property value="#message" escapeHtml="false"/></span></li>
          </s:iterator>
        </ul>
      </div>
    </s:if>
    <d:body/>
  </div>
</div>

<!-- Pied de page -->
<div id="po-footer" class="<s:property value='%{pageLogo}'/>" xml:space="preserve">
  <a href="http://maven-site.chorem.org/pollen">Pollen</a>
  <a href="http://www.chorem.org/projects/pollen/files">
    <%=PollenActionSupport.getApplicationVersion()%>
  </a> -
  <a href="http://www.gnu.org/licenses/agpl.html">
    <s:text name="pollen.common.license"/>
  </a> -
  <span title="Copyright">&copy;2009-2012</span>
  <a href="http://www.codelutin.com">Code Lutin</a> -
  <a href="http://www.chorem.org/projects/pollen/issues">
    <s:text name="pollen.common.bugReport"/>
  </a> -
  <a href="http://list.chorem.org/cgi-bin/mailman/listinfo/pollen-users">
    <s:text name="pollen.common.userSupport"/>
  </a>
</div>

</body>
</html>
