/*
 * #%L
 * Pollen :: UI (struts2)
 * $Id: GetUsers.java 3423 2012-06-05 16:50:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/json/GetUsers.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.json;

import com.google.common.collect.Sets;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.entities.PollenBinderHelper;
import org.nuiton.util.beans.Binder;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Obtain paginated users.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetUsers extends AbstractJSONPaginedAction {

    private static final long serialVersionUID = 1L;

    protected transient Map<String, Object>[] users;

    public Map<String, Object>[] getUsers() {
        return users;
    }

    @Override
    public Integer getRows() {
        return pager.getPageSize();
    }

    @Override
    public Integer getPage() {
        return pager.getPageIndex();
    }

    @Override
    public Integer getTotal() {
        return pager.getPagesNumber();
    }

    @Override
    public Integer getRecords() {
        return pager.getRecords();
    }

    @Override
    public String execute() throws Exception {

        List<UserAccount> allUsers = getUserService().getUsers(pager);

        UserAccount userAccount = getPollenUserAccount();
        users = new Map[allUsers.size()];
        Binder<UserAccount, UserAccount> binder =
                PollenBinderHelper.getSimpleTopiaBinder(UserAccount.class);
        int index = 0;
        for (UserAccount user : allUsers) {
            Map<String, Object> map = binder.obtainProperties(
                    user
            );
            map.put("id", user.getTopiaId());
            Set<String> functions = getUserFunctions(userAccount, user);
            map.put("functions", functions);

            users[index++] = map;
        }

        return SUCCESS;
    }

    protected Set<String> getUserFunctions(UserAccount connectedUser, UserAccount user) {
        Set<String> result = Sets.newHashSet();
        result.add("edit");
        if (!user.equals(connectedUser)) {

            // can not delete current connected user

            result.add("delete");
        }
        return result;
    }
}
