/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: DeleteComment.java 3257 2012-04-13 11:28:02Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/poll/DeleteComment.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.poll;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.interceptor.annotations.InputConfig;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.services.exceptions.PollCommentNotFound;
import org.chorem.pollen.services.impl.PollCommentService;

/**
 * To delete a poll comment.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class DeleteComment extends AbstractVoteAction {

    private static final long serialVersionUID = 1L;

    /** Id of the comment to delete. */
    protected String commentId;

    public void setCommentId(String commentId) {
        this.commentId = commentId;
    }

    @InputConfig(methodName = "prepareVotePage")
    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(commentId);

        PollCommentService service = newService(PollCommentService.class);

        Comment comment = service.getEntityById(Comment.class, commentId);

        if (comment == null) {
            throw new PollCommentNotFound();
        }

        setUriId(getUriId());

        service.deleteComment(commentId);

        return SUCCESS;
    }
}
