/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: ManageFavoriteList.java 3333 2012-04-30 15:52:41Z fdesbois $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/user/ManageFavoriteList.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.user;

import com.google.common.base.Preconditions;
import com.opensymphony.xwork2.Preparable;
import org.apache.struts2.interceptor.ParameterAware;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.services.exceptions.FavoriteListNotFoundException;
import org.chorem.pollen.services.exceptions.FavoriteListNotOwnedByUserException;
import org.chorem.pollen.services.exceptions.ParticipantAlreadyFoundInListException;
import org.chorem.pollen.services.impl.FavoriteService;
import org.chorem.pollen.ui.actions.PageSkin;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import java.util.Map;

/**
 * Manage a selected favorite lists of a connected user.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class ManageFavoriteList extends PollenActionSupport implements Preparable, ParameterAware {

    private static final long serialVersionUID = 1L;

    private Map<String, String[]> parameters;

    @Override
    public PageSkin getSkin() {
        return PageSkin.EDITION;
    }

    protected String action;

//    protected String favoriteListId;

    protected PersonList favoriteList;

    protected PollAccount pollAccount;

    public PollAccount getCreatePollAccount() {
        return getPollAccount();
    }

    public PollAccount getEditPollAccount() {
        return getPollAccount();
    }

    public PollAccount getDeletePollAccount() {
        return getPollAccount();
    }

    public PersonList getFavoriteList() {
        return favoriteList;
    }

    public String getFavoriteListId() {
        return favoriteList.getTopiaId();
    }

    public String getAction() {
        return action;
    }

    @Override
    public void prepare() throws Exception {

        String[] favoriteListIds = parameters.get("favoriteListId");
        Preconditions.checkNotNull(favoriteListIds);
        Preconditions.checkArgument(favoriteListIds.length == 1);
        String favoriteListId = favoriteListIds[0];

        String[] actions = parameters.get("action");
        if (actions != null && actions.length == 1) {
            action = actions[0];
        }

        FavoriteService service = newService(FavoriteService.class);

        try {
            favoriteList = service.getFavoriteList(
                    getPollenUserAccount(), favoriteListId);
        } catch (FavoriteListNotFoundException e) {
            addFlashError(_("pollen.error.favoriteList.not.found"));
        } catch (FavoriteListNotOwnedByUserException e) {
            addFlashError(_("pollen.error.favoriteList.not.owned.by.user"));
        }
    }

    public String create() throws Exception {

        Preconditions.checkNotNull(favoriteList);
        Preconditions.checkNotNull(pollAccount);

        String result = INPUT;

        FavoriteService service = newService(FavoriteService.class);

        try {

            service.addPollAccountToFavoriteList(favoriteList, pollAccount);
            getTransaction().commitTransaction();

            addFlashMessage(
                    _("pollen.information.pollAccount.addedTofavoriteList",
                      pollAccount.getVotingId()));

            pollAccount = null;
            action = null;
            result = SUCCESS;
        } catch (ParticipantAlreadyFoundInListException e) {
            addFieldError("createPollAccount.email",
                          _("pollen.error.favoriteList.participant.already.found.in.list"));
        }
        return result;
    }

    public String edit() throws Exception {

        Preconditions.checkNotNull(favoriteList);
        Preconditions.checkNotNull(pollAccount);

        String result = INPUT;

        FavoriteService service = newService(FavoriteService.class);

        try {

            service.editPollAccountToFavoriteList(favoriteList, pollAccount);
            getTransaction().commitTransaction();

            addFlashMessage(
                    _("pollen.information.pollAccount.updatedTofavoriteList",
                      pollAccount.getVotingId()));

            pollAccount = null;
            action = null;
            result = SUCCESS;
        } catch (ParticipantAlreadyFoundInListException e) {
            addFieldError("editPollAccount.email",
                          _("pollen.error.favoriteList.participant.already.found.in.list"));
        }
        return result;
    }

    public String delete() throws Exception {

        Preconditions.checkNotNull(favoriteList);
        Preconditions.checkNotNull(pollAccount);
        Preconditions.checkNotNull(pollAccount.getTopiaId());

        FavoriteService service = newService(FavoriteService.class);

        service.removePollAccountToFavoriteList(favoriteList, pollAccount);
        getTransaction().commitTransaction();

        addFlashMessage(
                _("pollen.information.pollAccount.removedFromFavoriteList",
                  pollAccount.getVotingId()));

        action = null;
        pollAccount = null;

        return SUCCESS;
    }

    protected PollAccount getPollAccount() {
        if (pollAccount == null) {
            FavoriteService service = newService(FavoriteService.class);
            pollAccount = service.newPollAccountForFavoriteList();
        }
        return pollAccount;
    }

    @Override
    public void setParameters(Map<String, String[]> parameters) {
        this.parameters = parameters;
    }
}
