/*
 * #%L
 * Pollen :: UI (strust2)
 * 
 * $Id: GetPollImageChoice.java 3394 2012-05-28 15:27:04Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1/pollen-ui-struts2/src/main/java/org/chorem/pollen/ui/actions/io/GetPollImageChoice.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.ui.actions.io;

import com.google.common.base.Preconditions;
import org.chorem.pollen.services.impl.PollService;
import org.chorem.pollen.ui.actions.PollenActionSupport;

import javax.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

/**
 * Obtain the image choice of a given choice of an image-like poll.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.3
 */
public class GetPollImageChoice extends PollenActionSupport {

    private static final long serialVersionUID = 1L;

    protected String pollId;

    protected String choiceId;

    protected boolean thumb;

    protected transient InputStream inputStream;

    protected String contentType;

    public void setPollId(String pollId) {
        this.pollId = pollId;
    }

    public void setChoiceId(String choiceId) {
        this.choiceId = choiceId;
    }

    public void setThumb(boolean thumb) {
        this.thumb = thumb;
    }

    public String getContentType() {
        return contentType;
    }

    public InputStream getInputStream() {
        return inputStream;
    }

    @Override
    public String execute() throws Exception {

        Preconditions.checkNotNull(pollId);
        Preconditions.checkNotNull(choiceId);

        PollService service = newService(PollService.class);

        File file = service.getPollChoiceImageFile(pollId, choiceId, thumb);

        MimetypesFileTypeMap mimes = new MimetypesFileTypeMap();
        contentType = mimes.getContentType(file);

        inputStream = new FileInputStream(file);

        return SUCCESS;
    }
}
