<%--
  #%L
  Pollen :: UI (strust2)
  
  $Id: create.jsp 3375 2012-05-18 14:15:42Z tchemit $
  $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.3.1.1/pollen-ui-struts2/src/main/webapp/WEB-INF/jsp/poll/create.jsp $
  %%
  Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
  %%
  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU Affero General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU Affero General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  #L%
  --%>
<%@ page language="java" contentType="text/html" pageEncoding="utf-8" %>
<%@ taglib prefix="s" uri="/struts-tags" %>
<%@ taglib prefix="sj" uri="/struts-jquery-tags" %>

<link rel="stylesheet" type="text/css"
      href="<s:url value='/css/pollCreation.css'/>"/>
<link rel="stylesheet" type="text/css" href="<s:url value='/css/tipTip.css'/>"/>

<script type="text/javascript">

  $(document).data(
    {
      selectPersonListToAddToVotingListTitle:'<s:text name="pollen.title.selectPersonListToAddVotingList"/>',
      selectPersonListToCreateNewVotingListTitle:'<s:text name="pollen.title.selectPersonListToCreateVotingList"/>',

      votingListText:'<s:text name="pollen.common.votingList"/>',
      personToListText:'<s:text name="pollen.common.personToList"/>',
      choiceText:'<s:text name="pollen.common.choice"/>',

      displayVotingListUrl:'<s:url namespace="/poll" action="displayVotingList"/>',
      displayPersonToListUrl:'<s:url namespace="/poll" action="displayPersonToList"/>',
      importPersonListToVotingListUrl:'<s:url namespace="/poll" action="importPersonListToVotingList"/>',
      importPersonListToNewVotingListUrl:'<s:url namespace="/poll" action="importPersonListToNewVotingList"/>',
      displayImageChoiceUrl:'<s:url namespace="/poll" action="displayImageChoice"/>',
      displayDateChoiceUrl:'<s:url namespace="/poll" action="displayDateChoice"/>',
      displayTextChoiceUrl:'<s:url namespace="/poll" action="displayTextChoice"/>',
      selectPersonListToAddToVotingListUrl:'<s:url action="selectPersonListToAddToVotingList" namespace="/poll"/>',
      selectPersonListToCreateNewVotingListUrl:'<s:url action="selectPersonListToCreateNewVotingList" namespace="/poll"/>',

      choiceAddAllowed:'<s:property value="%{poll.choiceAddAllowed}"/>',
      limitChoice:'<s:property value="%{limitChoice}"/>',
      reminder:'<s:property value="%{reminder}"/>',
      voteCountingType:'<s:property value="%{poll.voteCountingType.name()}"/>',
      choiceType:'<s:property value="%{poll.choiceType.name()}"/>',
      pollType:'<s:property value="%{poll.pollType.name()}"/>',

      confirmCloseTitle:"<s:text name='pollen.title.close.poll'/>",
      confirmCloseUrl:'<s:url action="confirmClosePoll/" namespace="/poll"/>'
        + '<s:property value="%{poll.adminId}"/>',
      confirmCloseRedirectUrl:'<s:url action="resultLink/" namespace="/poll"/>'
        + '<s:property value="%{poll.adminId}"/>'
    }
  );
</script>

<script type="text/javascript"
        src='<s:url value="/js/createPoll.js"/>'></script>
<script type="text/javascript"
        src='<s:url value="/js/jquery.tipTip.minified.js"/>'></script>

<s:url id='errorImg' value='/img/exclamation.png'/>

<title><s:text name="pollen.title.createPoll"/></title>

<h1 class="title${pageLogo}"><s:property value="%{pageTitle}"/></h1>

<s:form method="POST" id="registerForm" namespace="/poll"
        enctype="multipart/form-data">

  <s:hidden key="poll.topiaId" label=""/>

  <sj:tabbedpanel id="formTabs" selectedTab="%{selectedTab}">

    <sj:tab id="tabGeneral" target="tgeneral" key="pollen.tab.poll.general"/>
    <sj:tab id="tabOptions" target="toptions" key="pollen.tab.poll.options"/>

    <div id="tgeneral">

      <fieldset>
          <%--<legend><s:text name="pollen.common.voteCountingType"/></legend>--%>

        <s:textfield key="poll.title" label="%{getText('pollen.common.title')}"
                     required="true" size="80"/>
        <s:textarea key="poll.description" rows="3" cols="54"
                    label="%{getText('pollen.common.description')}"/>
        <s:hidden key="poll.pollId" label=""/>
      </fieldset>

      <br/>

      <fieldset>
        <legend>
          <s:text name="pollen.common.voteCountingType"/>
          <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
               title="<s:text name='pollen.common.voteCountingType.help'/>"/>
        </legend>
        <s:radio key='poll.voteCountingType' list="voteCountingTypes"
                 label='' theme="simple" disabled="%{voteStarted}"/>
      </fieldset>
      <br/>

      <%@include file="createPoll_choices.jsp" %>

    </div>

    <div id="toptions">

      <fieldset>
        <legend><s:text name="pollen.fieldset.poll.you"/></legend>
        <s:textfield key="poll.creator.votingId" size="80"
                     label="%{getText('pollen.common.login')}"/>
        <s:textfield key="poll.creator.email" size="80"
                     label="%{getText('pollen.common.email')}"/>
        <s:hidden key="poll.creator.accountId" label=""/>
        <s:hidden key="poll.creator.topiaId" label=""/>
        <s:if test="creatorUserAccountDefined">
          <s:hidden name="userId" value="%{poll.creator.userAccount.topiaId}"/>
        </s:if>
      </fieldset>

      <br/>

      <fieldset>
        <legend><s:text name="pollen.fieldset.poll.options"/></legend>

        <s:checkbox key="poll.anonymous"
                    label="%{getText('pollen.common.pollOption.anonymous')}"
                    disabled="%{voteStarted}"
                    tooltip="%{getText('pollen.common.pollOption.anonymous.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <s:checkbox key="poll.anonymousVoteAllowed"
                    label="%{getText('pollen.common.pollOption.anonymousVoteAllowed')}"
                    disabled="%{voteStarted}"
                    tooltip="%{getText('pollen.common.pollOption.anonymousVoteAllowed.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <s:checkbox key="poll.continuousResults"
                    label="%{getText('pollen.common.pollOption.continuousResults')}"
                    tooltip="%{getText('pollen.common.pollOption.continuousResults.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <s:checkbox key="poll.publicResults"
                    label="%{getText('pollen.common.pollOption.publicResults')}"
                    tooltip="%{getText('pollen.common.pollOption.publicResults.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <s:checkbox key="poll.choiceAddAllowed"
                    label="%{getText('pollen.common.pollOption.choiceAddAllowed')}"
                    disabled="%{voteStarted}"
                    tooltip="%{getText('pollen.common.pollOption.choiceAddAllowed.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <div id='addChoiceAddAllowedPanel' class="hidden">
          <sj:datepicker key="poll.beginChoiceDate"
                         label="%{getText('pollen.common.beginChoiceDate')}"
                         displayFormat="%{getText('pollen.common.datePickerPattern')}"
                         timepicker="true"
                         disabled="%{voteStarted}"/>
          <sj:datepicker key="poll.endChoiceDate"
                         label="%{getText('pollen.common.endChoiceDate')}"
                         displayFormat="%{getText('pollen.common.datePickerPattern')}"
                         timepicker="true"
                         disabled="%{voteStarted}"/>
        </div>
        <s:checkbox key="limitChoice"
                    label="%{getText('pollen.common.pollOption.limitChoice')}"
                    disabled="%{voteStarted}"
                    tooltip="%{getText('pollen.common.pollOption.limitChoice.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <div id='maxChoiceNbPanel' class="hidden">
          <s:textfield key="poll.maxChoiceNb"
                       label="%{getText('pollen.common.pollOption.maxChoiceNb')}"
                       disabled="%{voteStarted}"/>
        </div>
        <s:checkbox key="notification"
                    label="%{getText('pollen.common.pollOption.notification')}"
                    tooltip="%{getText('pollen.common.pollOption.notification.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <s:checkbox key="reminder"
                    label="%{getText('pollen.common.pollOption.reminder')}"
                    tooltip="%{getText('pollen.common.pollOption.reminder.help')}"
                    tooltipIconPath="/img/tooltip.png"/>
        <div id='reminderPanel' class="hidden">
          <s:textfield key="reminderHourCountdown"
                       label="%{getText('pollen.common.pollOption.reminderHourCountdown')}"/>
        </div>
      </fieldset>

      <br/>
      <fieldset>
        <legend><s:text name="pollen.fieldset.poll.general"/></legend>

        <sj:datepicker key="poll.beginDate"
                       displayFormat="%{getText('pollen.common.datePickerPattern')}"
                       label="%{getText('pollen.common.beginDate')}"
                       timepicker="true"
                       disabled="%{voteStarted}"/>
        <sj:datepicker key="poll.endDate"
                       displayFormat="%{getText('pollen.common.datePickerPattern')}"
                       timepicker="true"
                       label="%{getText('pollen.common.endDate')}"/>
      </fieldset>

      <br/>

      <fieldset>
        <legend>
          <s:text name="pollen.common.pollType"/>
          <img src="<s:url value='/img/tooltip.png'/>" class="tooltip"
               title="<s:text name='pollen.common.pollType.help'/>"/>
        </legend>
        <s:radio key='poll.pollType' list="pollTypes"
                 label='%{getText("pollen.common.pollType")}'
                 disabled="%{voteStarted}"/>
        <hr/>

        <div id="pollTypeFREE" class="pollType">
            <%--Nothing to show for a free poll--%>
        </div>

        <div id="pollTypeRESTRICTED" class="pollType">
          <s:iterator value="restrictedVotingList" status="status"
                      var="votingList">
            <s:set name="votingListNumber"><s:property
              value="%{#status.index}"/></s:set>
            <s:set name="votingListType">RESTRICTED</s:set>
            <%@include file="displayVotingList.jsp" %>
          </s:iterator>
        </div>

        <div id="pollTypeGROUP" class="pollType">
          <div id="votingListGROUP">
            <s:iterator value="groupVotingList" status="status"
                        var="votingList">
              <s:set name="votingListNumber"><s:property
                value="%{#status.index}"/></s:set>
              <s:set name="votingListType">GROUP</s:set>
              <%@include file="displayVotingList.jsp" %>
            </s:iterator>
          </div>
          <div align="center">
            <s:submit key="pollen.action.addVotingList" theme="simple"
                      onclick="return addNewVotingList();"
                      disabled="%{voteStarted}"/>
            <s:if test="userLoggued">
              <s:submit key="pollen.action.addVotingListFromPersonList"
                        theme="simple"
                        onclick='return selectPersonListToCreateNewVotingList();'
                        disabled="%{voteStarted}"/>
            </s:if>
          </div>
        </div>
      </fieldset>
    </div>

  </sj:tabbedpanel>

  <br/>
  <s:submit action="save" value="%{actionLabel}" align="center"/>
  <s:if test="edit">
    <div align="center" style="margin-top: 10px">
      <button onclick="return confirmClose();">
        <s:text name="pollen.action.close"/>
      </button>
    </div>
  </s:if>
</s:form>

<script type="text/javascript">

  jQuery(document).ready(function () {

    function addErrorImage(element) {
      element.append(
        '<image src="${errorImg}">'
      );
      element.attr('title', '<s:text name="pollen.error.pollTabErrorFound"/>');
    }

    if (<s:property value="%{informationsError}"/>) {
      addErrorImage($('#tabGeneral a'));
    }
    if (<s:property value="%{optionsError}"/>) {
      addErrorImage($('#tabOptions a'));
    }

    if (<s:property value="%{poll.closed}"/>) {
      $('#registerForm input, textarea').attr('disabled', true);
      $('#registerForm :button, fieldset a, :submit, input[type="file"]').hide();
    }

  });
</script>

<sj:dialog id="selectPersonListDialog" resizable="true" autoOpen="false"
           modal="true" width="500"/>

<sj:dialog id="confirmDialog" autoOpen="false" modal="true" width="500"/>
