/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.persistence.PollenPersistenceContext;
import org.chorem.pollen.persistence.entity.ChildFavoriteListDao;
import org.chorem.pollen.persistence.entity.ChoiceDao;
import org.chorem.pollen.persistence.entity.CommentDao;
import org.chorem.pollen.persistence.entity.EmailToResendDao;
import org.chorem.pollen.persistence.entity.FavoriteListDao;
import org.chorem.pollen.persistence.entity.FavoriteListMemberDao;
import org.chorem.pollen.persistence.entity.LoginProviderDao;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollDao;
import org.chorem.pollen.persistence.entity.PollEventDao;
import org.chorem.pollen.persistence.entity.PollFeedDao;
import org.chorem.pollen.persistence.entity.PollenPrincipalDao;
import org.chorem.pollen.persistence.entity.PollenResourceDao;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.PollenUserDao;
import org.chorem.pollen.persistence.entity.PollenUserEmailAddressDao;
import org.chorem.pollen.persistence.entity.QuestionDao;
import org.chorem.pollen.persistence.entity.ReportDao;
import org.chorem.pollen.persistence.entity.SessionTokenDao;
import org.chorem.pollen.persistence.entity.UserCredentialDao;
import org.chorem.pollen.persistence.entity.VoteDao;
import org.chorem.pollen.persistence.entity.VoteToChoiceDao;
import org.chorem.pollen.persistence.entity.VoterListDao;
import org.chorem.pollen.persistence.entity.VoterListMemberDao;
import org.chorem.pollen.services.PollenService;
import org.chorem.pollen.services.PollenServiceContext;
import org.chorem.pollen.services.PollenTechnicalException;
import org.chorem.pollen.services.PollenUrlProvider;
import org.chorem.pollen.services.bean.PollenBean;
import org.chorem.pollen.services.bean.PollenEntityId;
import org.chorem.pollen.services.config.PollenServicesConfig;
import org.chorem.pollen.services.service.ChoiceService;
import org.chorem.pollen.services.service.CommentService;
import org.chorem.pollen.services.service.CryptoService;
import org.chorem.pollen.services.service.DefaultUrlProvider;
import org.chorem.pollen.services.service.ErrorMap;
import org.chorem.pollen.services.service.FeedService;
import org.chorem.pollen.services.service.GtuService;
import org.chorem.pollen.services.service.NotificationService;
import org.chorem.pollen.services.service.PollService;
import org.chorem.pollen.services.service.PollenResourceService;
import org.chorem.pollen.services.service.PollenUIUrlRenderService;
import org.chorem.pollen.services.service.PollenUserService;
import org.chorem.pollen.services.service.QuestionService;
import org.chorem.pollen.services.service.ReportService;
import org.chorem.pollen.services.service.VoteCountingService;
import org.chorem.pollen.services.service.VoteService;
import org.chorem.pollen.services.service.VoterListService;
import org.chorem.pollen.services.service.mail.EmailService;
import org.chorem.pollen.services.service.security.PollenInvalidPermissionException;
import org.chorem.pollen.services.service.security.PollenPermission;
import org.chorem.pollen.services.service.security.PollenPermissionsHelper;
import org.chorem.pollen.services.service.security.PollenSecurityContext;
import org.chorem.pollen.services.service.security.SecurityService;
import org.nuiton.util.StringUtil;
import org.nuiton.util.pagination.PaginationParameter;

public abstract class PollenServiceSupport
implements PollenService {
    private static final Map<String, Object> ENTITY_LOCK_BY_ID = Maps.newHashMap();
    protected PollenServiceContext serviceContext;

    public static synchronized Object getLock(String id) {
        return ENTITY_LOCK_BY_ID.computeIfAbsent(id, id2 -> new Object());
    }

    @Override
    public void setServiceContext(PollenServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    protected Date getNow() {
        return this.serviceContext.getNow();
    }

    protected PollenSecurityContext getSecurityContext() {
        PollenSecurityContext securityContext = this.serviceContext.getSecurityContext();
        if (securityContext == null) {
            throw new PollenTechnicalException("SecurityContext must never be null, check logs for injection failure");
        }
        return securityContext;
    }

    protected String getCleanMail(String email) {
        return this.serviceContext.getCleanMail(email);
    }

    protected PollenPersistenceContext getPersistenceContext() {
        return this.serviceContext.getPersistenceContext();
    }

    protected PollenServicesConfig getPollenServiceConfig() {
        return this.serviceContext.getPollenServicesConfig();
    }

    protected Locale getLocale() {
        return this.serviceContext.getLocale();
    }

    public ChoiceService getChoiceService() {
        return this.newService(ChoiceService.class);
    }

    protected CommentService getCommentService() {
        return this.newService(CommentService.class);
    }

    protected EmailService getEmailService() {
        return this.newService(EmailService.class);
    }

    protected NotificationService getNotificationService() {
        return this.newService(NotificationService.class);
    }

    protected FeedService getFeedService() {
        return this.newService(FeedService.class);
    }

    protected GtuService getGtuService() {
        return this.newService(GtuService.class);
    }

    protected PollService getPollService() {
        return this.newService(PollService.class);
    }

    protected QuestionService getQuestionService() {
        return this.newService(QuestionService.class);
    }

    protected SecurityService getSecurityService() {
        return this.newService(SecurityService.class);
    }

    protected ReportService getReportService() {
        return this.newService(ReportService.class);
    }

    protected PollenResourceService getPollenResourceService() {
        return this.newService(PollenResourceService.class);
    }

    protected PollenUIUrlRenderService getPollenUIUrlRenderService() {
        return this.newService(PollenUIUrlRenderService.class);
    }

    protected PollenUserService getUserService() {
        return this.newService(PollenUserService.class);
    }

    protected VoteCountingService getVoteCountingService() {
        return this.newService(VoteCountingService.class);
    }

    protected VoterListService getVoterListService() {
        return this.newService(VoterListService.class);
    }

    protected VoteService getVoteService() {
        return this.newService(VoteService.class);
    }

    protected CryptoService getCryptoService() {
        return this.newService(CryptoService.class);
    }

    protected <E extends PollenService> E newService(Class<E> serviceClass) {
        return this.serviceContext.newService(serviceClass);
    }

    protected ChoiceDao getChoiceDao() {
        return this.getPersistenceContext().getChoiceDao();
    }

    protected CommentDao getCommentDao() {
        return this.getPersistenceContext().getCommentDao();
    }

    protected FavoriteListDao getFavoriteListDao() {
        return this.getPersistenceContext().getFavoriteListDao();
    }

    protected FavoriteListMemberDao getFavoriteListMemberDao() {
        return this.getPersistenceContext().getFavoriteListMemberDao();
    }

    protected ChildFavoriteListDao getChildFavoriteListDao() {
        return this.getPersistenceContext().getChildFavoriteListDao();
    }

    protected PollDao getPollDao() {
        return this.getPersistenceContext().getPollDao();
    }

    protected PollEventDao getPollEventDao() {
        return this.getPersistenceContext().getPollEventDao();
    }

    protected PollFeedDao getPollFeedDao() {
        return this.getPersistenceContext().getPollFeedDao();
    }

    protected QuestionDao getQuestionDao() {
        return this.getPersistenceContext().getQuestionDao();
    }

    protected PollenPrincipalDao getPollenPrincipalDao() {
        return this.getPersistenceContext().getPollenPrincipalDao();
    }

    protected PollenResourceDao getPollenResourceDao() {
        return this.getPersistenceContext().getPollenResourceDao();
    }

    protected PollenUserDao getPollenUserDao() {
        return this.getPersistenceContext().getPollenUserDao();
    }

    protected PollenUserEmailAddressDao getPollenUserEmailAddressDao() {
        return this.getPersistenceContext().getPollenUserEmailAddressDao();
    }

    protected UserCredentialDao getUserCredentialDao() {
        return this.getPersistenceContext().getUserCredentialDao();
    }

    protected ReportDao getReportDao() {
        return this.getPersistenceContext().getReportDao();
    }

    protected SessionTokenDao getSessionTokenDao() {
        return this.getPersistenceContext().getSessionTokenDao();
    }

    protected VoteDao getVoteDao() {
        return this.getPersistenceContext().getVoteDao();
    }

    protected VoteToChoiceDao getVoteToChoiceDao() {
        return this.getPersistenceContext().getVoteToChoiceDao();
    }

    protected VoterListDao getVoterListDao() {
        return this.getPersistenceContext().getVoterListDao();
    }

    protected VoterListMemberDao getVoterListMemberDao() {
        return this.getPersistenceContext().getVoterListMemberDao();
    }

    protected LoginProviderDao getLoginProviderDao() {
        return this.getPersistenceContext().getLoginProviderDao();
    }

    protected EmailToResendDao getEmailToResendDao() {
        return this.getPersistenceContext().getEmailToResendDao();
    }

    public void commit() {
        this.getPersistenceContext().commit();
    }

    public void checkIsConnected() {
        this.getSecurityService().checkIsConnected();
    }

    public void checkIsConnectedRequired() {
        this.getSecurityService().checkIsConnectedRequired();
    }

    public void checkIsAdmin() {
        this.getSecurityService().checkIsAdmin();
    }

    protected boolean isPermitted(PollenPermission permission) {
        PollenPermissionsHelper helper = this.newService(PollenPermissionsHelper.class);
        return permission.isPermitted(helper);
    }

    protected boolean isNotPermitted(PollenPermission permission) {
        return !this.isPermitted(permission);
    }

    protected void checkPermission(PollenPermission permission) {
        if (this.isNotPermitted(permission)) {
            throw new PollenInvalidPermissionException(permission.toString());
        }
    }

    protected void checkNotNull(Object object) {
        Preconditions.checkNotNull((Object)object);
    }

    protected void checkIsPersisted(PollenEntity entity) {
        Preconditions.checkState((boolean)entity.isPersisted());
    }

    protected void checkIsPersisted(PollenBean<?> bean) {
        Preconditions.checkState((boolean)bean.isPersisted());
    }

    protected void checkIsNotPersisted(PollenBean<?> bean) {
        Preconditions.checkState((!bean.isPersisted() ? 1 : 0) != 0);
    }

    protected void checkState(boolean test) {
        Preconditions.checkState((boolean)test);
    }

    protected boolean checkNotNull(ErrorMap errors, String field, Object value, String error) {
        return this.check(errors, field, value != null, error);
    }

    protected boolean checkNotBlank(ErrorMap errors, String field, String value, String error) {
        return this.check(errors, field, StringUtils.isNotBlank((CharSequence)value), error);
    }

    protected boolean checkValidEmail(ErrorMap errors, String field, String value, String error) {
        return this.check(errors, field, StringUtil.isEmail((String)value), error);
    }

    protected boolean checkEmailPattern(ErrorMap errors, String field, String value, String error) {
        String emailAddressPatternForRegistration = this.getPollenServiceConfig().getEmailAddressPatternForRegistration();
        return this.check(errors, field, emailAddressPatternForRegistration == null || value != null && value.matches(emailAddressPatternForRegistration), error);
    }

    protected boolean check(ErrorMap errors, String field, boolean condition, String error) {
        if (!condition) {
            errors.addError(field, error);
        }
        return condition;
    }

    protected PollenUser getConnectedUser() {
        return this.serviceContext.getSecurityContext().getPollenUser().orElse(null);
    }

    protected PollenUser checkAndGetConnectedUser() {
        this.checkIsConnected();
        return this.getConnectedUser();
    }

    protected PollenUrlProvider pollenUrlHelper() {
        return new DefaultUrlProvider(this.serviceContext.getUIContext(), this.getPollenServiceConfig());
    }

    protected <E extends PollenEntity> PollenEntityId<E> getPollenEntityId(E entity) {
        PollenEntityId pollenEntityId = PollenEntityId.newId(entity.getClass());
        pollenEntityId.setEntityId(entity.getTopiaId());
        pollenEntityId.encode();
        return pollenEntityId;
    }

    protected String getPollVoteUrl(Poll poll) {
        return this.getPollVoteUrl(this.getPollenEntityId(poll), null);
    }

    protected String getPollVoteUrl(Poll poll, String token) {
        return this.getPollVoteUrl(this.getPollenEntityId(poll), token);
    }

    protected String getPollVoteUrl(PollenEntityId<Poll> pollId, String token) {
        return this.getPollenUIUrlRenderService().getPollVoteUrl(this.pollenUrlHelper().getPollVoteUrl(), pollId.getReducedId(), token);
    }

    protected static PaginationParameter orderedPage(PaginationParameter page) {
        return PollenServiceSupport.orderedPage(page, "topiaCreateDate", true);
    }

    protected static PaginationParameter orderedPage(PaginationParameter page, String defaultOrderClause) {
        return PollenServiceSupport.orderedPage(page, defaultOrderClause, false);
    }

    protected static PaginationParameter orderedPage(PaginationParameter page, String defaultOrderClause, boolean desc) {
        if (page.getOrderClauses().isEmpty()) {
            return PaginationParameter.of((int)page.getPageNumber(), (int)page.getPageSize(), (String)defaultOrderClause, (boolean)desc);
        }
        return page;
    }

    protected OffsetDateTime toOffsetDateTime(Date date) {
        if (date == null) {
            return null;
        }
        Instant instant = date.toInstant();
        ZoneOffset zoneOffset = ZoneId.systemDefault().getRules().getOffset(Instant.now());
        return instant.atOffset(zoneOffset);
    }
}

