/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.bean;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Objects;
import org.chorem.pollen.persistence.PollenEntity;
import org.chorem.pollen.services.bean.PollenEntityId;

public abstract class PollenBean<E extends PollenEntity> {
    protected final Class<E> entityType;
    protected PollenEntityId<E> id;

    protected PollenBean(Class<E> entityType) {
        this.entityType = entityType;
        this.id = PollenEntityId.newId(entityType);
    }

    public void setId(PollenEntityId<E> id) {
        if (id == null) {
            this.id.setEntityId(null);
            this.id.setReducedId(null);
        } else {
            this.id = id;
        }
    }

    @JsonIgnore
    public boolean isPersisted() {
        return this.id != null && this.id.isNotEmpty() && !this.id.isTemporaryId();
    }

    @JsonIgnore
    public String getEntityId() {
        return this.id.getEntityId();
    }

    public PollenEntityId<E> getId() {
        return this.id;
    }

    @JsonIgnore
    public boolean isTemporaryId() {
        return this.id.isTemporaryId();
    }

    public void setEntityId(String id) {
        this.id.setEntityId(id);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof PollenBean && Objects.equals(this.id, ((PollenBean)o).id);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }
}

