/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.pollen.services.service;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.AbstractPollenEntity;
import org.chorem.pollen.persistence.entity.Poll;
import org.chorem.pollen.persistence.entity.PollenResource;
import org.chorem.pollen.persistence.entity.PollenUser;
import org.chorem.pollen.persistence.entity.ResourceType;
import org.chorem.pollen.services.bean.resource.GtuMetaBean;
import org.chorem.pollen.services.bean.resource.ResourceStreamBean;
import org.chorem.pollen.services.service.PollenServiceSupport;
import org.nuiton.util.pagination.PaginationOrder;

public class GtuService
extends PollenServiceSupport {
    public GtuMetaBean toGtuMetaBean(PollenResource entity) {
        GtuMetaBean bean = new GtuMetaBean();
        bean.setEntityId(entity.getTopiaId());
        bean.setName(entity.getName());
        bean.setSize(entity.getSize());
        bean.setContentType(entity.getContentType());
        bean.setResourceType(entity.getResourceType());
        bean.setUploadDate(entity.getTopiaCreateDate());
        return bean;
    }

    public ResourceStreamBean getCurrentGtu() {
        return this.getCurrentGtu0().map(this.getPollenResourceService()::toResourceStreamBean).orElse(null);
    }

    public List<GtuMetaBean> getAllGtus() {
        this.checkIsAdmin();
        List gtus = this.getPollenResourceDao().forResourceTypeEquals(ResourceType.GTU).setOrderByArguments(new String[]{"topiaCreateDate"}).findAll();
        ImmutableList<GtuMetaBean> gtuMetaBeans = this.toBeanList(gtus, this::toGtuMetaBean);
        if (CollectionUtils.isNotEmpty((Collection)gtus)) {
            ((GtuMetaBean)gtuMetaBeans.getLast()).setCurrent(true);
        }
        return gtuMetaBeans;
    }

    public boolean isGtu() {
        return this.getPollenResourceDao().forResourceTypeEquals(ResourceType.GTU).exists();
    }

    protected Optional<PollenResource> getCurrentGtu0() {
        PaginationOrder order = new PaginationOrder("topiaCreateDate", true);
        return this.getPollenResourceDao().forResourceTypeEquals(ResourceType.GTU).setOrderByArguments(Collections.singleton(order)).tryFindFirst();
    }

    public boolean isGtuValidated(PollenUser user) {
        this.checkIsConnectedRequired();
        return this.isGtuValidatedForDate(user.getGtuValidationDate());
    }

    protected boolean isGtuValidatedForDate(Date validationDate) {
        return this.getCurrentGtu0().map(AbstractPollenEntity::getTopiaCreateDate).map(date -> validationDate != null && date.before(validationDate)).orElse(true);
    }

    public boolean isGtuValidated(Poll poll) {
        this.checkIsConnectedRequired();
        PollenUser user = poll.getCreator().getPollenUser();
        boolean validated = user != null ? this.isGtuValidated(user) : this.isGtuValidatedForDate(poll.getGtuValidationDate());
        return validated;
    }

    public void validateGtu() {
        PollenUser connectedUser = this.checkAndGetConnectedUser();
        connectedUser.setGtuValidationDate(this.getNow());
        this.commit();
    }
}

