/*
 * Decompiled with CFR 0.152.
 */
package db.migration.common;

import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.collections4.CollectionUtils;
import org.chorem.pollen.persistence.entity.PollEvent;
import org.chorem.pollen.persistence.topia.TopiaIdFactory;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V3_5_0_8__Migrate_poll_feeds
extends BaseJavaMigration {
    private static final Logger log = LoggerFactory.getLogger(V3_5_0_8__Migrate_poll_feeds.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Context context) throws SQLException {
        Connection connection = context.getConnection();
        PreparedStatement insertStatement = null;
        Statement updateStatement = null;
        ResultSet resultSet = null;
        try (ResultSet countResultSet = connection.createStatement().executeQuery(" SELECT count(p.topia_id) FROM poll p WHERE p.feed_content IS NOT NULL ");){
            countResultSet.next();
            log.info("Starting migration of {} feeds...", (Object)countResultSet.getLong(1));
        }
        int feeds = 0;
        int events = 0;
        try {
            connection.setAutoCommit(false);
            insertStatement = connection.prepareStatement("INSERT INTO poll_event (topia_id, topia_version, topia_create_date, poll, title) VALUES (?, 0, ?, ?, ?)");
            updateStatement = connection.prepareStatement("UPDATE poll SET feed_content = NULL WHERE topia_id = ?");
            resultSet = connection.createStatement().executeQuery(" SELECT p.topia_id, p.feed_content FROM poll p WHERE p.feed_content IS NOT NULL ");
            while (resultSet.next()) {
                String pollId = resultSet.getString(1);
                String feedContent = resultSet.getString(2);
                try {
                    SyndFeedInput feedInput = new SyndFeedInput(true, Locale.FRENCH);
                    SyndFeed feed = feedInput.build((Reader)new StringReader(feedContent));
                    List entries = feed.getEntries();
                    if (CollectionUtils.isNotEmpty((Collection)entries)) {
                        entries.removeFirst();
                        for (SyndEntry entry : entries) {
                            Date publishedDate = entry.getPublishedDate();
                            String title = entry.getTitle();
                            insertStatement.setString(1, TopiaIdFactory.newTopiaId(PollEvent.class));
                            insertStatement.setTimestamp(2, new Timestamp(publishedDate.getTime()));
                            insertStatement.setString(3, pollId);
                            insertStatement.setString(4, title);
                            insertStatement.addBatch();
                            ++events;
                        }
                    }
                    updateStatement.setString(1, pollId);
                    updateStatement.addBatch();
                    ++feeds;
                }
                catch (Exception e) {
                    log.error("Unable to process feed for Poll '{}'", (Object)pollId, (Object)e);
                }
            }
            resultSet.close();
            insertStatement.executeBatch();
            updateStatement.executeBatch();
            connection.commit();
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
            if (insertStatement != null) {
                insertStatement.close();
            }
            if (updateStatement != null) {
                updateStatement.close();
            }
        }
        log.info("{} feeds migrated ({} events created)", (Object)feeds, (Object)events);
    }
}

