package org.chorem.pollen.entities;

import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VotingList;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.util.TopiaEntityBinder;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;
import org.nuiton.util.beans.BinderFactory;
import org.nuiton.util.beans.BinderModelBuilder;

public class PollenBinderHelper extends BinderFactory {

    public static <E extends TopiaEntity> TopiaEntityBinder<E> getTopiaBinder(Class<E> entityClass, String contextName) {
        return (TopiaEntityBinder<E>) newBinder(entityClass, entityClass, contextName, TopiaEntityBinder.class);
    }

    public static <E extends TopiaEntity> TopiaEntityBinder<E> getSimpleTopiaBinder(Class<E> entityClass) {
        return getTopiaBinder(entityClass, "Pollen");
    }

    public static void registerTopiaBinder(BinderModelBuilder builder, String contextName) {
       registerBinderModel(builder, contextName);
    }

    public static <E extends TopiaEntity> TopiaEntityBinder<E> registerTopiaBinder(Class<E> entityClass, BinderModelBuilder builder, String contextName) {
       registerBinderModel(builder, contextName);
       return getTopiaBinder(entityClass, contextName);
    }

    public static <E extends TopiaEntity> void copy(String contextName, E source, E target, boolean tech) {
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(PollenDAOHelper.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getTopiaBinder(entityClass, contextName);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }

    public static <E extends TopiaEntity> void simpleCopy(E source, E target, boolean tech) {
        Class<E> entityClass = (Class<E>) TopiaEntityHelper.getContractClass(PollenDAOHelper.getContracts(), target.getClass());
        TopiaEntityBinder<E> binder = getSimpleTopiaBinder(entityClass);
        if (binder == null) {
            throw new NullPointerException("could not find a simple topia binder of type : " + target.getClass());
        }
        binder.load(source, target, tech);
    }

    protected static void initBinders() {
        BinderModelBuilder<Choice, Choice> builderChoice =
            BinderModelBuilder.newEmptyBuilder(Choice.class);
        builderChoice.addSimpleProperties(
            Choice.PROPERTY_NAME,
            Choice.PROPERTY_DESCRIPTION,
            Choice.PROPERTY_VALIDATE
        );
        registerTopiaBinder(builderChoice, "Pollen");
    
        BinderModelBuilder<Comment, Comment> builderComment =
            BinderModelBuilder.newEmptyBuilder(Comment.class);
        builderComment.addSimpleProperties(
            Comment.PROPERTY_TEXT,
            Comment.PROPERTY_POST_DATE,
            Comment.PROPERTY_AUTHOR,
            Comment.PROPERTY_POLL_ACCOUNT
        );
        registerTopiaBinder(builderComment, "Pollen");
    
        BinderModelBuilder<PersonList, PersonList> builderPersonList =
            BinderModelBuilder.newEmptyBuilder(PersonList.class);
        builderPersonList.addSimpleProperties(
            PersonList.PROPERTY_NAME,
            PersonList.PROPERTY_OWNER
        );
        registerTopiaBinder(builderPersonList, "Pollen");
    
        BinderModelBuilder<PersonToList, PersonToList> builderPersonToList =
            BinderModelBuilder.newEmptyBuilder(PersonToList.class);
        builderPersonToList.addSimpleProperties(
            PersonToList.PROPERTY_WEIGHT,
            PersonToList.PROPERTY_HAS_VOTED
        );
        registerTopiaBinder(builderPersonToList, "Pollen");
    
        BinderModelBuilder<Poll, Poll> builderPoll =
            BinderModelBuilder.newEmptyBuilder(Poll.class);
        builderPoll.addSimpleProperties(
            Poll.PROPERTY_POLL_ID,
            Poll.PROPERTY_TITLE,
            Poll.PROPERTY_DESCRIPTION,
            Poll.PROPERTY_BEGIN_CHOICE_DATE,
            Poll.PROPERTY_BEGIN_DATE,
            Poll.PROPERTY_END_DATE,
            Poll.PROPERTY_MAX_CHOICE_NB,
            Poll.PROPERTY_CLOSED,
            Poll.PROPERTY_CHOICE_ADD_ALLOWED,
            Poll.PROPERTY_ANONYMOUS_VOTE_ALLOWED,
            Poll.PROPERTY_PUBLIC_RESULTS,
            Poll.PROPERTY_CONTINUOUS_RESULTS,
            Poll.PROPERTY_END_CHOICE_DATE,
            Poll.PROPERTY_VOTE_COUNTING_TYPE,
            Poll.PROPERTY_CREATOR,
            Poll.PROPERTY_POLL_TYPE,
            Poll.PROPERTY_CHOICE_TYPE,
            Poll.PROPERTY_POLL_VOTE_VISIBILITY,
            Poll.PROPERTY_POLL_COMMENT_VISIBILITY
        );
        registerTopiaBinder(builderPoll, "Pollen");
    
        BinderModelBuilder<PollAccount, PollAccount> builderPollAccount =
            BinderModelBuilder.newEmptyBuilder(PollAccount.class);
        builderPollAccount.addSimpleProperties(
            PollAccount.PROPERTY_ACCOUNT_ID,
            PollAccount.PROPERTY_VOTING_ID,
            PollAccount.PROPERTY_EMAIL,
            PollAccount.PROPERTY_PERSON_LIST,
            PollAccount.PROPERTY_USER_ACCOUNT
        );
        registerTopiaBinder(builderPollAccount, "Pollen");
    
        BinderModelBuilder<PreventRule, PreventRule> builderPreventRule =
            BinderModelBuilder.newEmptyBuilder(PreventRule.class);
        builderPreventRule.addSimpleProperties(
            PreventRule.PROPERTY_SCOPE,
            PreventRule.PROPERTY_SENSIBILITY,
            PreventRule.PROPERTY_REPEATED,
            PreventRule.PROPERTY_ACTIVE,
            PreventRule.PROPERTY_ONE_TIME,
            PreventRule.PROPERTY_METHOD
        );
        registerTopiaBinder(builderPreventRule, "Pollen");
    
        BinderModelBuilder<UserAccount, UserAccount> builderUserAccount =
            BinderModelBuilder.newEmptyBuilder(UserAccount.class);
        builderUserAccount.addSimpleProperties(
            UserAccount.PROPERTY_LOGIN,
            UserAccount.PROPERTY_PASSWORD,
            UserAccount.PROPERTY_FIRST_NAME,
            UserAccount.PROPERTY_LAST_NAME,
            UserAccount.PROPERTY_ADMINISTRATOR,
            UserAccount.PROPERTY_LANGUAGE,
            UserAccount.PROPERTY_EMAIL
        );
        registerTopiaBinder(builderUserAccount, "Pollen");
    
        BinderModelBuilder<Vote, Vote> builderVote =
            BinderModelBuilder.newEmptyBuilder(Vote.class);
        builderVote.addSimpleProperties(
            Vote.PROPERTY_WEIGHT,
            Vote.PROPERTY_COMMENT,
            Vote.PROPERTY_ANONYMOUS,
            Vote.PROPERTY_POLL_ACCOUNT
        );
        registerTopiaBinder(builderVote, "Pollen");
    
        BinderModelBuilder<VoteToChoice, VoteToChoice> builderVoteToChoice =
            BinderModelBuilder.newEmptyBuilder(VoteToChoice.class);
        builderVoteToChoice.addSimpleProperties(
            VoteToChoice.PROPERTY_VOTE_VALUE
        );
        registerTopiaBinder(builderVoteToChoice, "Pollen");
    
        BinderModelBuilder<VotingList, VotingList> builderVotingList =
            BinderModelBuilder.newEmptyBuilder(VotingList.class);
        builderVotingList.addSimpleProperties(
            VotingList.PROPERTY_NAME,
            VotingList.PROPERTY_WEIGHT,
            VotingList.PROPERTY_VOTE
        );
        registerTopiaBinder(builderVotingList, "Pollen");
    }

    static {
    
    initBinders();

    }

} //PollenBinderHelper
