package org.chorem.pollen.entities;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.chorem.pollen.business.persistence.Choice;
import org.chorem.pollen.business.persistence.ChoiceDAO;
import org.chorem.pollen.business.persistence.Comment;
import org.chorem.pollen.business.persistence.CommentDAO;
import org.chorem.pollen.business.persistence.PersonList;
import org.chorem.pollen.business.persistence.PersonListDAO;
import org.chorem.pollen.business.persistence.PersonToList;
import org.chorem.pollen.business.persistence.PersonToListDAO;
import org.chorem.pollen.business.persistence.Poll;
import org.chorem.pollen.business.persistence.PollAccount;
import org.chorem.pollen.business.persistence.PollAccountDAO;
import org.chorem.pollen.business.persistence.PollDAO;
import org.chorem.pollen.business.persistence.PreventRule;
import org.chorem.pollen.business.persistence.PreventRuleDAO;
import org.chorem.pollen.business.persistence.Result;
import org.chorem.pollen.business.persistence.ResultDAO;
import org.chorem.pollen.business.persistence.UserAccount;
import org.chorem.pollen.business.persistence.UserAccountDAO;
import org.chorem.pollen.business.persistence.Vote;
import org.chorem.pollen.business.persistence.VoteDAO;
import org.chorem.pollen.business.persistence.VoteToChoice;
import org.chorem.pollen.business.persistence.VoteToChoiceDAO;
import org.chorem.pollen.business.persistence.VotingList;
import org.chorem.pollen.business.persistence.VotingListDAO;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.persistence.util.EntityOperatorStore;

public class PollenDAOHelper {

    public enum PollenEntityEnum implements TopiaEntityEnum {
        Choice(Choice.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Comment(Comment.class, ArrayUtils.EMPTY_STRING_ARRAY),
        PersonList(PersonList.class, ArrayUtils.EMPTY_STRING_ARRAY),
        PersonToList(PersonToList.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Poll(Poll.class, new String[]{ "pollId" }, "pollId"),
        PollAccount(PollAccount.class, ArrayUtils.EMPTY_STRING_ARRAY),
        PreventRule(PreventRule.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Result(Result.class, ArrayUtils.EMPTY_STRING_ARRAY),
        UserAccount(UserAccount.class, ArrayUtils.EMPTY_STRING_ARRAY),
        Vote(Vote.class, ArrayUtils.EMPTY_STRING_ARRAY),
        VoteToChoice(VoteToChoice.class, ArrayUtils.EMPTY_STRING_ARRAY),
        VotingList(VotingList.class, ArrayUtils.EMPTY_STRING_ARRAY);

        /**
         * The contract of the entity.
         */
        protected Class<? extends TopiaEntity> contract;

        /**
         * The fully qualified name of the implementation of the entity.
         */
        protected String implementationFQN;

        /**
         * The implementation class of the entity (will be lazy computed at runtime).
         */
        protected Class<? extends TopiaEntity> implementation;

        /**
         * The array of property involved in the natural key of the entity.
         */
        protected String[] naturalIds;

        /**
         * The array of not null properties of the entity.
         */
        protected String[] notNulls;

        PollenEntityEnum(Class<? extends TopiaEntity > contract, String[] notNulls, String... naturalIds)     {
        this.contract = contract;
        this.notNulls = notNulls;
        this.naturalIds = naturalIds;
        implementationFQN = contract.getName() + "Impl";
        }

        @Override
        public Class<? extends TopiaEntity> getContract()     {
        return contract;
        }

        @Override
        public String[] getNaturalIds()     {
        return naturalIds;
        }

        @Override
        public boolean isUseNaturalIds()     {
        return naturalIds.length > 0;
        }

        @Override
        public String[] getNotNulls()     {
        return notNulls;
        }

        @Override
        public boolean isUseNotNulls()     {
        return notNulls.length > 0;
        }

        @Override
        public String getImplementationFQN()     {
        return implementationFQN;
        }

        @Override
        public void setImplementationFQN(String implementationFQN)     {
        this.implementationFQN = implementationFQN;
        this.implementation = null;
        }

        @Override
        public boolean accept(Class<? extends TopiaEntity> klass)     {
        return PollenDAOHelper.getContractClass(klass) == contract;
        }

        @Override
        public Class<? extends TopiaEntity> getImplementation()     {
        if (implementation == null) {
        try {
                implementation = (Class<? extends TopiaEntity>) Class.forName(implementationFQN);
            } catch (ClassNotFoundException e) {
                throw new TopiaRuntimeException("could not find class " + implementationFQN, e);
            }
        }
        return implementation;
        }

        public static PollenEntityEnum valueOf(TopiaEntity entity)     {
        return valueOf(entity.getClass());
        }

        public static PollenEntityEnum valueOf(Class<?> klass)     {
        if (klass.isInterface()) {
           return valueOf(klass.getSimpleName());
        }
        for (PollenEntityEnum entityEnum : PollenEntityEnum.values()) {
            if (entityEnum.getContract().isAssignableFrom(klass)) {
                //todo check it works for inheritance
                return entityEnum;
            }
        }
        throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString(PollenEntityEnum.values()));
        }

    } //PollenEntityEnum

    protected PollenDAOHelper() { }

    public static String getModelVersion() {
        return "1.4.5";
    }

    public static String getModelName() {
        return "Pollen";
    }

    public static ChoiceDAO getChoiceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ChoiceDAO result = ci.getDAO(Choice.class, ChoiceDAO.class);
        return result;
    }

    public static CommentDAO getCommentDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        CommentDAO result = ci.getDAO(Comment.class, CommentDAO.class);
        return result;
    }

    public static PersonListDAO getPersonListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonListDAO result = ci.getDAO(PersonList.class, PersonListDAO.class);
        return result;
    }

    public static PersonToListDAO getPersonToListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PersonToListDAO result = ci.getDAO(PersonToList.class, PersonToListDAO.class);
        return result;
    }

    public static PollDAO getPollDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollDAO result = ci.getDAO(Poll.class, PollDAO.class);
        return result;
    }

    public static PollAccountDAO getPollAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollAccountDAO result = ci.getDAO(PollAccount.class, PollAccountDAO.class);
        return result;
    }

    public static PreventRuleDAO getPreventRuleDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PreventRuleDAO result = ci.getDAO(PreventRule.class, PreventRuleDAO.class);
        return result;
    }

    public static ResultDAO getResultDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        ResultDAO result = ci.getDAO(Result.class, ResultDAO.class);
        return result;
    }

    public static UserAccountDAO getUserAccountDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        UserAccountDAO result = ci.getDAO(UserAccount.class, UserAccountDAO.class);
        return result;
    }

    public static VoteDAO getVoteDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VoteDAO result = ci.getDAO(Vote.class, VoteDAO.class);
        return result;
    }

    public static VoteToChoiceDAO getVoteToChoiceDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VoteToChoiceDAO result = ci.getDAO(VoteToChoice.class, VoteToChoiceDAO.class);
        return result;
    }

    public static VotingListDAO getVotingListDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        VotingListDAO result = ci.getDAO(VotingList.class, VotingListDAO.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollenEntityEnum constant = PollenEntityEnum.valueOf(klass);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor) context;
        PollenEntityEnum constant = PollenEntityEnum.valueOf(entity);
        D dao = (D) ci.getDAO(constant.getContract());
        return dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        PollenEntityEnum constant = PollenEntityEnum.valueOf(klass);
        return (Class<T>) constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        PollenEntityEnum constant = PollenEntityEnum.valueOf(klass);
        return (Class<T>) constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        PollenEntityEnum[] values = PollenEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        PollenEntityEnum[] values = PollenEntityEnum.values();
        Class<? extends TopiaEntity>[] result = (Class<? extends TopiaEntity>[]) Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; i++) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static PollenEntityEnum[] getContracts() {
        return PollenEntityEnum.values();
    }

} //PollenDAOHelper
