package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.chorem.pollen.entities.PollenDAOHelper.PollenEntityEnum;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;

public abstract class VotingListDAOAbstract<E extends VotingList> extends TopiaDAOImpl<E> {

    @Override
    public Class<E> getEntityClass() {
        return (Class<E>)VotingList.class;
    }

    @Override
    public PollenEntityEnum getTopiaEntityEnum() {
        return PollenEntityEnum.VotingList;
    }

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_NAME, v);
        return result;
    }

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_NAME, v);
        return result;
    }

    public E findByWeight(double v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_WEIGHT, v);
        return result;
    }

    public List<E> findAllByWeight(double v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_WEIGHT, v);
        return result;
    }

    public E findByVote(Vote v) throws TopiaException {
        E result = findByProperty(VotingList.PROPERTY_VOTE, v);
        return result;
    }

    public List<E> findAllByVote(Vote v) throws TopiaException {
        List<E> result = findAllByProperty(VotingList.PROPERTY_VOTE, v);
        return result;
    }

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Poll.class) {
            PollDAO dao = (PollDAO)
                getContext().getDAO(Poll.class);
            tmp = dao.findAllContainsVotingList(entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);

        List<? extends TopiaEntity> list;

        list = findUsages(Poll.class, entity);
        if (!list.isEmpty()) {
            result.put(Poll.class, list);
        }

        return result;
    }

} //VotingListDAOAbstract<E extends VotingList>
