/*
 * #%L
 * Pollen :: Persistence
 * $Id: UserAccountDAOImpl.java 3616 2012-08-19 11:18:22Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/pollen/tags/pollen-1.4.5.1/pollen-persistence/src/main/java/org/chorem/pollen/business/persistence/UserAccountDAOImpl.java $
 * %%
 * Copyright (C) 2009 - 2012 CodeLutin, Tony Chemit
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package org.chorem.pollen.business.persistence;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaFilterPagerUtil;

import java.util.List;

public class UserAccountDAOImpl<E extends UserAccount> extends UserAccountDAOAbstract<E> {

    public boolean isUserExist(UserAccount user) throws TopiaException {

        Preconditions.checkNotNull(user);

        // In case of email change, check if an other user has not already
        // the new email
        // FIXME-fdesbois-20100510 : replace by using id directly
        String hql = "SELECT COUNT(*) FROM UserAccountImpl WHERE " +
                     "login = :login AND email = :email";

        boolean result = existsByQuery(
                hql,
                "login", user.getLogin(),
                "email", StringUtils.lowerCase(user.getEmail()));
        return result;
    }

    public List<E> findUsers(TopiaFilterPagerUtil.FilterPagerBean pager) throws TopiaException {

        Preconditions.checkNotNull(pager);

        String countHql = "SELECT COUNT(*) FROM UserAccountImpl";

        computeAndAddRecordsToPager(countHql, pager);

        String hql = "FROM UserAccountImpl";

        List<E> result = findAllByQueryAndPager(hql, pager);
        return result;
    }
}
