package org.chorem.pollen.business.persistence;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.chorem.pollen.common.ChoiceType;
import org.chorem.pollen.common.PollType;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;
import org.nuiton.topia.persistence.util.TopiaEntityHelper;

public abstract class PollAbstract extends TopiaEntityAbstract implements Poll {

    /**
     * Nom de l'attribut en BD : pollId
     */
    protected String pollId;

    /**
     * Nom de l'attribut en BD : title
     */
    protected String title;

    /**
     * Nom de l'attribut en BD : description
     */
    protected String description;

    /**
     * Nom de l'attribut en BD : beginChoiceDate
     */
    protected Date beginChoiceDate;

    /**
     * Nom de l'attribut en BD : beginDate
     */
    protected Date beginDate;

    /**
     * Nom de l'attribut en BD : endDate
     */
    protected Date endDate;

    /**
     * Nom de l'attribut en BD : maxChoiceNb
     */
    protected int maxChoiceNb;

    /**
     * Nom de l'attribut en BD : closed
     */
    protected boolean closed;

    /**
     * Nom de l'attribut en BD : choiceAddAllowed
     */
    protected boolean choiceAddAllowed;

    /**
     * Nom de l'attribut en BD : anonymousVoteAllowed
     */
    protected boolean anonymousVoteAllowed;

    /**
     * Nom de l'attribut en BD : publicResults
     */
    protected boolean publicResults;

    /**
     * Nom de l'attribut en BD : continuousResults
     */
    protected boolean continuousResults;

    /**
     * Nom de l'attribut en BD : endChoiceDate
     */
    protected Date endChoiceDate;

    /**
     * Nom de l'attribut en BD : resultUptodate
     */
    protected boolean resultUptodate;

    /**
     * Nom de l'attribut en BD : voteCountingType
     */
    protected int voteCountingType;

    /**
     * Nom de l'attribut en BD : vote
     */
    protected List<Vote> vote;

    /**
     * Nom de l'attribut en BD : choice
     */
    protected List<Choice> choice;

    /**
     * Nom de l'attribut en BD : result
     */
    protected List<Result> result;

    /**
     * Nom de l'attribut en BD : creator
     */
    protected PollAccount creator;

    /**
     * Nom de l'attribut en BD : comment
     */
    protected List<Comment> comment;

    /**
     * Nom de l'attribut en BD : preventRule
     */
    protected List<PreventRule> preventRule;

    /**
     * Nom de l'attribut en BD : votingList
     */
    protected List<VotingList> votingList;

    /**
     * Nom de l'attribut en BD : pollType
     */
    protected PollType pollType;

    /**
     * Nom de l'attribut en BD : choiceType
     */
    protected ChoiceType choiceType;

    /**
     * Nom de l'attribut en BD : pollVoteVisibility
     */
    protected PollVoteVisibility pollVoteVisibility;

    /**
     * Nom de l'attribut en BD : pollCommentVisibility
     */
    protected PollCommentVisibility pollCommentVisibility;

    private static final long serialVersionUID = 3834306242417997618L;

    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, PROPERTY_POLL_ID, String.class, pollId);
        visitor.visit(this, PROPERTY_TITLE, String.class, title);
        visitor.visit(this, PROPERTY_DESCRIPTION, String.class, description);
        visitor.visit(this, PROPERTY_BEGIN_CHOICE_DATE, Date.class, beginChoiceDate);
        visitor.visit(this, PROPERTY_BEGIN_DATE, Date.class, beginDate);
        visitor.visit(this, PROPERTY_END_DATE, Date.class, endDate);
        visitor.visit(this, PROPERTY_MAX_CHOICE_NB, int.class, maxChoiceNb);
        visitor.visit(this, PROPERTY_CLOSED, boolean.class, closed);
        visitor.visit(this, PROPERTY_CHOICE_ADD_ALLOWED, boolean.class, choiceAddAllowed);
        visitor.visit(this, PROPERTY_ANONYMOUS_VOTE_ALLOWED, boolean.class, anonymousVoteAllowed);
        visitor.visit(this, PROPERTY_PUBLIC_RESULTS, boolean.class, publicResults);
        visitor.visit(this, PROPERTY_CONTINUOUS_RESULTS, boolean.class, continuousResults);
        visitor.visit(this, PROPERTY_END_CHOICE_DATE, Date.class, endChoiceDate);
        visitor.visit(this, PROPERTY_RESULT_UPTODATE, boolean.class, resultUptodate);
        visitor.visit(this, PROPERTY_VOTE_COUNTING_TYPE, int.class, voteCountingType);
        visitor.visit(this, PROPERTY_VOTE, List.class, Vote.class, vote);
        visitor.visit(this, PROPERTY_CHOICE, List.class, Choice.class, choice);
        visitor.visit(this, PROPERTY_RESULT, List.class, Result.class, result);
        visitor.visit(this, PROPERTY_CREATOR, PollAccount.class, creator);
        visitor.visit(this, PROPERTY_COMMENT, List.class, Comment.class, comment);
        visitor.visit(this, PROPERTY_PREVENT_RULE, List.class, PreventRule.class, preventRule);
        visitor.visit(this, PROPERTY_VOTING_LIST, List.class, VotingList.class, votingList);
        visitor.visit(this, PROPERTY_POLL_TYPE, PollType.class, pollType);
        visitor.visit(this, PROPERTY_CHOICE_TYPE, ChoiceType.class, choiceType);
        visitor.visit(this, PROPERTY_POLL_VOTE_VISIBILITY, PollVoteVisibility.class, pollVoteVisibility);
        visitor.visit(this, PROPERTY_POLL_COMMENT_VISIBILITY, PollCommentVisibility.class, pollCommentVisibility);
        visitor.end(this);
    }

    @Override
    public void setPollId(String pollId) {
        String oldValue = this.pollId;
        fireOnPreWrite(PROPERTY_POLL_ID, oldValue, pollId);
        this.pollId = pollId;
        fireOnPostWrite(PROPERTY_POLL_ID, oldValue, pollId);
    }

    @Override
    public String getPollId() {
        fireOnPreRead(PROPERTY_POLL_ID, pollId);
        String result = this.pollId;
        fireOnPostRead(PROPERTY_POLL_ID, pollId);
        return result;
    }

    @Override
    public void setTitle(String title) {
        String oldValue = this.title;
        fireOnPreWrite(PROPERTY_TITLE, oldValue, title);
        this.title = title;
        fireOnPostWrite(PROPERTY_TITLE, oldValue, title);
    }

    @Override
    public String getTitle() {
        fireOnPreRead(PROPERTY_TITLE, title);
        String result = this.title;
        fireOnPostRead(PROPERTY_TITLE, title);
        return result;
    }

    @Override
    public void setDescription(String description) {
        String oldValue = this.description;
        fireOnPreWrite(PROPERTY_DESCRIPTION, oldValue, description);
        this.description = description;
        fireOnPostWrite(PROPERTY_DESCRIPTION, oldValue, description);
    }

    @Override
    public String getDescription() {
        fireOnPreRead(PROPERTY_DESCRIPTION, description);
        String result = this.description;
        fireOnPostRead(PROPERTY_DESCRIPTION, description);
        return result;
    }

    @Override
    public void setBeginChoiceDate(Date beginChoiceDate) {
        Date oldValue = this.beginChoiceDate;
        fireOnPreWrite(PROPERTY_BEGIN_CHOICE_DATE, oldValue, beginChoiceDate);
        this.beginChoiceDate = beginChoiceDate;
        fireOnPostWrite(PROPERTY_BEGIN_CHOICE_DATE, oldValue, beginChoiceDate);
    }

    @Override
    public Date getBeginChoiceDate() {
        fireOnPreRead(PROPERTY_BEGIN_CHOICE_DATE, beginChoiceDate);
        Date result = this.beginChoiceDate;
        fireOnPostRead(PROPERTY_BEGIN_CHOICE_DATE, beginChoiceDate);
        return result;
    }

    @Override
    public void setBeginDate(Date beginDate) {
        Date oldValue = this.beginDate;
        fireOnPreWrite(PROPERTY_BEGIN_DATE, oldValue, beginDate);
        this.beginDate = beginDate;
        fireOnPostWrite(PROPERTY_BEGIN_DATE, oldValue, beginDate);
    }

    @Override
    public Date getBeginDate() {
        fireOnPreRead(PROPERTY_BEGIN_DATE, beginDate);
        Date result = this.beginDate;
        fireOnPostRead(PROPERTY_BEGIN_DATE, beginDate);
        return result;
    }

    @Override
    public void setEndDate(Date endDate) {
        Date oldValue = this.endDate;
        fireOnPreWrite(PROPERTY_END_DATE, oldValue, endDate);
        this.endDate = endDate;
        fireOnPostWrite(PROPERTY_END_DATE, oldValue, endDate);
    }

    @Override
    public Date getEndDate() {
        fireOnPreRead(PROPERTY_END_DATE, endDate);
        Date result = this.endDate;
        fireOnPostRead(PROPERTY_END_DATE, endDate);
        return result;
    }

    @Override
    public void setMaxChoiceNb(int maxChoiceNb) {
        int oldValue = this.maxChoiceNb;
        fireOnPreWrite(PROPERTY_MAX_CHOICE_NB, oldValue, maxChoiceNb);
        this.maxChoiceNb = maxChoiceNb;
        fireOnPostWrite(PROPERTY_MAX_CHOICE_NB, oldValue, maxChoiceNb);
    }

    @Override
    public int getMaxChoiceNb() {
        fireOnPreRead(PROPERTY_MAX_CHOICE_NB, maxChoiceNb);
        int result = this.maxChoiceNb;
        fireOnPostRead(PROPERTY_MAX_CHOICE_NB, maxChoiceNb);
        return result;
    }

    @Override
    public void setClosed(boolean closed) {
        boolean oldValue = this.closed;
        fireOnPreWrite(PROPERTY_CLOSED, oldValue, closed);
        this.closed = closed;
        fireOnPostWrite(PROPERTY_CLOSED, oldValue, closed);
    }

    @Override
    public boolean isClosed() {
        fireOnPreRead(PROPERTY_CLOSED, closed);
        boolean result = this.closed;
        fireOnPostRead(PROPERTY_CLOSED, closed);
        return result;
    }

    @Override
    public void setChoiceAddAllowed(boolean choiceAddAllowed) {
        boolean oldValue = this.choiceAddAllowed;
        fireOnPreWrite(PROPERTY_CHOICE_ADD_ALLOWED, oldValue, choiceAddAllowed);
        this.choiceAddAllowed = choiceAddAllowed;
        fireOnPostWrite(PROPERTY_CHOICE_ADD_ALLOWED, oldValue, choiceAddAllowed);
    }

    @Override
    public boolean isChoiceAddAllowed() {
        fireOnPreRead(PROPERTY_CHOICE_ADD_ALLOWED, choiceAddAllowed);
        boolean result = this.choiceAddAllowed;
        fireOnPostRead(PROPERTY_CHOICE_ADD_ALLOWED, choiceAddAllowed);
        return result;
    }

    @Override
    public void setAnonymousVoteAllowed(boolean anonymousVoteAllowed) {
        boolean oldValue = this.anonymousVoteAllowed;
        fireOnPreWrite(PROPERTY_ANONYMOUS_VOTE_ALLOWED, oldValue, anonymousVoteAllowed);
        this.anonymousVoteAllowed = anonymousVoteAllowed;
        fireOnPostWrite(PROPERTY_ANONYMOUS_VOTE_ALLOWED, oldValue, anonymousVoteAllowed);
    }

    @Override
    public boolean isAnonymousVoteAllowed() {
        fireOnPreRead(PROPERTY_ANONYMOUS_VOTE_ALLOWED, anonymousVoteAllowed);
        boolean result = this.anonymousVoteAllowed;
        fireOnPostRead(PROPERTY_ANONYMOUS_VOTE_ALLOWED, anonymousVoteAllowed);
        return result;
    }

    @Override
    public void setPublicResults(boolean publicResults) {
        boolean oldValue = this.publicResults;
        fireOnPreWrite(PROPERTY_PUBLIC_RESULTS, oldValue, publicResults);
        this.publicResults = publicResults;
        fireOnPostWrite(PROPERTY_PUBLIC_RESULTS, oldValue, publicResults);
    }

    @Override
    public boolean isPublicResults() {
        fireOnPreRead(PROPERTY_PUBLIC_RESULTS, publicResults);
        boolean result = this.publicResults;
        fireOnPostRead(PROPERTY_PUBLIC_RESULTS, publicResults);
        return result;
    }

    @Override
    public void setContinuousResults(boolean continuousResults) {
        boolean oldValue = this.continuousResults;
        fireOnPreWrite(PROPERTY_CONTINUOUS_RESULTS, oldValue, continuousResults);
        this.continuousResults = continuousResults;
        fireOnPostWrite(PROPERTY_CONTINUOUS_RESULTS, oldValue, continuousResults);
    }

    @Override
    public boolean isContinuousResults() {
        fireOnPreRead(PROPERTY_CONTINUOUS_RESULTS, continuousResults);
        boolean result = this.continuousResults;
        fireOnPostRead(PROPERTY_CONTINUOUS_RESULTS, continuousResults);
        return result;
    }

    @Override
    public void setEndChoiceDate(Date endChoiceDate) {
        Date oldValue = this.endChoiceDate;
        fireOnPreWrite(PROPERTY_END_CHOICE_DATE, oldValue, endChoiceDate);
        this.endChoiceDate = endChoiceDate;
        fireOnPostWrite(PROPERTY_END_CHOICE_DATE, oldValue, endChoiceDate);
    }

    @Override
    public Date getEndChoiceDate() {
        fireOnPreRead(PROPERTY_END_CHOICE_DATE, endChoiceDate);
        Date result = this.endChoiceDate;
        fireOnPostRead(PROPERTY_END_CHOICE_DATE, endChoiceDate);
        return result;
    }

    @Override
    public void setResultUptodate(boolean resultUptodate) {
        boolean oldValue = this.resultUptodate;
        fireOnPreWrite(PROPERTY_RESULT_UPTODATE, oldValue, resultUptodate);
        this.resultUptodate = resultUptodate;
        fireOnPostWrite(PROPERTY_RESULT_UPTODATE, oldValue, resultUptodate);
    }

    @Override
    public boolean isResultUptodate() {
        fireOnPreRead(PROPERTY_RESULT_UPTODATE, resultUptodate);
        boolean result = this.resultUptodate;
        fireOnPostRead(PROPERTY_RESULT_UPTODATE, resultUptodate);
        return result;
    }

    @Override
    public void setVoteCountingType(int voteCountingType) {
        int oldValue = this.voteCountingType;
        fireOnPreWrite(PROPERTY_VOTE_COUNTING_TYPE, oldValue, voteCountingType);
        this.voteCountingType = voteCountingType;
        fireOnPostWrite(PROPERTY_VOTE_COUNTING_TYPE, oldValue, voteCountingType);
    }

    @Override
    public int getVoteCountingType() {
        fireOnPreRead(PROPERTY_VOTE_COUNTING_TYPE, voteCountingType);
        int result = this.voteCountingType;
        fireOnPostRead(PROPERTY_VOTE_COUNTING_TYPE, voteCountingType);
        return result;
    }

    @Override
    public void addVote(Vote vote) {
        fireOnPreWrite(PROPERTY_VOTE, null, vote);
        if (this.vote == null) {
            this.vote = new ArrayList<Vote>();
        }

        this.vote.add(vote);
        fireOnPostWrite(PROPERTY_VOTE, this.vote.size(), null, vote);
    }

    @Override
    public void addAllVote(List<Vote> vote) {
        if (vote == null) {
            return;
        }
        for (Vote item : vote) {
            addVote(item);
        }
    }

    @Override
    public void setVote(List<Vote> vote) {
        // Copy elements to keep data for fire with new reference
        List<Vote> oldValue = this.vote != null ? new ArrayList<Vote>(this.vote) : null;
        fireOnPreWrite(PROPERTY_VOTE, oldValue, vote);
        this.vote = vote;
        fireOnPostWrite(PROPERTY_VOTE, oldValue, vote);
    }

    @Override
    public void removeVote(Vote vote) {
        fireOnPreWrite(PROPERTY_VOTE, vote, null);
        if (this.vote == null || !this.vote.remove(vote)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VOTE, this.vote.size() + 1, vote, null);
    }

    @Override
    public void clearVote() {
        if (this.vote == null) {
            return;
        }
        List<Vote> oldValue = new ArrayList<Vote>(this.vote);
        fireOnPreWrite(PROPERTY_VOTE, oldValue, this.vote);
        this.vote.clear();
        fireOnPostWrite(PROPERTY_VOTE, oldValue, this.vote);
    }

    @Override
    public List<Vote> getVote() {
        return vote;
    }

    @Override
    public Vote getVoteByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(vote, topiaId);
    }

    @Override
    public int sizeVote() {
        if (vote == null) {
            return 0;
        }
        return vote.size();
    }

    @Override
    public boolean isVoteEmpty() {
        int size = sizeVote();
        return size == 0;
    }

    @Override
    public void addChoice(Choice choice) {
        fireOnPreWrite(PROPERTY_CHOICE, null, choice);
        if (this.choice == null) {
            this.choice = new ArrayList<Choice>();
        }

        this.choice.add(choice);
        fireOnPostWrite(PROPERTY_CHOICE, this.choice.size(), null, choice);
    }

    @Override
    public void addAllChoice(List<Choice> choice) {
        if (choice == null) {
            return;
        }
        for (Choice item : choice) {
            addChoice(item);
        }
    }

    @Override
    public void setChoice(List<Choice> choice) {
        // Copy elements to keep data for fire with new reference
        List<Choice> oldValue = this.choice != null ? new ArrayList<Choice>(this.choice) : null;
        fireOnPreWrite(PROPERTY_CHOICE, oldValue, choice);
        this.choice = choice;
        fireOnPostWrite(PROPERTY_CHOICE, oldValue, choice);
    }

    @Override
    public void removeChoice(Choice choice) {
        fireOnPreWrite(PROPERTY_CHOICE, choice, null);
        if (this.choice == null || !this.choice.remove(choice)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_CHOICE, this.choice.size() + 1, choice, null);
    }

    @Override
    public void clearChoice() {
        if (this.choice == null) {
            return;
        }
        List<Choice> oldValue = new ArrayList<Choice>(this.choice);
        fireOnPreWrite(PROPERTY_CHOICE, oldValue, this.choice);
        this.choice.clear();
        fireOnPostWrite(PROPERTY_CHOICE, oldValue, this.choice);
    }

    @Override
    public List<Choice> getChoice() {
        return choice;
    }

    @Override
    public Choice getChoiceByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(choice, topiaId);
    }

    @Override
    public int sizeChoice() {
        if (choice == null) {
            return 0;
        }
        return choice.size();
    }

    @Override
    public boolean isChoiceEmpty() {
        int size = sizeChoice();
        return size == 0;
    }

    @Override
    public void addResult(Result result) {
        fireOnPreWrite(PROPERTY_RESULT, null, result);
        if (this.result == null) {
            this.result = new ArrayList<Result>();
        }

        this.result.add(result);
        fireOnPostWrite(PROPERTY_RESULT, this.result.size(), null, result);
    }

    @Override
    public void addAllResult(List<Result> result) {
        if (result == null) {
            return;
        }
        for (Result item : result) {
            addResult(item);
        }
    }

    @Override
    public void setResult(List<Result> result) {
        // Copy elements to keep data for fire with new reference
        List<Result> oldValue = this.result != null ? new ArrayList<Result>(this.result) : null;
        fireOnPreWrite(PROPERTY_RESULT, oldValue, result);
        this.result = result;
        fireOnPostWrite(PROPERTY_RESULT, oldValue, result);
    }

    @Override
    public void removeResult(Result result) {
        fireOnPreWrite(PROPERTY_RESULT, result, null);
        if (this.result == null || !this.result.remove(result)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_RESULT, this.result.size() + 1, result, null);
    }

    @Override
    public void clearResult() {
        if (this.result == null) {
            return;
        }
        List<Result> oldValue = new ArrayList<Result>(this.result);
        fireOnPreWrite(PROPERTY_RESULT, oldValue, this.result);
        this.result.clear();
        fireOnPostWrite(PROPERTY_RESULT, oldValue, this.result);
    }

    @Override
    public List<Result> getResult() {
        return result;
    }

    @Override
    public Result getResultByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(result, topiaId);
    }

    @Override
    public int sizeResult() {
        if (result == null) {
            return 0;
        }
        return result.size();
    }

    @Override
    public boolean isResultEmpty() {
        int size = sizeResult();
        return size == 0;
    }

    @Override
    public void setCreator(PollAccount creator) {
        PollAccount oldValue = this.creator;
        fireOnPreWrite(PROPERTY_CREATOR, oldValue, creator);
        this.creator = creator;
        fireOnPostWrite(PROPERTY_CREATOR, oldValue, creator);
    }

    @Override
    public PollAccount getCreator() {
        fireOnPreRead(PROPERTY_CREATOR, creator);
        PollAccount result = this.creator;
        fireOnPostRead(PROPERTY_CREATOR, creator);
        return result;
    }

    @Override
    public void addComment(Comment comment) {
        fireOnPreWrite(PROPERTY_COMMENT, null, comment);
        if (this.comment == null) {
            this.comment = new ArrayList<Comment>();
        }

        this.comment.add(comment);
        fireOnPostWrite(PROPERTY_COMMENT, this.comment.size(), null, comment);
    }

    @Override
    public void addAllComment(List<Comment> comment) {
        if (comment == null) {
            return;
        }
        for (Comment item : comment) {
            addComment(item);
        }
    }

    @Override
    public void setComment(List<Comment> comment) {
        // Copy elements to keep data for fire with new reference
        List<Comment> oldValue = this.comment != null ? new ArrayList<Comment>(this.comment) : null;
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, comment);
        this.comment = comment;
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, comment);
    }

    @Override
    public void removeComment(Comment comment) {
        fireOnPreWrite(PROPERTY_COMMENT, comment, null);
        if (this.comment == null || !this.comment.remove(comment)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_COMMENT, this.comment.size() + 1, comment, null);
    }

    @Override
    public void clearComment() {
        if (this.comment == null) {
            return;
        }
        List<Comment> oldValue = new ArrayList<Comment>(this.comment);
        fireOnPreWrite(PROPERTY_COMMENT, oldValue, this.comment);
        this.comment.clear();
        fireOnPostWrite(PROPERTY_COMMENT, oldValue, this.comment);
    }

    @Override
    public List<Comment> getComment() {
        return comment;
    }

    @Override
    public Comment getCommentByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(comment, topiaId);
    }

    @Override
    public int sizeComment() {
        if (comment == null) {
            return 0;
        }
        return comment.size();
    }

    @Override
    public boolean isCommentEmpty() {
        int size = sizeComment();
        return size == 0;
    }

    @Override
    public void addPreventRule(PreventRule preventRule) {
        fireOnPreWrite(PROPERTY_PREVENT_RULE, null, preventRule);
        if (this.preventRule == null) {
            this.preventRule = new ArrayList<PreventRule>();
        }

        this.preventRule.add(preventRule);
        fireOnPostWrite(PROPERTY_PREVENT_RULE, this.preventRule.size(), null, preventRule);
    }

    @Override
    public void addAllPreventRule(List<PreventRule> preventRule) {
        if (preventRule == null) {
            return;
        }
        for (PreventRule item : preventRule) {
            addPreventRule(item);
        }
    }

    @Override
    public void setPreventRule(List<PreventRule> preventRule) {
        // Copy elements to keep data for fire with new reference
        List<PreventRule> oldValue = this.preventRule != null ? new ArrayList<PreventRule>(this.preventRule) : null;
        fireOnPreWrite(PROPERTY_PREVENT_RULE, oldValue, preventRule);
        this.preventRule = preventRule;
        fireOnPostWrite(PROPERTY_PREVENT_RULE, oldValue, preventRule);
    }

    @Override
    public void removePreventRule(PreventRule preventRule) {
        fireOnPreWrite(PROPERTY_PREVENT_RULE, preventRule, null);
        if (this.preventRule == null || !this.preventRule.remove(preventRule)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_PREVENT_RULE, this.preventRule.size() + 1, preventRule, null);
    }

    @Override
    public void clearPreventRule() {
        if (this.preventRule == null) {
            return;
        }
        List<PreventRule> oldValue = new ArrayList<PreventRule>(this.preventRule);
        fireOnPreWrite(PROPERTY_PREVENT_RULE, oldValue, this.preventRule);
        this.preventRule.clear();
        fireOnPostWrite(PROPERTY_PREVENT_RULE, oldValue, this.preventRule);
    }

    @Override
    public List<PreventRule> getPreventRule() {
        return preventRule;
    }

    @Override
    public PreventRule getPreventRuleByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(preventRule, topiaId);
    }

    @Override
    public int sizePreventRule() {
        if (preventRule == null) {
            return 0;
        }
        return preventRule.size();
    }

    @Override
    public boolean isPreventRuleEmpty() {
        int size = sizePreventRule();
        return size == 0;
    }

    @Override
    public void addVotingList(VotingList votingList) {
        fireOnPreWrite(PROPERTY_VOTING_LIST, null, votingList);
        if (this.votingList == null) {
            this.votingList = new ArrayList<VotingList>();
        }

        this.votingList.add(votingList);
        fireOnPostWrite(PROPERTY_VOTING_LIST, this.votingList.size(), null, votingList);
    }

    @Override
    public void addAllVotingList(List<VotingList> votingList) {
        if (votingList == null) {
            return;
        }
        for (VotingList item : votingList) {
            addVotingList(item);
        }
    }

    @Override
    public void setVotingList(List<VotingList> votingList) {
        // Copy elements to keep data for fire with new reference
        List<VotingList> oldValue = this.votingList != null ? new ArrayList<VotingList>(this.votingList) : null;
        fireOnPreWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
        this.votingList = votingList;
        fireOnPostWrite(PROPERTY_VOTING_LIST, oldValue, votingList);
    }

    @Override
    public void removeVotingList(VotingList votingList) {
        fireOnPreWrite(PROPERTY_VOTING_LIST, votingList, null);
        if (this.votingList == null || !this.votingList.remove(votingList)) {
            throw new IllegalArgumentException("List does not contain given element");
        }

        fireOnPostWrite(PROPERTY_VOTING_LIST, this.votingList.size() + 1, votingList, null);
    }

    @Override
    public void clearVotingList() {
        if (this.votingList == null) {
            return;
        }
        List<VotingList> oldValue = new ArrayList<VotingList>(this.votingList);
        fireOnPreWrite(PROPERTY_VOTING_LIST, oldValue, this.votingList);
        this.votingList.clear();
        fireOnPostWrite(PROPERTY_VOTING_LIST, oldValue, this.votingList);
    }

    @Override
    public List<VotingList> getVotingList() {
        return votingList;
    }

    @Override
    public VotingList getVotingListByTopiaId(String topiaId) {
        return TopiaEntityHelper.getEntityByTopiaId(votingList, topiaId);
    }

    @Override
    public int sizeVotingList() {
        if (votingList == null) {
            return 0;
        }
        return votingList.size();
    }

    @Override
    public boolean isVotingListEmpty() {
        int size = sizeVotingList();
        return size == 0;
    }

    @Override
    public void setPollType(PollType pollType) {
        PollType oldValue = this.pollType;
        fireOnPreWrite(PROPERTY_POLL_TYPE, oldValue, pollType);
        this.pollType = pollType;
        fireOnPostWrite(PROPERTY_POLL_TYPE, oldValue, pollType);
    }

    @Override
    public PollType getPollType() {
        fireOnPreRead(PROPERTY_POLL_TYPE, pollType);
        PollType result = this.pollType;
        fireOnPostRead(PROPERTY_POLL_TYPE, pollType);
        return result;
    }

    @Override
    public void setChoiceType(ChoiceType choiceType) {
        ChoiceType oldValue = this.choiceType;
        fireOnPreWrite(PROPERTY_CHOICE_TYPE, oldValue, choiceType);
        this.choiceType = choiceType;
        fireOnPostWrite(PROPERTY_CHOICE_TYPE, oldValue, choiceType);
    }

    @Override
    public ChoiceType getChoiceType() {
        fireOnPreRead(PROPERTY_CHOICE_TYPE, choiceType);
        ChoiceType result = this.choiceType;
        fireOnPostRead(PROPERTY_CHOICE_TYPE, choiceType);
        return result;
    }

    @Override
    public void setPollVoteVisibility(PollVoteVisibility pollVoteVisibility) {
        PollVoteVisibility oldValue = this.pollVoteVisibility;
        fireOnPreWrite(PROPERTY_POLL_VOTE_VISIBILITY, oldValue, pollVoteVisibility);
        this.pollVoteVisibility = pollVoteVisibility;
        fireOnPostWrite(PROPERTY_POLL_VOTE_VISIBILITY, oldValue, pollVoteVisibility);
    }

    @Override
    public PollVoteVisibility getPollVoteVisibility() {
        fireOnPreRead(PROPERTY_POLL_VOTE_VISIBILITY, pollVoteVisibility);
        PollVoteVisibility result = this.pollVoteVisibility;
        fireOnPostRead(PROPERTY_POLL_VOTE_VISIBILITY, pollVoteVisibility);
        return result;
    }

    @Override
    public void setPollCommentVisibility(PollCommentVisibility pollCommentVisibility) {
        PollCommentVisibility oldValue = this.pollCommentVisibility;
        fireOnPreWrite(PROPERTY_POLL_COMMENT_VISIBILITY, oldValue, pollCommentVisibility);
        this.pollCommentVisibility = pollCommentVisibility;
        fireOnPostWrite(PROPERTY_POLL_COMMENT_VISIBILITY, oldValue, pollCommentVisibility);
    }

    @Override
    public PollCommentVisibility getPollCommentVisibility() {
        fireOnPreRead(PROPERTY_POLL_COMMENT_VISIBILITY, pollCommentVisibility);
        PollCommentVisibility result = this.pollCommentVisibility;
        fireOnPostRead(PROPERTY_POLL_COMMENT_VISIBILITY, pollCommentVisibility);
        return result;
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }
        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        if (getVote() != null) {
              tmp.addAll(getVote());
           }
        if (getChoice() != null) {
              tmp.addAll(getChoice());
           }
        if (getResult() != null) {
              tmp.addAll(getResult());
           }
        if (getComment() != null) {
              tmp.addAll(getComment());
           }
        if (getPreventRule() != null) {
              tmp.addAll(getPreventRule());
           }
        if (getVotingList() != null) {
              tmp.addAll(getVotingList());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        return result;
    }

} //PollAbstract
