/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;

import java.util.List;


import java.util.Arrays;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;

/**
 * Implantation DAO pour l'entité VotingList.
 * Cette classe contient une implantation de TopiaDAO a laquel elle peut
 * deleguer des traitements
 * 
 */
public abstract class VotingListDAOAbstract<E extends VotingList> extends org.nuiton.topia.persistence.TopiaDAOImpl<E> implements org.nuiton.topia.persistence.TopiaDAO<E> {    

    public Class<E> getEntityClass() {
        return (Class<E>)VotingList.class;
    }

    public void delete(E entity) throws TopiaException {

                {
                List<org.chorem.pollen.business.persistence.Vote> list = getContext()
                            .getDAO(org.chorem.pollen.business.persistence.Vote.class)
                            .findAllByProperties("votingList", entity);
                    for (org.chorem.pollen.business.persistence.Vote item : list) {
                        item.setVotingList(null);

                    }
                }
                
        super.delete(entity);
    }    
     
    /**
     * Recherche sur l'attribut name
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return un element ou null
     */
    public E findByName(java.lang.String v) throws TopiaException {
        E result = findByProperty("name", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * name le paramètre
     * @param v la valeur que doit avoir name
     * @return une liste
     */
    public List<E> findAllByName(java.lang.String v) throws TopiaException {
        List<E> result = findAllByProperty("name", v);
        return result;
    }
    /**
     * Recherche sur l'attribut weight
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return un element ou null
     */
    public E findByWeight(double v) throws TopiaException {
        E result = findByProperty("weight", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * weight le paramètre
     * @param v la valeur que doit avoir weight
     * @return une liste
     */
    public List<E> findAllByWeight(double v) throws TopiaException {
        List<E> result = findAllByProperty("weight", v);
        return result;
    }
    /**
     * Recherche sur l'attribut pollAccount
     */
    
    /**
     * Retourne le premier élément trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return un element ou null
     */
    public E findContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        E result = findContainsProperties("pollAccount", Arrays.asList(v));
        return result;
    }
    /**
     * Retourne les éléments trouvé dont l'attribut
     * pollAccount contient le paramètre
     * @param v la valeur que doit contenir pollAccount
     * @return une liste
     */
    public List<E> findAllContainsPollAccount(org.chorem.pollen.business.persistence.PollAccount ... v) throws TopiaException {
        List<E> results = findAllContainsProperties("pollAccount", Arrays.asList(v));
        return results;
    }
    /**
     * Recherche sur l'attribut poll
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return un element ou null
     */
    public E findByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        E result = findByProperty("poll", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * poll le paramètre
     * @param v la valeur que doit avoir poll
     * @return une liste
     */
    public List<E> findAllByPoll(org.chorem.pollen.business.persistence.Poll v) throws TopiaException {
        List<E> result = findAllByProperty("poll", v);
        return result;
    }
    /**
     * Recherche sur l'attribut vote
     */

    /**
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut
     * vote le paramètre
     * @param v la valeur que doit avoir vote
     * @return un element ou null
     */
    public E findByVote(org.chorem.pollen.business.persistence.Vote v) throws TopiaException {
        E result = findByProperty("vote", v);
        return result;
    }

    /**
     * Retourne les éléments ayant comme valeur pour l'attribut
     * vote le paramètre
     * @param v la valeur que doit avoir vote
     * @return une liste
     */
    public List<E> findAllByVote(org.chorem.pollen.business.persistence.Vote v) throws TopiaException {
        List<E> result = findAllByProperty("vote", v);
        return result;
    }

} // VotingListDAOAbstract
