/* *##%
 Copyright (C) 2009 Pollen
 *##%*/
package org.chorem.pollen.business.persistence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link PersonList}.
 */
public abstract class PersonListAbstract extends TopiaEntityAbstract implements PersonList {

    public String name;

    public UserAccount owner;

    public List<PollAccount> pollAccount;

    /**
     * Constructeur de PersonListAbstract par défaut.
     */
    public PersonListAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PersonList.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PersonList.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "name", String.class, name);
        visitor.visit(this, "owner", UserAccount.class, owner);
        visitor.visit(this, "pollAccount", List.class, PollAccount.class, pollAccount);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.addAll(getPollAccount());

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see PersonList#setName(String)
     */
    @Override
    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite("name", _oldValue, value);
        this.name = value;
        fireOnPostWrite("name", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PersonList#getName()
     */
    @Override
    public String getName() {
        fireOnPreRead("name", name);
        String result = this.name;
        fireOnPostRead("name", name);
        return result;
    }

    /* (non-Javadoc)
     * @see PersonList#setOwner(UserAccount)
     */
    @Override
    public void setOwner(UserAccount value) {
        UserAccount _oldValue = this.owner;
        fireOnPreWrite("owner", _oldValue, value);
        this.owner = value;
        fireOnPostWrite("owner", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see PersonList#getOwner()
     */
    @Override
    public UserAccount getOwner() {
        fireOnPreRead("owner", owner);
        UserAccount result = this.owner;
        fireOnPostRead("owner", owner);
        return result;
    }

    /* (non-Javadoc)
     * @see PersonList#addPollAccount(PollAccount)
     */
    @Override
    public void addPollAccount(PollAccount pollAccount) {
        fireOnPreWrite("pollAccount", null, pollAccount);
        if (this.pollAccount == null) {
            this.pollAccount = new ArrayList<PollAccount>();
        }
        pollAccount.setPersonList(this);
        this.pollAccount.add(pollAccount);
        fireOnPostWrite("pollAccount", this.pollAccount.size(), null, pollAccount);
    }

    /* (non-Javadoc)
     * @see PersonList#addAllPollAccount(List<PollAccount>)
     */
    @Override
    public void addAllPollAccount(List<PollAccount> values) {
        if (values == null) {
            return;
        }
        for (PollAccount item : values) {
            addPollAccount(item);
        }
    }

    /* (non-Javadoc)
     * @see PersonList#getPollAccountByTopiaId(String)
     */
    @Override
    public PollAccount getPollAccountByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(pollAccount, topiaId);
    }
 
    /* (non-Javadoc)
     * @see PersonList#setPollAccount(List<PollAccount>)
     */
    @Override
    public void setPollAccount(List<PollAccount> values) {
        List<PollAccount> _oldValue = pollAccount;
        fireOnPreWrite("pollAccount", _oldValue, values);
        pollAccount = values;
        fireOnPostWrite("pollAccount", _oldValue, values);
    }

    /* (non-Javadoc)
     * @see PersonList#removePollAccount(PollAccount)
     */
    @Override
    public void removePollAccount(PollAccount value) {
        fireOnPreWrite("pollAccount", value, null);
        if ((this.pollAccount == null) || (!this.pollAccount.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPersonList(null);
        fireOnPostWrite("pollAccount", this.pollAccount.size()+1, value, null);
    }

    /* (non-Javadoc)
     * @see PersonList#clearPollAccount()
     */
    @Override
    public void clearPollAccount() {
        if (this.pollAccount == null) {
            return;
        }
        for (PollAccount item : this.pollAccount) {
            item.setPersonList(null);
        }
        List<PollAccount> _oldValue = new ArrayList<PollAccount>(this.pollAccount);
        fireOnPreWrite("pollAccount", _oldValue, this.pollAccount);
        this.pollAccount.clear();
        fireOnPostWrite("pollAccount", _oldValue, this.pollAccount);
    }

    /* (non-Javadoc)
     * @see PersonList#getPollAccount()
     */
    @Override
    public List<PollAccount> getPollAccount() {
        return pollAccount;
    }

    /* (non-Javadoc)
     * @see PersonList#sizePollAccount()
     */
    @Override
    public int sizePollAccount() {
        if (pollAccount == null) {
            return 0;
        }
        return pollAccount.size();
    }

    /* (non-Javadoc)
     * @see PersonList#isPollAccountEmpty()
     */
    @Override
    public boolean isPollAccountEmpty() {
        int size = sizePollAccount();
        return size == 0;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("name", this.name).
         toString();
        return result;
    }
        
} //PersonListAbstract
