/* *##% Pollen
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>. ##%*/

package org.chorem.pollen.business.migration;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.migration.DatabaseManager;
import org.nuiton.topia.migration.callback.MigrationCallbackHandler;
import org.nuiton.util.VersionUtil;

/**
 * Classe d'interaction avant la migration (MigrationCallbackHandler).
 *
 * @author rannou
 * @version $Id: PollenMigrationCallbackHandler.java 2615 2009-07-01 13:47:45Z nrannou $
 */
public class PollenMigrationCallbackHandler implements MigrationCallbackHandler {

    /** log. */
    private static final Log log = LogFactory
            .getLog(PollenMigrationCallbackHandler.class);

    @Override
    public MigrationChoice doMigration(DatabaseManager dbManager,
            String dbVersion, String applicationVersion) {

        if (log.isInfoEnabled()) {
            log.info("Migration : version de la base : " + dbVersion
                    + ", version de l'application : " + applicationVersion);
        }

        MigrationChoice result = MigrationChoice.NO_MIGRATION;

        // ouverture d'une connexion direct JDBC sur la base
        try {
            Connection conn = dbManager.getConnection();
            try {
                conn.setAutoCommit(false);
                if (VersionUtil.valueOf(dbVersion).compareTo(
                        VersionUtil.valueOf("1.0")) < 0) {
                    //migrateTo1_0_test(conn);
                }
                conn.commit();
                result = MigrationChoice.CUSTOM_MIGRATION;
            } catch (Exception eee) {
                log.error("Migration impossible de la base", eee);
                conn.rollback();
            } finally {
                conn.close();
            }
        } catch (Exception eee) {
            log.error("Erreur lors de la tentative de migration", eee);
        }
        return result;
    }

    /** Migration de la version de test (build 2444 to 1.0) */
    private void migrateTo1_0_test(Connection conn) throws SQLException {
        log.info("Migrate to version 1_0_test");

        String[] sqls = new String[] {
                "drop table listtype cascade;",
                "drop table poll_preventrule;",
                "alter table \"user\" rename to useraccount;",
                "alter table pollaccount rename \"user\" to useraccount;",
                //"alter table preventrule drop column daysbeforeend;",
                "alter table poll drop column sendemailtouser;",
                "alter table votetochoice rename value to votevalue;",
                "alter table result rename value to resultvalue;",
                "alter table result rename isbygroup to bygroup;",
                "alter table useraccount rename isadministrator to administrator;",
                "alter table choice rename isvalidate to validate;",
                "alter table poll rename isanonymous to anonymous;",
                "alter table poll rename isanonymousvoteallowed to anonymousvoteallowed;",
                "alter table poll rename ischoiceaddallowed to choiceaddallowed;",
                "alter table poll rename isclosed to closed;",
                "alter table comment add postdate timestamp;",
                "alter table preventrule add scope varchar;",
                //"alter table preventrule add sensibility integer;",
                "alter table preventrule add repeated boolean;",
                //"alter table preventrule add method varchar;",
                "alter table poll add publicresults boolean default false;",
                "alter table poll add continuousresults boolean default false;",
                "alter table preventrule add poll varchar(255);",
                "alter table preventrule add constraint fk_migration_preventrule foreign key(poll) references poll(topiaid);", };
        for (String sql : sqls) {
            log.info("try " + sql);
            PreparedStatement sta = conn.prepareStatement(sql);
            sta.executeUpdate();
            log.info("done " + sql);
        }
    }
}
