package org.chorem.lima.ui.financialperiod;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;
import org.chorem.lima.entity.FiscalPeriod;
import static org.nuiton.i18n.I18n.t;

public class FinancialPeriodView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_PERIOD = "selectedPeriod";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_BLOCK_BUTTON_ENABLED = "blockButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1UTXMTRxBtC8u27BiCP8AmJHz5AAdWCVDhYBKMjR3LJYyxVC4XOpDR7tgaZzSzmZmN1+UKxU/gJ5B7LqnKLadUDjlz4ELlL6RSOeRK0TNra7XWUibosJJmul+/19uvf/4bilrBpR0Sx56KhGFt6q3c29x82NyhvrlPta9YaKSC5NNXgEIDRoLOuTZwpVG16eWD9PKCbIdSUNGVPVuFYW32ONUtSo2BT7MZvtblWud6Ng4jdYjaIZWH+uLffwrPg2c/FQDiENmVUMrF47JSJf1VKLDAwBhW+oGUORHbSEMxsY18R+3ZAidar5I2/R6ewmAVBkKiEMzA5feX7DBcfhwaGJpZWSOC8s8NfCnVtue3pKJtj7M28SLmbTFBhM8ID6liMvCWDv+vuf8bjO6GoUMbMDDYIiLgVBn46sOglpP8FPGkphxfOw2SGAOnbRc82xlvXkpOiegqb/BknmD5CRsVe3oXW+et1JNjG1XqBI80ufS/m4+MkcLAeCYhObWBY5340ZmVmq8k57Zb2KyzmYz0Kltleisrsk6anD6QAeUG7vz/HqXpqeqJvBIGbn8gukWdSsFnqkybmnsJTApXGsV/1i2+NwLJKfgkM/foKC91VDryfQ0oqgiPDUw1ek24jleJ/aaO2M8Cuts3Z8Zf/fbXr0uHnrPrYzI3tGtloBdCJbENhtnSpxLDRYbx8gMSzjbQuU6R2yfnc4jVDq6RHNZLptKme8tEtxCiOPj69z/OfPvyBBSWYJhLEiwRG1+Bkmkp7ILkQRzenXOMPtodwufHlpuB0hZGm+QlFrcI1zRG+edz5Hc4NEt//jde+2XusAV9SGn6neFpG4qPYYAJzgR1i+dgp+QumpFQ0yiQ6e7I2yaQejA8GNBr7nm9R+gJDKXCqkRTT+wzXcsY/eq1Hw0MEzdSFd86dPLImF/3udTYohFbsM7COo1xDZ5zo34k1HNWjyPL5AvXHvvrJmSXwHGM+5GnL3nUFgvIB+2+wTRzb6nfqAi/RnW3CQx4+73O8GqV1W+qi08qq/XF9Y171Se1xeriQr3ycBX1DmmpMi8eh0HJ3WXKtluorXDjVp6GXP8fJwbnbICTPYnK4eSdAOftYpOJAO38dU+NPvscfg/EYttKtNeP8kEuIMhbSlcKX+EHAAA=";
    public static final String PROPERTY$LIST_SELECTION_MODEL0 = "$ListSelectionModel0";
    private static final Log log = LogFactory.getLog(FinancialPeriodView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JButton blockButton;
    protected FinancialPeriodTable financialPeriodTable;
    protected FinancialPeriodTableModel financialPeriodTableModel;
    protected FinancialPeriodViewHandler handler;
    protected Boolean selectedPeriod;
    protected JToolBar toolBar;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private FinancialPeriodView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            getHandler().init();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialPeriodView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialPeriodView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialPeriodView() {
        $initialize();
    }

    public FinancialPeriodView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialPeriodView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public FinancialPeriodView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialPeriodView(boolean param0) {
        super(param0);
        $initialize();
    }

    public FinancialPeriodView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__blockButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.blockFinancialPeriod();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedPeriod(financialPeriodTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JButton getBlockButton() {
        return blockButton;
    }

    public FinancialPeriodTable getFinancialPeriodTable() {
        return financialPeriodTable;
    }

    public FinancialPeriodTableModel getFinancialPeriodTableModel() {
        return financialPeriodTableModel;
    }

    public FinancialPeriodViewHandler getHandler() {
        return handler;
    }

    public Boolean getSelectedPeriod() {
        return selectedPeriod;
    }

    public JToolBar getToolBar() {
        return toolBar;
    }

    public Boolean isSelectedPeriod() {
        return selectedPeriod !=null && selectedPeriod;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$ListSelectionModel0(ListSelectionModel $ListSelectionModel0) {
        ListSelectionModel oldValue = this.$ListSelectionModel0;
        this.$ListSelectionModel0 = $ListSelectionModel0;
        firePropertyChange(PROPERTY$LIST_SELECTION_MODEL0, oldValue, $ListSelectionModel0);
    }

    public void setSelectedPeriod(Boolean selectedPeriod) {
        Boolean oldValue = this.selectedPeriod;
        this.selectedPeriod = selectedPeriod;
        firePropertyChange(PROPERTY_SELECTED_PERIOD, oldValue, selectedPeriod);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(blockButton);
    }

    protected void createBlockButton() {
        $objectMap.put("blockButton", blockButton = new JButton());
        
        blockButton.setName("blockButton");
        blockButton.setToolTipText(t("lima.financialPeriod.block"));
        blockButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__blockButton"));
    }

    protected void createFinancialPeriodTable() {
        $objectMap.put("financialPeriodTable", financialPeriodTable = new FinancialPeriodTable(getHandler()));
        
        financialPeriodTable.setName("financialPeriodTable");
        financialPeriodTable.setColumnControlVisible(true);
        financialPeriodTable.setSortable(false);
        financialPeriodTable.setRowHeight(24);
    }

    protected void createFinancialPeriodTableModel() {
        $objectMap.put("financialPeriodTableModel", financialPeriodTableModel = new FinancialPeriodTableModel());
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new FinancialPeriodViewHandler(this));
    }

    protected void createSelectedPeriod() {
        $objectMap.put("selectedPeriod", selectedPeriod = false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new JToolBar());
        
        toolBar.setName("toolBar");
        toolBar.setFloatable(false);
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolBar, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(financialPeriodTable);
        
        // apply 1 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        financialPeriodTable.setModel(financialPeriodTableModel);
        blockButton.setIcon(SwingUtil.createActionIcon("financialPeriod-close"));
        financialPeriodTable.setSelectionMode(ListSelectionModel.SINGLE_INTERVAL_SELECTION);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedPeriod();
        createToolBar();
        createBlockButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createFinancialPeriodTableModel();
        createFinancialPeriodTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = financialPeriodTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 1 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 1 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_BLOCK_BUTTON_ENABLED, true ,"selectedPeriod") {
        
            @Override
            public void processDataBinding() {
                blockButton.setEnabled(isSelectedPeriod());
            }
        });
    }

}