package org.chorem.lima.ui.entrybook;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.EntryBooksChartEnum;
import static org.nuiton.i18n.I18n.t;

public class EntryBookImportForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAJ1Vz08TQRSeLrSlrSiUgMiPiEjiwWSLZ4gChWpJEQKYEHtx2h3owuzOOjsLSwjGP8E/Qe9eTLx5Mh48e/Bi/BeM8eDV+Gba7rZ0tQ09bLcz7/ve9968b/r2B4q7HN06xL6vc88WpkX09eW9vc3KIamKVeJWuekIxlH9E9OQVkYZI1h3BbpdLkl4rgHP5ZnlMJvYLeiFEkq74pQSt0aIEGi6HVF13dxOsL3gOx5vsgaiolhf//qpvTJevtEQ8h1Ql4JSZrqhwkr6S0gzDYGykOkY5yi2D0AGN+0D0Dso1/IUu+5jbJHn6AVKllDCwRzIBJrtvWTFofC+I9AIBPHTFcaOigDhosC4JdA84wd6tcY4sXRqWlj3TF0FViBQX+uEOI6iTAiUqXhCMPshZx7Qz7ZV755ALeo4V8KgEDqADWNHYEEEGpbV6rIDOiSiBNthWHJuF1comRdoPIJd7cnIVAAYDmp0V8k+9qhQ0GPsNxVtY8NkdU0Skw2gQyG0Xqxcv94eMzC3voVtQkFQto1VrbZLSVSxXSUU+t4WGaaeCEI1diTfbjZWOZpsqxZmVA9nNByiWBnFuQfLUGO5c6y3Yas+0OMXBloSqt0/YyNfP3x/X2id4tHI0BYTwnQ5nDmEC1OmvlYfYU+YNLeBnYUysBAKDlYOnYoQttPYBnGQr37+Eq4/wm4NKOLJbx8/jT370oe0AkpTho0ClvFFlBI1Dl1g1PCdB0tK0ZWTAXgOSW0CxYUpKLRoQk1ycKC6qQ5U34fx9aEfUxH9CERVUp9/j+y8W2r2JAYab/wzPOxL/ClKmDY1baK83bBtpJczjks8g4X2jDIsinZs00R31PNuRxf6YUrr/Sdwv/QL7hH5RXxwwtiFthhNi7Q7efCs5ec5dPUYU8kyfRZcB26+hrlYsz1LX10rLD8p7Z77nhSUUx2Tb/dQlB27ye8LxI5GnmGvWqcitRY3tja3o6V22L+bUi1QmlFKm3ZPw6yazC5WmR1cAlEJG1u9p0mqNOzoQgq4PKLoYbkbNRhmtDECecpcsgmexpJYoKuLBhZ4pmLaBtxa9zsSxOQz3UOCBMWnzFN3Kb48S9xiBobeZhfrDpvBAv4s4eTJpaXJ5f3/yJoEhr9kqYw1owgAAA==";
    private static final Log log = LogFactory.getLog(EntryBookImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected Boolean addState;
    protected JAXXButtonGroup buttonGroup;
    protected JButton cancel;
    protected EntryBookImportForm entryBookImportForm = this;
    protected JRadioButton entryBooksDefault;
    protected JRadioButton entryBooksImport;
    protected JButton ok;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            buttonGroup.setSelectedValue(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookImportForm() {
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Window param0) {
        super(param0);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookImportForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doWindowClosing__on__entryBookImportForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public Boolean getAddState() {
        return addState;
    }

    public JAXXButtonGroup getButtonGroup() {
        return buttonGroup;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JRadioButton getEntryBooksDefault() {
        return entryBooksDefault;
    }

    public JRadioButton getEntryBooksImport() {
        return entryBooksImport;
    }

    public JButton getOk() {
        return ok;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEntryBookImportForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0, BorderLayout.CENTER);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createButtonGroup() {
        $objectMap.put("buttonGroup", buttonGroup = new JAXXButtonGroup());
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createEntryBooksDefault() {
        $objectMap.put("entryBooksDefault", entryBooksDefault = new JRadioButton());
        
        entryBooksDefault.setName("entryBooksDefault");
        entryBooksDefault.setText(t("lima.entryBook.default"));
        entryBooksDefault.setSelected(true);
    }

    protected void createEntryBooksImport() {
        $objectMap.put("entryBooksImport", entryBooksImport = new JRadioButton());
        
        entryBooksImport.setName("entryBooksImport");
        entryBooksImport.setText(t("lima.entryBook.import"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEntryBookImportForm();
        // inline complete setup of $Table0
        $Table0.add(entryBooksDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(entryBooksImport, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 9 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        { ButtonGroup $buttonGroup = buttonGroup; entryBooksDefault.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(entryBooksDefault); }
        
        { entryBooksDefault.putClientProperty("$value", EntryBooksChartEnum.DEFAULT);  Object $buttonGroup = entryBooksDefault.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { ButtonGroup $buttonGroup = buttonGroup; entryBooksImport.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(entryBooksImport); }
        
        { entryBooksImport.putClientProperty("$value", EntryBooksChartEnum.IMPORT);  Object $buttonGroup = entryBooksImport.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof JAXXButtonGroup) { ((JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        entryBookImportForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("entryBookImportForm", entryBookImportForm);
        createButtonGroup();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createEntryBooksDefault();
        createEntryBooksImport();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of entryBookImportForm
        setName("entryBookImportForm");
        entryBookImportForm.getContentPane().setLayout(new BorderLayout());
        setModal(true);
        setTitle(t("lima.entryBook.import.form"));
        entryBookImportForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__entryBookImportForm"));
        
        getRootPane().setDefaultButton(ok);$completeSetup();
    }

}