package org.chorem.lima.ui.financialstatementchart;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dialog.ModalityType;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.Table;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialStatement;
import static org.nuiton.i18n.I18n.t;

public class FinancialStatementMovementForm extends JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_FINANCIAL_STATEMENT = "financialStatement";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_ACCOUNTS_TEXT_FIELD_TEXT = "accountsTextField.text";
    public static final String BINDING_CREDIT_ACCOUNTS_TEXT_FIELD_TEXT = "creditAccountsTextField.text";
    public static final String BINDING_DEBIT_ACCOUNTS_TEXT_FIELD_TEXT = "debitAccountsTextField.text";
    public static final String BINDING_LABEL_TEXT_FIELD_TEXT = "labelTextField.text";
    public static final String BINDING_PROVISION_DEPRECATION_ACCOUNTS_TEXT_FIELD_TEXT = "provisionDeprecationAccountsTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVXz28bRRSemNr5RSmJVbdAQWmblkZq1zn0loimTWSRyKVVnUNVXxjvTuJpZ3e2s2/TjSoQf0L/BLhzAXHjhDhw5sAF8S8gxIEr4s3YXmft2fVK+LC23rz3fe+9nfne+Ns/STVS5OpzmiSOigPgPnMO7j99+qj3nLmwxyJX8RCkIoPPXIVUumTZS+0RkOvdtg5vDsObu9IPZcCCM9FbbbIUwalgUZ8xAPJhNsKNomYnXd5KwliNUNOkbKhf//1X5Y331TcVQpIQs6tjKWuzosaVnGuTCveArCLTCW0KGhxjGooHx5jveW3bFTSKPqM+e0m+JPNtUgupQjAg18qXbDBMfBIC+eiIBzRwORUdoMB8jHkoT8x3SyofyL5Ux47bl4r5juA+dWLupDHRKMbtUwVOqxArDA1tDQucJgWyMUmEVg6nFtAx0AL1PGMGsqL74+ieOQ+kFIwGY7f59UPaE2wTyOXM24heYW8ds6Y9F9OAJUF7TLT1A7PVyMnQ+cAYtdtq6v2O8T5kCbQ4E/gCG5mIdCEb1aCuKzGRqMMEbm0ug0MOg0QuZT3PjzxT7gmHlZFDhur9rNOqx3oc7s+AamS8ivDqrmLebMBLWbcixKuhkic8wk7ssVAxl+qmzMK/URRUxLYy1X8L+sL6wWMaMLE5uQ2MNbtpai7uU71h6hnPBzHAALuZulbkC/3r7tCqyAeZfYn644z1ZywQc11SVTGacSN3pyXrCS4NxOryhFhpQLP6b6P+249//NAaKdQqcl+0up4RWFQObHLIFHBNfWEgTzFw0XxIw60uWYxMC436XrEk1hkuY3LINzipOtz5lEZ9hKjO//7Tz43Pf32LVFp49iT1WlT775NF6CvsghReEt7bMRm9/WoBn+/q3IBUQZ8Z3AVGMaZlxfGHAuQcoQIl2Jorltak+fUWf/mn3vluZ9SeOUz3vVz3cYuqz0iNB4IHzEj4UJ2tkr0cRiz25FiFbbpMZgpzOFS3bfPcsfXmHODux9mW1xqjWkms4/dMrfpXi2TUrzzN+utjBtNafWvDQbvBurXxhY1tQj3LMzbzCps62A7uNYyxkOeIcPkk1mYlYWPNCnp5so+LejzSvJw2T8+I8ry5pyszLGyslqFTnvZ2Ubl7Z4Fzas4ZZuUzuJlXeHao2bht47E88Z2i0nczyDm1583d8jnczSu+aOLaUpk918sntVXUmMcFPDltKnd9KJ/fRmlRKjykqdcs5krKvGyYR3eQJWrC910ZpDcTG+NwqTzNvKGRLyYo8EZjg0dzid5d9NgRjQXsChmxR3jRMG8BR8O2R4Gu9Xjg4VXqkymCOf1cKkFQ9aVH9VV+ezCl1yjg/6peDOx/gNYEPZUx6PXv7SibiPIf493VD9IOAAA=";
    private static final Log log = LogFactory.getLog(FinancialStatementMovementForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JLabel accountsLabel;
    protected JLabel accountsSelection;
    protected JLabel accountsSelectionTitle;
    protected JTextField accountsTextField;
    protected Boolean addState;
    protected JButton cancel;
    protected JLabel creditAccountsLabel;
    protected JTextField creditAccountsTextField;
    protected JLabel debitAccountsLabel;
    protected JTextField debitAccountsTextField;
    protected FinancialStatement financialStatement;
    protected FinancialStatementMovementForm financialStatementMovementForm = this;
    protected JLabel labelLabel;
    protected JTextField labelTextField;
    protected JButton ok;
    protected JLabel provisionDeprecationAccountsLabel;
    protected JTextField provisionDeprecationAccountsTextField;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JPanel $JPanel0;
    private Table $Table0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setFinancialStatement(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public FinancialStatementMovementForm(Frame param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm() {
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, ModalityType param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, ModalityType param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1, ModalityType param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Window param0, String param1, ModalityType param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Window param1, String param2, ModalityType param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Frame param0, String param1, boolean param2, GraphicsConfiguration param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Frame param1, String param2, boolean param3, GraphicsConfiguration param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0) {
        super(param0);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1) {
        super(param0 ,param1);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public FinancialStatementMovementForm(Dialog param0, String param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public FinancialStatementMovementForm(JAXXContext parentContext, Dialog param1, String param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__cancel(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    public void doActionPerformed__on__ok(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        dispose();
    }

    public void doKeyReleased__on__accountsTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setAccounts(getAccountsTextField().getText());
    }

    public void doKeyReleased__on__creditAccountsTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setCreditAccounts(getCreditAccountsTextField().getText());
    }

    public void doKeyReleased__on__debitAccountsTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setDebitAccounts(getDebitAccountsTextField().getText());
    }

    public void doKeyReleased__on__labelTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setLabel(labelTextField.getText());
    }

    public void doKeyReleased__on__provisionDeprecationAccountsTextField(KeyEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        getFinancialStatement().setProvisionDeprecationAccounts(getProvisionDeprecationAccountsTextField().getText());
    }

    public void doWindowClosing__on__financialStatementMovementForm(WindowEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        performCancel();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JLabel getAccountsLabel() {
        return accountsLabel;
    }

    public JLabel getAccountsSelection() {
        return accountsSelection;
    }

    public JLabel getAccountsSelectionTitle() {
        return accountsSelectionTitle;
    }

    public JTextField getAccountsTextField() {
        return accountsTextField;
    }

    public Boolean getAddState() {
        return addState;
    }

    public JButton getCancel() {
        return cancel;
    }

    public JLabel getCreditAccountsLabel() {
        return creditAccountsLabel;
    }

    public JTextField getCreditAccountsTextField() {
        return creditAccountsTextField;
    }

    public JLabel getDebitAccountsLabel() {
        return debitAccountsLabel;
    }

    public JTextField getDebitAccountsTextField() {
        return debitAccountsTextField;
    }

    public FinancialStatement getFinancialStatement() {
        return financialStatement;
    }

    public JLabel getLabelLabel() {
        return labelLabel;
    }

    public JTextField getLabelTextField() {
        return labelTextField;
    }

    public JButton getOk() {
        return ok;
    }

    public JLabel getProvisionDeprecationAccountsLabel() {
        return provisionDeprecationAccountsLabel;
    }

    public JTextField getProvisionDeprecationAccountsTextField() {
        return provisionDeprecationAccountsTextField;
    }

    public Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(Boolean addState) {
        Boolean oldValue = this.addState;
        this.addState = addState;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, addState);
    }

    public void setFinancialStatement(FinancialStatement financialStatement) {
        FinancialStatement oldValue = this.financialStatement;
        this.financialStatement = financialStatement;
        firePropertyChange(PROPERTY_FINANCIAL_STATEMENT, oldValue, financialStatement);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel0() {
        return $JPanel0;
    }

    protected Table get$Table0() {
        return $Table0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToFinancialStatementMovementForm() {
        if (!allComponentsCreated) {
            return;
        }
        add($Table0);
        add($JPanel0, BorderLayout.SOUTH);
    }

    protected void createAccountsLabel() {
        $objectMap.put("accountsLabel", accountsLabel = new JLabel());
        
        accountsLabel.setName("accountsLabel");
        accountsLabel.setText(t("lima.financialStatement.accounts"));
    }

    protected void createAccountsSelection() {
        $objectMap.put("accountsSelection", accountsSelection = new JLabel());
        
        accountsSelection.setName("accountsSelection");
        accountsSelection.setText(t("lima.financialStatement.accountsSelection"));
    }

    protected void createAccountsSelectionTitle() {
        $objectMap.put("accountsSelectionTitle", accountsSelectionTitle = new JLabel());
        
        accountsSelectionTitle.setName("accountsSelectionTitle");
        accountsSelectionTitle.setText(t("lima.financialStatement.accountsSelection.tilte"));
    }

    protected void createAccountsTextField() {
        $objectMap.put("accountsTextField", accountsTextField = new JTextField());
        
        accountsTextField.setName("accountsTextField");
        accountsTextField.setColumns(15);
        accountsTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__accountsTextField"));
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createCancel() {
        $objectMap.put("cancel", cancel = new JButton());
        
        cancel.setName("cancel");
        cancel.setText(t("lima.cancel"));
        cancel.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__cancel"));
    }

    protected void createCreditAccountsLabel() {
        $objectMap.put("creditAccountsLabel", creditAccountsLabel = new JLabel());
        
        creditAccountsLabel.setName("creditAccountsLabel");
        creditAccountsLabel.setText(t("lima.financialStatement.creditAccounts"));
    }

    protected void createCreditAccountsTextField() {
        $objectMap.put("creditAccountsTextField", creditAccountsTextField = new JTextField());
        
        creditAccountsTextField.setName("creditAccountsTextField");
        creditAccountsTextField.setColumns(15);
        creditAccountsTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__creditAccountsTextField"));
    }

    protected void createDebitAccountsLabel() {
        $objectMap.put("debitAccountsLabel", debitAccountsLabel = new JLabel());
        
        debitAccountsLabel.setName("debitAccountsLabel");
        debitAccountsLabel.setText(t("lima.financialStatement.debitAccounts"));
    }

    protected void createDebitAccountsTextField() {
        $objectMap.put("debitAccountsTextField", debitAccountsTextField = new JTextField());
        
        debitAccountsTextField.setName("debitAccountsTextField");
        debitAccountsTextField.setColumns(15);
        debitAccountsTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__debitAccountsTextField"));
    }

    protected void createFinancialStatement() {
        $objectMap.put("financialStatement", financialStatement = null);
    }

    protected void createLabelLabel() {
        $objectMap.put("labelLabel", labelLabel = new JLabel());
        
        labelLabel.setName("labelLabel");
        labelLabel.setText(t("lima.financialStatement.label"));
    }

    protected void createLabelTextField() {
        $objectMap.put("labelTextField", labelTextField = new JTextField());
        
        labelTextField.setName("labelTextField");
        labelTextField.setColumns(15);
        labelTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__labelTextField"));
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new JButton());
        
        ok.setName("ok");
        ok.setText(t("lima.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createProvisionDeprecationAccountsLabel() {
        $objectMap.put("provisionDeprecationAccountsLabel", provisionDeprecationAccountsLabel = new JLabel());
        
        provisionDeprecationAccountsLabel.setName("provisionDeprecationAccountsLabel");
        provisionDeprecationAccountsLabel.setText(t("lima.financialStatement.provisionDeprecationAccounts"));
    }

    protected void createProvisionDeprecationAccountsTextField() {
        $objectMap.put("provisionDeprecationAccountsTextField", provisionDeprecationAccountsTextField = new JTextField());
        
        provisionDeprecationAccountsTextField.setName("provisionDeprecationAccountsTextField");
        provisionDeprecationAccountsTextField.setColumns(15);
        provisionDeprecationAccountsTextField.addKeyListener(JAXXUtil.getEventListener(KeyListener.class, "keyReleased", this, "doKeyReleased__on__provisionDeprecationAccountsTextField"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToFinancialStatementMovementForm();
        // inline complete setup of $Table0
        $Table0.add(labelLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsSelectionTitle, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsTextField, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(debitAccountsLabel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(debitAccountsTextField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(creditAccountsLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(creditAccountsTextField, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(provisionDeprecationAccountsLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(provisionDeprecationAccountsTextField, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(accountsSelection, new GridBagConstraints(0, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $JPanel0
        $JPanel0.add(cancel);
        $JPanel0.add(ok);
        
        // apply 5 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 4 property setters
        setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
        cancel.setIcon(SwingUtil.createActionIcon("cancel"));
        ok.setIcon(SwingUtil.createActionIcon("ok"));
        // late initializer
        financialStatementMovementForm.pack();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("financialStatementMovementForm", financialStatementMovementForm);
        createFinancialStatement();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new Table());
        
        $Table0.setName("$Table0");
        createLabelLabel();
        createLabelTextField();
        createAccountsSelectionTitle();
        createAccountsLabel();
        createAccountsTextField();
        createDebitAccountsLabel();
        createDebitAccountsTextField();
        createCreditAccountsLabel();
        createCreditAccountsTextField();
        createProvisionDeprecationAccountsLabel();
        createProvisionDeprecationAccountsTextField();
        createAccountsSelection();
        // inline creation of $JPanel0
        $objectMap.put("$JPanel0", $JPanel0 = new JPanel());
        
        $JPanel0.setName("$JPanel0");
        $JPanel0.setLayout(new GridLayout(1,0));
        createCancel();
        createOk();
        // inline creation of financialStatementMovementForm
        setName("financialStatementMovementForm");
        setModal(true);
        setTitle(t("lima.financialStatement.movement.form"));
        financialStatementMovementForm.addWindowListener(JAXXUtil.getEventListener(WindowListener.class, "windowClosing", this, "doWindowClosing__on__financialStatementMovementForm"));
        
        getRootPane().setDefaultButton(ok);// registers 5 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 5 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_LABEL_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(labelTextField, getFinancialStatement().getLabel());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_ACCOUNTS_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(accountsTextField, getFinancialStatement().getAccounts());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_DEBIT_ACCOUNTS_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(debitAccountsTextField, getFinancialStatement().getDebitAccounts());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_CREDIT_ACCOUNTS_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(creditAccountsTextField, getFinancialStatement().getCreditAccounts());
                }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_PROVISION_DEPRECATION_ACCOUNTS_TEXT_FIELD_TEXT, true ,"financialStatement") {
        
            @Override
            public void processDataBinding() {
                if (getFinancialStatement() != null) {
                    SwingUtil.setText(provisionDeprecationAccountsTextField, getFinancialStatement().getProvisionDeprecationAccounts());
                }
            }
        });
    }

}