package org.chorem.lima.ui.lettering;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JToolBar.Separator;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import jaxx.runtime.swing.editor.EnumEditor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.Account;
import org.chorem.lima.ui.common.AccountComboBoxModel;
import org.chorem.lima.ui.common.FinancialPeriodComboBoxModel;
import org.chorem.lima.util.BigDecimalToString;
import org.jdesktop.swingx.JXDatePicker;
import static org.nuiton.i18n.I18n.t;

public class LetteringView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVYSW8cRRQuTzzektiO14RsJhiJzT2JTU5GkM2WY00gylgoYi7UdJc97fRUdbqr7TEjI34CPwHuXJC4cUIcOHPggvgLCHHgGvGqeqmpnppMDyg5tMZdb/m+V69efZ3v/kTlMECvH+J22woiyt0WsXbvPn36SeOQ2PwBCe3A9TkLUPxvpIRKdXTWyd6HHL1Rrwr3SuJeuc9aPqOEdnlvVtFUyE88EjYJ4Rxd1T3sMKzUsuXNth8FadQMlCnqN3//Vfra+erbEkJtH9C9CVRWBnkpJqNVVHIdjuYg0xGueJgeAIzApQeA97x4d9/DYfgxbpHn6Es0XkVjPg4gGEc3ilOWMaR/2+doYnX3MabEu8nROyw4sOwmC0jL8twWtiLX8qA6RCCwqumvT11y7PsywhhH401MHY8EHN0q7r4T+6gok8Rx+SPmEI+jSrE4W6mHijK1urvHmHcPB8BmQdSrbYXHwit9LwwnATSHPxs4SB0n4vgEaj+vud2LOGdUWM2pLJRVE3Px5qK+Wg5YRE0LCxm41RqBbcOwJwDzmgmmstBjnMO2DeF5FTdEpeY0X/kylzOxh3ZosHusnVTYMlTYZq0Wo9Zdg4Mq8EwuHkeLGoT0vY5itIHtZ4aKjFLS5gUrdUusXdftZhvkwKWPoRuYk5G/odtc6LJ57NrPRKOuCPqHMDKecebH0NvW7tMHmJPYRA8xTajz8iQzmYXy3xjMad3AaS7txC3Kg5N+CRc1K7Ubq9qsiTdFnCwWWFs0am3Jn4OBbRiAjQdkP4B5aNivdITcynekfCuPnOGIyh1dEI/7vQdyyiENl+v0t9WOyNU96J5tl3hwaK9rabdZ0MJQHyez0N1NlN/PKCu7s3YgitcPxUy83AVjST/LxbPfNmSfDJnn9Mt9XixqCfZyBqu7NTtgnif2AMbMsgZNLcn6q93huOGRZErcLDaH9zIXNSeWM7sa8eDadhlNgm4MDNrrpeKWJT6O3h0CmnCt+3ARX9YOB1zxlrri1R08UocRHsFrji7We1XBE1iK9cDFnB4QAeXqi6X5337844ftVAS8BrkXjaZdGgYuZz9gPownV6SeiRVAxF2v8gj7m3VoB1kTKXCuGIDVkmUAB/kuCHdLuFs7OGxCiPL47z/9vPT5r2dQaRtNeQw721jYP4T7sCkONjRU2//ojkR07ngCnrMCGzTiPlgnhS/vYy8kbaB/xUA/w9CY/OWf+dr3d9ISjACkS33NVRnKn6Exl3ouJVIJJSLHqHzO+iGJHKbEjEneIN/3c8PFk89eomfAjlDBUoiATqZHZF/BQT+F04FlTz60GYWqZP0Gg0Ik2HN9cSBF84uOVO2Yzup2JDJzWQ7x6wh1CQ8/afJC8Ba74EW0agZ4LqJrfTFeymGMo/RD2aV4/jNO8jzCnvtFL87xBgaha5NBZUwDmADGomsQtpKotxiocEGAMujkxEwe2DQMGBaStcTMlFfTYwVKU27FU3Apn1vW6DRfgqVcCRInoAGi34HtABq3O5QcrwwUdFU35E8Sp7fePjWRyYu7AuXU6jXhB+TIZVGYp3HZTMMSstAEROrFYbNLMVk0s7A1ZhYLw7XRfKdHYcI+jnJjfl9aWdLDlL9H0Q7b0jkhqpDkD3yCBOxNOHKSdzgUyx2jOu2ZT8nxIsLIBMIghQcBGck3wEJ+iPRLZlbUwzZhKpIHHeTEzAQkDTFczWc7uiRWG38tlzpMpZUlPYzjXonvAigm95kdhd3yoPsKSAWDocd0xMN2ek58K8LX+xKOXUxYupX+K6Sc/2IYjvNMRxP9ivHVvoyFgwmI+rZ4hWz1b5QiXEOgqeeZDNjxDnEPmkCztL5uvPulS4HJMObhExZBoOkPHNCzKw2XOlCuD3uCjojnVIGIo64t/3NoZM0cY7NAjGyD/1cc4fzeSyI8KIAkFicvCVKkyNOh9uk2INq/V/hh0+4VAAA=";
    private static final Log log = LogFactory.getLog(LetteringView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JComboBox accountComboBox;
    protected AccountComboBoxModel accountComboBoxModel;
    protected JLabel accountLabel;
    protected JButton back;
    protected JLabel beginPeriodLabel;
    protected JXDatePicker beginPeriodPicker;
    protected JLabel creditLabel;
    protected JTextField creditTextField;
    protected JLabel debitLabel;
    protected JFormattedTextField debitTextField;
    protected LetteringEditModel editModel;
    protected JLabel endPeriodLabel;
    protected JXDatePicker endPeriodPicker;
    protected LetteringViewHandler handler;
    protected JButton lettered;
    protected EnumEditor<TypeEntry> letteredEntryComboBox;
    protected JLabel letteredEntryLabel;
    protected LettringSelectionModel letteringSelectionModel;
    protected JButton next;
    protected JButton noLettered;
    protected JButton refresh;
    protected JButton round;
    protected JLabel soldLabel;
    protected JTextField soldTextField;
    protected LetteringTable table;
    protected LetteringTableModel tableModel;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private LetteringView $JPanel0 = this;
    private JPanel $JPanel1;
    private JScrollPane $JScrollPane0;
    private Separator $JToolBar$Separator0;
    private Separator $JToolBar$Separator1;
    private Separator $JToolBar$Separator2;
    private Separator $JToolBar$Separator3;
    private Separator $JToolBar$Separator4;
    private Separator $JToolBar$Separator5;
    private JToolBar $JToolBar0;
    private JToolBar $JToolBar1;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
          handler.init();
      }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public LetteringView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView() {
        $initialize();
    }

    public LetteringView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public LetteringView(boolean param0) {
        super(param0);
        $initialize();
    }

    public LetteringView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__back(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.back(accountComboBox);
    }

    public void doActionPerformed__on__beginPeriodPicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateStart(beginPeriodPicker.getDate());
    }

    public void doActionPerformed__on__endPeriodPicker(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setDateEnd(endPeriodPicker.getDate());
    }

    public void doActionPerformed__on__lettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addLetter();
    }

    public void doActionPerformed__on__next(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.next(accountComboBox);
    }

    public void doActionPerformed__on__noLettered(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeLetter();
    }

    public void doActionPerformed__on__refresh(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAllEntries();
    }

    public void doActionPerformed__on__round(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.roundAndCreateEntry();
    }

    public void doItemStateChanged__on__accountComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setAccount((Account)accountComboBoxModel.getSelectedItem());
    }

    public void doItemStateChanged__on__letteredEntryComboBox(ItemEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setTypeEntry(letteredEntryComboBox.getSelectedItem());
    }

    public void doValueChanged__on__letteringSelectionModel(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.balanceAndActions();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JComboBox getAccountComboBox() {
        return accountComboBox;
    }

    public AccountComboBoxModel getAccountComboBoxModel() {
        return accountComboBoxModel;
    }

    public JLabel getAccountLabel() {
        return accountLabel;
    }

    public JButton getBack() {
        return back;
    }

    public JLabel getBeginPeriodLabel() {
        return beginPeriodLabel;
    }

    public JXDatePicker getBeginPeriodPicker() {
        return beginPeriodPicker;
    }

    public JLabel getCreditLabel() {
        return creditLabel;
    }

    public JTextField getCreditTextField() {
        return creditTextField;
    }

    public JLabel getDebitLabel() {
        return debitLabel;
    }

    public JFormattedTextField getDebitTextField() {
        return debitTextField;
    }

    public LetteringEditModel getEditModel() {
        return editModel;
    }

    public JLabel getEndPeriodLabel() {
        return endPeriodLabel;
    }

    public JXDatePicker getEndPeriodPicker() {
        return endPeriodPicker;
    }

    public LetteringViewHandler getHandler() {
        return handler;
    }

    public JButton getLettered() {
        return lettered;
    }

    public EnumEditor<TypeEntry> getLetteredEntryComboBox() {
        return letteredEntryComboBox;
    }

    public JLabel getLetteredEntryLabel() {
        return letteredEntryLabel;
    }

    public LettringSelectionModel getLetteringSelectionModel() {
        return letteringSelectionModel;
    }

    public JButton getNext() {
        return next;
    }

    public JButton getNoLettered() {
        return noLettered;
    }

    public JButton getRefresh() {
        return refresh;
    }

    public JButton getRound() {
        return round;
    }

    public JLabel getSoldLabel() {
        return soldLabel;
    }

    public JTextField getSoldTextField() {
        return soldTextField;
    }

    public LetteringTable getTable() {
        return table;
    }

    public LetteringTableModel getTableModel() {
        return tableModel;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JPanel get$JPanel1() {
        return $JPanel1;
    }

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected Separator get$JToolBar$Separator0() {
        return $JToolBar$Separator0;
    }

    protected Separator get$JToolBar$Separator1() {
        return $JToolBar$Separator1;
    }

    protected Separator get$JToolBar$Separator2() {
        return $JToolBar$Separator2;
    }

    protected Separator get$JToolBar$Separator3() {
        return $JToolBar$Separator3;
    }

    protected Separator get$JToolBar$Separator4() {
        return $JToolBar$Separator4;
    }

    protected Separator get$JToolBar$Separator5() {
        return $JToolBar$Separator5;
    }

    protected JToolBar get$JToolBar0() {
        return $JToolBar0;
    }

    protected JToolBar get$JToolBar1() {
        return $JToolBar1;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccountComboBox() {
        $objectMap.put("accountComboBox", accountComboBox = new JComboBox());
        
        accountComboBox.setName("accountComboBox");
        accountComboBox.setToolTipText(t("lima.lettering.account"));
        accountComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__accountComboBox"));
    }

    protected void createAccountComboBoxModel() {
        $objectMap.put("accountComboBoxModel", accountComboBoxModel = new AccountComboBoxModel());
    }

    protected void createAccountLabel() {
        $objectMap.put("accountLabel", accountLabel = new JLabel());
        
        accountLabel.setName("accountLabel");
    }

    protected void createBack() {
        $objectMap.put("back", back = new JButton());
        
        back.setName("back");
        back.setToolTipText(t("lima.lettering.account.back"));
        back.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__back"));
    }

    protected void createBeginPeriodLabel() {
        $objectMap.put("beginPeriodLabel", beginPeriodLabel = new JLabel());
        
        beginPeriodLabel.setName("beginPeriodLabel");
        beginPeriodLabel.setText(t("lima.lettering.period.begin"));
    }

    protected void createBeginPeriodPicker() {
        $objectMap.put("beginPeriodPicker", beginPeriodPicker = new JXDatePicker());
        
        beginPeriodPicker.setName("beginPeriodPicker");
        beginPeriodPicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__beginPeriodPicker"));
    }

    protected void createCreditLabel() {
        $objectMap.put("creditLabel", creditLabel = new JLabel());
        
        creditLabel.setName("creditLabel");
        creditLabel.setText(t("lima.lettering.selection.credit"));
    }

    protected void createCreditTextField() {
        $objectMap.put("creditTextField", creditTextField = new JTextField());
        
        creditTextField.setName("creditTextField");
        creditTextField.setColumns(15);
        creditTextField.setEnabled(false);
        creditTextField.setFocusable(false);
    }

    protected void createDebitLabel() {
        $objectMap.put("debitLabel", debitLabel = new JLabel());
        
        debitLabel.setName("debitLabel");
        debitLabel.setText(t("lima.lettering.selection.debit"));
    }

    protected void createDebitTextField() {
        $objectMap.put("debitTextField", debitTextField = new JFormattedTextField());
        
        debitTextField.setName("debitTextField");
        debitTextField.setColumns(15);
        debitTextField.setEnabled(false);
        debitTextField.setFocusable(false);
    }

    protected void createEditModel() {
        $objectMap.put("editModel", editModel = new LetteringEditModel());
    }

    protected void createEndPeriodLabel() {
        $objectMap.put("endPeriodLabel", endPeriodLabel = new JLabel());
        
        endPeriodLabel.setName("endPeriodLabel");
        endPeriodLabel.setText(t("lima.lettering.period.end"));
    }

    protected void createEndPeriodPicker() {
        $objectMap.put("endPeriodPicker", endPeriodPicker = new JXDatePicker());
        
        endPeriodPicker.setName("endPeriodPicker");
        endPeriodPicker.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__endPeriodPicker"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new LetteringViewHandler(this));
    }

    protected void createLettered() {
        $objectMap.put("lettered", lettered = new JButton());
        
        lettered.setName("lettered");
        lettered.setToolTipText(t("lima.lettering.lettered"));
        lettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__lettered"));
    }

    protected void createLetteredEntryComboBox() {
        $objectMap.put("letteredEntryComboBox", letteredEntryComboBox = new EnumEditor<TypeEntry>(TypeEntry.class));
        
        letteredEntryComboBox.setName("letteredEntryComboBox");
        letteredEntryComboBox.setToolTipText(t("lima.lettering.entry"));
        letteredEntryComboBox.addItemListener(JAXXUtil.getEventListener(ItemListener.class, "itemStateChanged", this, "doItemStateChanged__on__letteredEntryComboBox"));
    }

    protected void createLetteredEntryLabel() {
        $objectMap.put("letteredEntryLabel", letteredEntryLabel = new JLabel());
        
        letteredEntryLabel.setName("letteredEntryLabel");
    }

    protected void createLetteringSelectionModel() {
        $objectMap.put("letteringSelectionModel", letteringSelectionModel = new LettringSelectionModel(tableModel));
        
        letteringSelectionModel.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__letteringSelectionModel"));
    }

    protected void createNext() {
        $objectMap.put("next", next = new JButton());
        
        next.setName("next");
        next.setToolTipText(t("lima.lettering.account.next"));
        next.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__next"));
    }

    protected void createNoLettered() {
        $objectMap.put("noLettered", noLettered = new JButton());
        
        noLettered.setName("noLettered");
        noLettered.setToolTipText(t("lima.lettering.unLettered"));
        noLettered.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__noLettered"));
    }

    protected void createRefresh() {
        $objectMap.put("refresh", refresh = new JButton());
        
        refresh.setName("refresh");
        refresh.setToolTipText(t("lima.lettering.refresh"));
        refresh.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__refresh"));
    }

    protected void createRound() {
        $objectMap.put("round", round = new JButton());
        
        round.setName("round");
        round.setToolTipText(t("lima.lettering.equalize"));
        round.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__round"));
    }

    protected void createSoldLabel() {
        $objectMap.put("soldLabel", soldLabel = new JLabel());
        
        soldLabel.setName("soldLabel");
        soldLabel.setText(t("lima.lettering.selection.sold"));
    }

    protected void createSoldTextField() {
        $objectMap.put("soldTextField", soldTextField = new JTextField());
        
        soldTextField.setName("soldTextField");
        soldTextField.setColumns(15);
        soldTextField.setEnabled(false);
        soldTextField.setFocusable(false);
    }

    protected void createTable() {
        $objectMap.put("table", table = new LetteringTable(handler));
        
        table.setName("table");
        table.setSortable(false);
        table.setRowHeight(22);
    }

    protected void createTableModel() {
        $objectMap.put("tableModel", tableModel = new LetteringTableModel());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add($JToolBar0, BorderLayout.PAGE_START);
        add($JPanel1, BorderLayout.CENTER);
        // inline complete setup of $JToolBar0
        $JToolBar0.add(lettered);
        $JToolBar0.add(noLettered);
        $JToolBar0.add(round);
        $JToolBar0.add($JToolBar$Separator0);
        $JToolBar0.add(accountLabel);
        $JToolBar0.add(accountComboBox);
        $JToolBar0.add(back);
        $JToolBar0.add(next);
        $JToolBar0.add($JToolBar$Separator1);
        $JToolBar0.add(beginPeriodLabel);
        $JToolBar0.add(beginPeriodPicker);
        $JToolBar0.add(endPeriodLabel);
        $JToolBar0.add(endPeriodPicker);
        $JToolBar0.add($JToolBar$Separator2);
        $JToolBar0.add(letteredEntryLabel);
        $JToolBar0.add(letteredEntryComboBox);
        $JToolBar0.add($JToolBar$Separator3);
        $JToolBar0.add(refresh);
        // inline complete setup of $JPanel1
        $JPanel1.add($JToolBar1, BorderLayout.PAGE_START);
        $JPanel1.add($JScrollPane0, BorderLayout.CENTER);
        // inline complete setup of $JToolBar1
        $JToolBar1.add(debitLabel);
        $JToolBar1.add(debitTextField);
        $JToolBar1.add($JToolBar$Separator4);
        $JToolBar1.add(creditLabel);
        $JToolBar1.add(creditTextField);
        $JToolBar1.add($JToolBar$Separator5);
        $JToolBar1.add(soldLabel);
        $JToolBar1.add(soldTextField);
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(table);
        
        // apply 25 property setters
        letteredEntryLabel.setIcon(SwingUtil.createActionIcon("choose-entry"));
        letteredEntryLabel.setLabelFor(letteredEntryComboBox);
        table.setModel(tableModel);
        table.setSelectionModel(letteringSelectionModel);
        lettered.setEnabled(editModel.lettred);
        lettered.setIcon(SwingUtil.createActionIcon("lettering"));
        noLettered.setEnabled(editModel.unLettred);
        noLettered.setIcon(SwingUtil.createActionIcon("un-lettering"));
        round.setEnabled(editModel.equalized);
        round.setIcon(SwingUtil.createActionIcon("balance"));
        accountLabel.setLabelFor(accountComboBox);
        accountLabel.setIcon(SwingUtil.createActionIcon("choose-account"));
        accountComboBox.setModel(accountComboBoxModel);
        accountComboBox.setRenderer(new org.chorem.lima.ui.common.AccountListRenderer());
        back.setIcon(SwingUtil.createActionIcon("previous"));
        next.setIcon(SwingUtil.createActionIcon("next"));
        beginPeriodLabel.setLabelFor(beginPeriodPicker);
        endPeriodLabel.setLabelFor(endPeriodPicker);
        letteredEntryLabel.setIcon(SwingUtil.createActionIcon("choose-entry"));
        refresh.setIcon(SwingUtil.createActionIcon("refresh"));
        debitLabel.setLabelFor(debitTextField);
        creditLabel.setLabelFor(creditTextField);
        soldLabel.setLabelFor(soldTextField);
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createEditModel();
        // inline creation of $JToolBar0
        $objectMap.put("$JToolBar0", $JToolBar0 = new JToolBar());
        
        $JToolBar0.setName("$JToolBar0");
        $JToolBar0.setFloatable(false);
        createLettered();
        createNoLettered();
        createRound();
        // inline creation of $JToolBar$Separator0
        $objectMap.put("$JToolBar$Separator0", $JToolBar$Separator0 = new Separator());
        
        $JToolBar$Separator0.setName("$JToolBar$Separator0");
        createAccountLabel();
        createAccountComboBoxModel();
        createAccountComboBox();
        createBack();
        createNext();
        // inline creation of $JToolBar$Separator1
        $objectMap.put("$JToolBar$Separator1", $JToolBar$Separator1 = new Separator());
        
        $JToolBar$Separator1.setName("$JToolBar$Separator1");
        createBeginPeriodLabel();
        createBeginPeriodPicker();
        createEndPeriodLabel();
        createEndPeriodPicker();
        // inline creation of $JToolBar$Separator2
        $objectMap.put("$JToolBar$Separator2", $JToolBar$Separator2 = new Separator());
        
        $JToolBar$Separator2.setName("$JToolBar$Separator2");
        createLetteredEntryLabel();
        createLetteredEntryComboBox();
        // inline creation of $JToolBar$Separator3
        $objectMap.put("$JToolBar$Separator3", $JToolBar$Separator3 = new Separator());
        
        $JToolBar$Separator3.setName("$JToolBar$Separator3");
        createRefresh();
        // inline creation of $JPanel1
        $objectMap.put("$JPanel1", $JPanel1 = new JPanel());
        
        $JPanel1.setName("$JPanel1");
        $JPanel1.setLayout(new BorderLayout());
        // inline creation of $JToolBar1
        $objectMap.put("$JToolBar1", $JToolBar1 = new JToolBar());
        
        $JToolBar1.setName("$JToolBar1");
        $JToolBar1.setFloatable(false);
        createDebitLabel();
        createDebitTextField();
        // inline creation of $JToolBar$Separator4
        $objectMap.put("$JToolBar$Separator4", $JToolBar$Separator4 = new Separator());
        
        $JToolBar$Separator4.setName("$JToolBar$Separator4");
        createCreditLabel();
        createCreditTextField();
        // inline creation of $JToolBar$Separator5
        $objectMap.put("$JToolBar$Separator5", $JToolBar$Separator5 = new Separator());
        
        $JToolBar$Separator5.setName("$JToolBar$Separator5");
        createSoldLabel();
        createSoldTextField();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createTableModel();
        createLetteringSelectionModel();
        createTable();
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        $completeSetup();
    }

}