package org.chorem.lima.ui.account;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import static org.nuiton.i18n.I18n.t;

public class AccountView extends JPanel implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_SELECTED_ROW = "selectedRow";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_REMOVE_BUTTON_ENABLED = "removeButton.enabled";
    public static final String BINDING_UPDATE_BUTTON_ENABLED = "updateButton.enabled";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Vz28bRRR+ceukjpOSNGkbRCmhTatUatdVW/USBG1CQmK5aZW1UFQfymR3Gk8Y70xnZuuNIhB/An8C3LkgceOEOHDmwAXxLyDEgSvize561z+2TSoRyet43q/vvXnft9/9CWWt4P0DEkWOCgPDOtSpP9zdfbx3QD3zMdWeYtIIBcnfWAlKLaj62bk2cLXVsOG1NLy2JjpSBDToi15pwKQ2h5zqNqXGwLuDEZ7WNTczr0QyVL2sGaiirN/8/Vfpa/+rb0sAkUR0VWxl8biovJPTDSgx38A5rPSS1DgJ9hGGYsE+4p22Z2ucaL1NOvQFfAkTDRiXRGEyA1dO3nKcI46PpIEzS/UnJKD8toHrQu07Xlso2nE46xAnZA7xPIE5nYfJ96eMdqWMo8cNTLRJ4HOqDNw6Wehm4p9nqGrK8VqpvyO6BmZti45t21kVglMS9NUyeLJKsNa89Yoc3cW5OPVmcmy9Kplzhfj+amiMCAzMDbgnp9btXOY9FUqfGJqbLg7ZsSvx8jV2hsNW5pX26aW66ynBuR00zvniAKLcNNjDbDo/3VSUNskepwbes2M+wGX/3AiZJIic+m7mYUMvZxnmlxpMGzeeMBPBI+HH13y5v/yoB45cwTsDS4t0cHI65Ps61oKyCvHYwEJrlEE7aEq4szDEHZswtv57Ye63H//4YaNHmAmsfb7QtY/vuMhSCYl7x2zptxK2hIbx2iMiV1pQSbYqFoNLBcDc1IzgsF6ydTbc2SS6jSnKE7//9POFz349BaUNmOSC+BvE+m9BxbQVTkFwP5IfPYgRTXXP4HPGYsPFe47eJrms8nPCNY2w/UsF7WcY9iq//DPnfv+gN4IxhPT2K93zMZSfwjgLOAtorBqpIBSqRFVqGvoiJ36RFEDOMZnS7mb8vD3SaMnAJIk3ZsuzFKumq3oroMjiqs3SZLJJIxSmmVgOelqAvIxCm/Re3Kn97z708/W40qcQJQ3sgFEnZ4+YdnMBWb7xxRCwqR4w6jMzjGw+EaqY+w7eqTJeaIrQDejD/wvwbA9gIjHFEBPb6yH2S9SbXl8GItGxYRALMYjEth7ZZ/qjEEi/Fp5gVlNttt/m+DHUsrV+tJn/Tkh36HiK4vhdzMypfR1KFK5lXLXFmLika/CtyoVavnP37s30c8NOelr3C5uBa0ejaue4W9ufNNafueuN9bXm1uNtjJsxqKdrlPMdGvhU2ffb4pGtl77JMrnt2fFei2YxquDHDQQVZJyTQ4HTg7Mf4NKRxT0W+NjvhyMFxuxzEjP+B2nMwZ4zCQAA";
    private static final Log log = LogFactory.getLog(AccountView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected JXTreeTable accountsTreeTable;
    protected JButton addButton;
    protected AccountViewHandler handler;
    protected JButton importButton;
    protected JButton removeButton;
    protected Boolean selectedRow;
    protected JToolBar toolBar;
    protected JButton updateButton;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountView $JPanel0 = this;
    private JScrollPane $JScrollPane0;
    private ListSelectionModel $ListSelectionModel0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/

    void $afterCompleteSetup() {
            handler.init();
          }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountView(LayoutManager param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public AccountView(JAXXContext parentContext, LayoutManager param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountView() {
        $initialize();
    }

    public AccountView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountView(LayoutManager param0) {
        super(param0);
        $initialize();
    }

    public AccountView(JAXXContext parentContext, LayoutManager param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public AccountView(boolean param0) {
        super(param0);
        $initialize();
    }

    public AccountView(JAXXContext parentContext, boolean param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__addButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.addAccount();
    }

    public void doActionPerformed__on__importButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.importAccountsChart();
    }

    public void doActionPerformed__on__removeButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.removeAccount();
    }

    public void doActionPerformed__on__updateButton(ActionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.updateAccount();
    }

    public void doValueChanged__on__$ListSelectionModel0(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        setSelectedRow(accountsTreeTable.getSelectedRow() != -1);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JXTreeTable getAccountsTreeTable() {
        return accountsTreeTable;
    }

    public JButton getAddButton() {
        return addButton;
    }

    public AccountViewHandler getHandler() {
        return handler;
    }

    public JButton getImportButton() {
        return importButton;
    }

    public JButton getRemoveButton() {
        return removeButton;
    }

    public Boolean getSelectedRow() {
        return selectedRow;
    }

    public JToolBar getToolBar() {
        return toolBar;
    }

    public JButton getUpdateButton() {
        return updateButton;
    }

    public Boolean isSelectedRow() {
        return selectedRow !=null && selectedRow;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setSelectedRow(Boolean selectedRow) {
        Boolean oldValue = this.selectedRow;
        this.selectedRow = selectedRow;
        firePropertyChange(PROPERTY_SELECTED_ROW, oldValue, selectedRow);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    protected ListSelectionModel get$ListSelectionModel0() {
        return $ListSelectionModel0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToToolBar() {
        if (!allComponentsCreated) {
            return;
        }
        toolBar.add(addButton);
        toolBar.add(updateButton);
        toolBar.add(removeButton);
        toolBar.add(importButton);
    }

    protected void createAccountsTreeTable() {
        $objectMap.put("accountsTreeTable", accountsTreeTable = new JXTreeTable());
        
        accountsTreeTable.setName("accountsTreeTable");
    }

    protected void createAddButton() {
        $objectMap.put("addButton", addButton = new JButton());
        
        addButton.setName("addButton");
        addButton.setToolTipText(t("lima.account.add"));
        addButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__addButton"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new AccountViewHandler(this));
    }

    protected void createImportButton() {
        $objectMap.put("importButton", importButton = new JButton());
        
        importButton.setName("importButton");
        importButton.setToolTipText(t("lima.importExport.import"));
        importButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__importButton"));
    }

    protected void createRemoveButton() {
        $objectMap.put("removeButton", removeButton = new JButton());
        
        removeButton.setName("removeButton");
        removeButton.setToolTipText(t("lima.remove.shortcut"));
        removeButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__removeButton"));
    }

    protected void createSelectedRow() {
        $objectMap.put("selectedRow", selectedRow = false);
    }

    protected void createToolBar() {
        $objectMap.put("toolBar", toolBar = new JToolBar());
        
        toolBar.setName("toolBar");
        toolBar.setFloatable(false);
    }

    protected void createUpdateButton() {
        $objectMap.put("updateButton", updateButton = new JButton());
        
        updateButton.setName("updateButton");
        updateButton.setToolTipText(t("lima.update.shortcut"));
        updateButton.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__updateButton"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        // inline complete setup of $JPanel0
        add(toolBar, BorderLayout.PAGE_START);
        add($JScrollPane0, BorderLayout.CENTER);
        addChildrenToToolBar();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(accountsTreeTable);
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 8 property setters
        addButton.setIcon(SwingUtil.createActionIcon("account-new"));
        updateButton.setIcon(SwingUtil.createActionIcon("account-edit"));
        removeButton.setIcon(SwingUtil.createActionIcon("account-remove"));
        importButton.setIcon(SwingUtil.createActionIcon("account-import"));
        accountsTreeTable.setHighlighters(HighlighterFactory.createSimpleStriping(new java.awt.Color(233,233,233)));
        accountsTreeTable.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
        accountsTreeTable.setTreeCellRenderer(new AccountTreeTableRenderer());
        $afterCompleteSetup();
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("$JPanel0", $JPanel0);
        createHandler();
        createSelectedRow();
        createToolBar();
        createAddButton();
        createUpdateButton();
        createRemoveButton();
        createImportButton();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createAccountsTreeTable();
        // inline creation of $ListSelectionModel0
        $objectMap.put("$ListSelectionModel0", $ListSelectionModel0 = accountsTreeTable.getSelectionModel());
        
        $ListSelectionModel0.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__$ListSelectionModel0"));
        // inline creation of $JPanel0
        setName("$JPanel0");
        setLayout(new BorderLayout());
        
        // registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_UPDATE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                updateButton.setEnabled(isSelectedRow());
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_REMOVE_BUTTON_ENABLED, true ,"selectedRow") {
        
            @Override
            public void processDataBinding() {
                removeButton.setEnabled(isSelectedRow());
            }
        });
    }

}