package org.chorem.lima.ui.Filter.EntryBookCondition;

/*
 * #%L
 * Lima :: Swing
 * %%
 * Copyright (C) 2008 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JInternalFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.JAXXUtil;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.context.DefaultJAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.ui.LimaRendererUtil;
import static org.nuiton.i18n.I18n.t;

public class EntryBookConditionView extends JInternalFrame implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_HANDLER = "handler";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS08UQRBuRhZYHqISERQNKjGQaO+SeOMguI+wZHiEBULcAzYz7W5j73Tb3csOEow/wZ+gdy8m3jwZD549eDH+BWM8eDVWzz6RJZo4h8lsVX31+Kq+ff0NxbRC1/dIGGJVCQwrU7y0sL29urtHPZOm2lNMGqFQ7elykFNAA37Trg26WXAtPFGHJ1KiLEVAgzb0nIv6tTngVJcoNQZdPY7wtE7km+65UFZUI2uzqU5ZX/747rzwn79yEAoldNcNo0z+DdWapNtFDvMNugCV9kmCk6AIbSgWFKHfIWtLcaL1CinTJ+gZ6nVRjyQKkhl0499HjnJE+FAadAmC1MF9IR6nROAzw0SQVVDAoJRQReyVhKJlzFmZ4ArDWcYNVThzAtPBtMVoVcqoUo9BvSUS+Jwqg7L/mXexlqiVemhqKe8pwfkaCWgSRrJMhVhXgTjc5rLh8RaqObjLNDB4/hjK2mzgsIQVXjm2QjgO3DqO1va6CiimKmA2aKxw8p7WwVW7pLE/LskmjLy/Rkc+v/v6Nts4HwdqX+wY2nb9sFaphARmmS09XLudimE8sUzkXAHFNeUgnUgaEx0ay9fd0BzUi2jAFo4XiS5Biljvl/cfRh9+OoOcLOrngvhZYuNzKG5KClgQ3A/lvfmoo8FqH7zP2eYNihlmOFB0Nlpzk2/gXir6iCpF/Tx7CgHjhwGtTqaho0DDhqfvJpO3J2eTyZmjEPia6MBXs+nd+MefI/k38w3OumCG8VPDW7zFHqAeFnAW0Eh0dT11FNmA1LTii5ZuOikJnS4lWT/Vy9H72gmmuoGQ2o4AsSx8ICR5aA8w327keHnT3cituZmd3MpGZn1rwd3JZ9xMaiO3unIEi99nmu1yui6qKVGx/wnOnVmDBj3K+ToNfKqs+OYhcZk0fm/aNQP1aeoJRYAfWzXVBphuyg97dtgZKNTHIShNDIFzOqyrGhepybTradquzo47Fe3Eft1Cf4oOiPkN/8dK9/AFAAA=";
    private static final Log log = LogFactory.getLog(EntryBookConditionView.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?, ?> $previousValues = new HashMap<Object, Object>();
    private boolean allComponentsCreated;
    protected final JAXXContext delegateContext = new DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected EntryBookConditionView entryBookConditionFrame = this;
    protected JList entryBookList;
    protected EntryBookConditionHandler handler;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private JScrollPane $JScrollPane0;

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookConditionView(String param0) {
        super(param0);
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext, String param1) {
        super(param1);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookConditionView() {
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookConditionView(String param0, boolean param1, boolean param2, boolean param3) {
        super(param0 ,param1 ,param2 ,param3);
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4) {
        super(param1 ,param2 ,param3 ,param4);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookConditionView(String param0, boolean param1, boolean param2, boolean param3, boolean param4) {
        super(param0 ,param1 ,param2 ,param3 ,param4);
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3, boolean param4, boolean param5) {
        super(param1 ,param2 ,param3 ,param4 ,param5);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookConditionView(String param0, boolean param1, boolean param2) {
        super(param0 ,param1 ,param2);
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext, String param1, boolean param2, boolean param3) {
        super(param1 ,param2 ,param3);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    public EntryBookConditionView(String param0, boolean param1) {
        super(param0 ,param1);
        $initialize();
    }

    public EntryBookConditionView(JAXXContext parentContext, String param1, boolean param2) {
        super(param1 ,param2);
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding getDataBinding(String bindingId) {
        return $bindings.get(bindingId);
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                getDataBinding($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            getDataBinding($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doInternalFrameClosed__on__entryBookConditionFrame(InternalFrameEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.delete();
    }

    public void doValueChanged__on__entryBookList(ListSelectionEvent event) {
        if (log.isDebugEnabled()) {
            log.debug(event);
        }
        handler.setEntryBook(event);
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public JList getEntryBookList() {
        return entryBookList;
    }

    public EntryBookConditionHandler getHandler() {
        return handler;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setHandler(EntryBookConditionHandler handler) {
        EntryBookConditionHandler oldValue = this.handler;
        this.handler = handler;
        firePropertyChange(PROPERTY_HANDLER, oldValue, handler);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected JScrollPane get$JScrollPane0() {
        return $JScrollPane0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void addChildrenToEntryBookConditionFrame() {
        if (!allComponentsCreated) {
            return;
        }
        add($JScrollPane0);
    }

    protected void createEntryBookList() {
        $objectMap.put("entryBookList", entryBookList = new JList());
        
        entryBookList.setName("entryBookList");
        entryBookList.setVisibleRowCount(-1);
        entryBookList.addListSelectionListener(JAXXUtil.getEventListener(ListSelectionListener.class, "valueChanged", this, "doValueChanged__on__entryBookList"));
    }

    protected void createHandler() {
        $objectMap.put("handler", handler = new EntryBookConditionHandler(this));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        addChildrenToEntryBookConditionFrame();
        // inline complete setup of $JScrollPane0
        $JScrollPane0.getViewport().add(entryBookList);
        
        // apply 4 property setters
        setPreferredSize(new Dimension(400, 100));
        entryBookList.setSelectionMode(ListSelectionModel.MULTIPLE_INTERVAL_SELECTION);
        entryBookList.setCellRenderer(LimaRendererUtil.newDecoratorListCellRenderer(EntryBook.class));
        entryBookList.setListData(handler.getEntryBookList());
    }

    private void $initialize() {
        if (allComponentsCreated) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug(this);
        }
        $objectMap.put("entryBookConditionFrame", entryBookConditionFrame);
        createHandler();
        // inline creation of $JScrollPane0
        $objectMap.put("$JScrollPane0", $JScrollPane0 = new JScrollPane());
        
        $JScrollPane0.setName("$JScrollPane0");
        createEntryBookList();
        // inline creation of entryBookConditionFrame
        setName("entryBookConditionFrame");
        setVisible(true);
        setClosable(true);
        setDefaultCloseOperation(2);
        setTitle(t("lima.entryBook"));
        entryBookConditionFrame.addInternalFrameListener(JAXXUtil.getEventListener(InternalFrameListener.class, "internalFrameClosed", this, "doInternalFrameClosed__on__entryBookConditionFrame"));
        
        entryBookConditionFrame.pack();
        $completeSetup();
    }

}