/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service.neogia;

import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.dto.PeriodDTO;
import org.chorem.lima.dto.StatusDTO;
import org.chorem.lima.service.PeriodService;
import org.chorem.lima.service.neogia.GetAllPeriodStub;
import org.chorem.lima.service.neogia.util.NeogiaUtil;
import org.ofbiz.webservice.proxies.GetAllPeriodResponseDocument;
import org.ofbiz.webservice.wrappers.xsd.GenericValueGlPeriod;

public class NeogiaPeriodService
implements PeriodService {
    protected static final Log log = LogFactory.getLog(NeogiaPeriodService.class);

    public List<PeriodDTO> getAllPeriod(List<StatusDTO> status) {
        HashMap<String, PeriodDTO> map = new HashMap<String, PeriodDTO>();
        LinkedList<PeriodDTO> list = new LinkedList<PeriodDTO>();
        try {
            GenericValueGlPeriod[] array;
            GetAllPeriodStub stub = new GetAllPeriodStub();
            GetAllPeriodResponseDocument response = stub.getAllPeriod();
            for (GenericValueGlPeriod value : array = response.getGetAllPeriodResponse().getReturnArray()) {
                PeriodDTO period = NeogiaUtil.mapToPeriodDTO(status, value);
                map.put(value.getIdNum(), period);
                if (period.getParent() == null) {
                    list.add(period);
                }
                if (!map.containsKey(value.getParentPeriodIdNum())) continue;
                PeriodDTO parent = (PeriodDTO)map.get(value.getParentPeriodIdNum());
                parent.addChild(period);
            }
            return list;
        }
        catch (RemoteException ex) {
            log.error((Object)ex);
            return null;
        }
    }

    public String blockPeriod(PeriodDTO periodDTO, List<StatusDTO> status) {
        return "success";
    }

    public String blockPeriodMonthly(PeriodDTO periodDTO, List<StatusDTO> status) {
        return "success";
    }

    public String createPeriod(PeriodDTO periodDTO, List<StatusDTO> status) {
        return "success";
    }

    public String unBlockPeriodMonthly(PeriodDTO periodDTO, List<StatusDTO> status) {
        return "success";
    }
}

