/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.server;

import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openejb.client.RemoteInitialContextFactory;
import org.chorem.lima.business.LimaBusinessConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.report.LimaReportConfig;
import org.chorem.lima.server.HttpServerService;
import org.chorem.lima.server.LimaServerConfig;
import org.nuiton.config.ApplicationConfig;

public class LimaServer {
    private static final Log log = LogFactory.getLog(LimaServer.class);
    public static final String EJB_URL = "ejbd://%s:%d";
    public static final String LIMA_HOST_ADDRESS = "lima.host.address";
    protected static HttpServerService httpServerService;
    private static final Object LOCK;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws NamingException {
        String accountabilityName = null;
        if (args != null && args.length > 0 && StringUtils.isNotBlank((CharSequence)args[0])) {
            accountabilityName = args[0];
        }
        LimaServerConfig serverConfig = LimaServerConfig.getInstance(accountabilityName);
        LimaServer.launch(serverConfig.getConfig());
        LimaServerConfig.getInstance().getConfig().saveForUser(new String[0]);
        Object object = LOCK;
        synchronized (object) {
            try {
                LOCK.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"LimaServer shutdown");
        }
    }

    public static void launch(ApplicationConfig moduleConfig) {
        boolean isRemoteMode = moduleConfig.getOptionAsBoolean(LimaServerConfig.ServerConfigOption.EJB_REMOTABLE.getKey());
        boolean mustStartServer = StringUtils.isBlank((CharSequence)moduleConfig.getOption(LIMA_HOST_ADDRESS)) || isRemoteMode;
        ApplicationConfig initConfig = moduleConfig;
        LimaBusinessConfig config = LimaBusinessConfig.getInstance((ApplicationConfig)initConfig);
        initConfig = config.getConfig();
        if (mustStartServer) {
            initConfig = LimaServerConfig.getInstance(initConfig).getConfig();
            initConfig = LimaBusinessConfig.getInstance((ApplicationConfig)initConfig).getConfig();
            initConfig = LimaReportConfig.getInstance((ApplicationConfig)initConfig).getConfig();
            LimaServer.setServeurEjbParams(initConfig);
        } else {
            LimaServer.setClientEjbParams(initConfig);
        }
        String url = String.format(EJB_URL, config.getHostEJBAddress(), config.getHostEjbPort());
        initConfig.setOption("java.naming.provider.url", url);
        LimaServiceFactory.initFactory((ApplicationConfig)initConfig);
        if (mustStartServer) {
            LimaServer.setHttpServerParams(isRemoteMode, initConfig);
            httpServerService = new HttpServerService();
            httpServerService.start();
        }
    }

    protected static void setClientEjbParams(ApplicationConfig initConfig) {
        initConfig.setOption(LimaBusinessConfig.BusinessConfigOption.HOST_EJB_ADDRESS.getKey(), initConfig.getOption(LIMA_HOST_ADDRESS));
        initConfig.setOption("java.naming.factory.initial", RemoteInitialContextFactory.class.getName());
    }

    protected static void setServeurEjbParams(ApplicationConfig initConfig) {
        initConfig.setOption(LimaServerConfig.ServerConfigOption.EJB_BIND.getKey(), initConfig.getOption(LimaBusinessConfig.BusinessConfigOption.HOST_EJB_BIND.getKey()));
        initConfig.setOption(LimaServerConfig.ServerConfigOption.EJB_PORT.getKey(), initConfig.getOption(LimaBusinessConfig.BusinessConfigOption.HOST_EJB_PORT.getKey()));
    }

    protected static void setHttpServerParams(boolean isRemoteMode, ApplicationConfig initConfig) {
        boolean isDefaultHttpAddressUsed = LimaBusinessConfig.getInstance().getHostHttpAddress().contentEquals(LimaBusinessConfig.BusinessConfigOption.HOST_HTTP_ADDRESS.getDefaultValue());
        if (isRemoteMode && isDefaultHttpAddressUsed) {
            String httpAddress = initConfig.getOption(LimaBusinessConfig.BusinessConfigOption.HOST_EJB_ADDRESS.getKey());
            LimaBusinessConfig.getInstance().setHostHttpAddress(httpAddress);
        }
    }

    public static HttpServerService getHttpServerService() {
        return httpServerService;
    }

    static {
        LOCK = new Object();
    }
}

