/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.server;

public enum FormatsEnum {
    HTML(".html", "text/html", "Page Html"),
    PDF(".pdf", "application/pdf", "Document PDF"),
    PNG(".png", "image/png", "Image PNG");

    private final String extension;
    private final String mimeType;
    private final String description;

    private FormatsEnum(String extension, String mimeType, String description) {
        this.extension = extension;
        this.mimeType = mimeType;
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public static FormatsEnum valueOfExtension(String extension) {
        FormatsEnum value = null;
        for (FormatsEnum formatsEnum : FormatsEnum.values()) {
            if (!extension.equals(formatsEnum.getExtension())) continue;
            value = formatsEnum;
            break;
        }
        return value;
    }
}

