/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.server;

import java.util.Properties;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaBusinessConfig;
import org.chorem.lima.business.LimaServiceFactory;
import org.chorem.lima.report.LimaReportConfig;
import org.chorem.lima.server.HttpServerService;
import org.chorem.lima.server.LimaServerConfig;
import org.nuiton.config.ApplicationConfig;

public class LimaServer {
    private static final Log log = LogFactory.getLog(LimaServer.class);
    protected static HttpServerService httpServerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws NamingException {
        String accountabilityName = null;
        if (args != null && args.length > 0 && StringUtils.isNotBlank((CharSequence)args[0])) {
            accountabilityName = args[0];
        }
        LimaServerConfig serverConfig = LimaServerConfig.getInstance(accountabilityName);
        Properties properties = serverConfig.getFlatOptions();
        properties.put("openejb.embedded.remotable", "true");
        LimaServer.launch(serverConfig.getConfig());
        LimaServerConfig.getInstance().getConfig().saveForUser(new String[0]);
        Properties properties2 = properties;
        synchronized (properties2) {
            try {
                properties.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"LimaServer shutdown");
        }
    }

    public static void launch(ApplicationConfig moduleConfig) {
        boolean mustStartServer = StringUtils.isBlank((CharSequence)moduleConfig.getOption("java.naming.provider.url")) || moduleConfig.getOptionAsBoolean("openejb.embedded.remotable");
        ApplicationConfig initConfig = moduleConfig;
        if (mustStartServer) {
            initConfig = LimaServerConfig.getInstance(initConfig).getConfig();
            initConfig = LimaBusinessConfig.getInstance((ApplicationConfig)initConfig).getConfig();
            initConfig = LimaReportConfig.getInstance((ApplicationConfig)initConfig).getConfig();
        }
        LimaServiceFactory.initFactory((ApplicationConfig)initConfig);
        if (mustStartServer) {
            httpServerService = new HttpServerService();
            httpServerService.start();
        }
    }

    public static HttpServerService getHttpServerService() {
        return httpServerService;
    }
}

