/**
 * *##% Callao LogDTO
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.dto;

import java.util.Date;

/**
 * Classe DTO - représente un objet log
 *
 * @author Rémi Chapelet
 */
public class LogDTO  {

    private String id; // Identifiant Topia

    private Date logDate;

    private String type;

    private Date transDate;

    private String voucherRef;

    private String transDesc;

    private String entryDesc;

    private String amount;

    private boolean debit;

    private String lettering;



    public LogDTO ()
    {
        this.id = "";
        this.logDate = new Date();
        this.type = "";
        this.transDate = new Date();
        this.voucherRef = "";
        this.transDesc = "";
        this.entryDesc = "";
        this.amount = "";
        this.debit = false;
        this.lettering = "";
    }

    public LogDTO (String id, Date logDate,String type,Date transDate, 
            String voucherRef, String transDesc, String entryDesc,String amount,
            boolean debit, String lettering)
    {
        this.id = id;
        this.logDate = logDate;
        this.type = type;
        this.transDate = transDate;
        this.voucherRef = voucherRef;
        this.transDesc = transDesc;
        this.entryDesc = entryDesc;
        this.amount = amount;
        this.debit = debit;
        this.lettering = lettering;
    }

    /**
     * @return the id
     */
    public String getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    public void setId(String id) {
        this.id = id;
    }

    /**
     * @return the logDate
     */
    public Date getLogDate() {
        return logDate;
    }

    /**
     * @param logDate the logDate to set
     */
    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    /**
     * @return the type
     */
    public String getType() {
        return type;
    }

    /**
     * @param type the type to set
     */
    public void setType(String type) {
        this.type = type;
    }

    /**
     * @return the transDate
     */
    public Date getTransDate() {
        return transDate;
    }

    /**
     * @param transDate the transDate to set
     */
    public void setTransDate(Date transDate) {
        this.transDate = transDate;
    }

    /**
     * @return the voucherRef
     */
    public String getVoucherRef() {
        return voucherRef;
    }

    /**
     * @param voucherRef the voucherRef to set
     */
    public void setVoucherRef(String voucherRef) {
        this.voucherRef = voucherRef;
    }

    /**
     * @return the transDesc
     */
    public String getTransDesc() {
        return transDesc;
    }

    /**
     * @param transDesc the transDesc to set
     */
    public void setTransDesc(String transDesc) {
        this.transDesc = transDesc;
    }

    /**
     * @return the entryDesc
     */
    public String getEntryDesc() {
        return entryDesc;
    }

    /**
     * @param entryDesc the entryDesc to set
     */
    public void setEntryDesc(String entryDesc) {
        this.entryDesc = entryDesc;
    }

    /**
     * @return the amount
     */
    public String getAmount() {
        return amount;
    }

    /**
     * @param amount the amount to set
     */
    public void setAmount(String amount) {
        this.amount = amount;
    }

    /**
     * @return the debit
     */
    public boolean isDebit() {
        return debit;
    }

    /**
     * @param debit the debit to set
     */
    public void setDebit(boolean debit) {
        this.debit = debit;
    }

    /**
     * @return the lettering
     */
    public String getLettering() {
        return lettering;
    }

    /**
     * @param lettering the lettering to set
     */
    public void setLettering(String lettering) {
        this.lettering = lettering;
    }
   
}