/**
 * *##% Callao ConvertAccount
 * Copyright (C) 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.callao.service.convertObject;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.callao.entity.Account;
import org.chorem.callao.entity.AccountDAO;
import org.chorem.callao.entity.CallaoDAOHelper;
import org.chorem.callao.service.dto.AccountDTO;
import org.nuiton.topia.TopiaException;

/**
 * Transforme les objets Account : DTO, DAO et entity
 *
 * @author Rémi Chapelet
 */
public class ConvertAccount  extends ConvertTopiaContext {

    private static final Log log = LogFactory.getLog(ConvertAccount.class);
    
    public void accountDtoToDao()
    {
        
    }

    public void accountDaoToDto()
    {

    }

    /**
     * Transforme une entité Account en DTO.
     * Les enfants sont également transformés.
     * @param account
     * @param accountChild
     * @return
     */
    public AccountDTO accountEntityToDto(Account account,List<Account> accountChild)
    {
        AccountDTO accountDTO = new AccountDTO();
        accountDTO.setId(account.getTopiaId());
        accountDTO.setAccountNumber(account.getAccountNumber());
        accountDTO.setLabel(account.getLabel());
        accountDTO.setType(account.getType());
        accountDTO.setAccountChildDTO(null);
        /**
         * Ajout des comptes enfants
         */        
        try {
            // Chargement du DAO
            AccountDAO accountDAO = CallaoDAOHelper.getAccountDAO(getTransaction());
            // recherche des enfants
            accountChild = accountDAO.findAllByMasterAccount(account);
            // Création de la liste des enfants DTO
            List<AccountDTO> newListDTO = new ArrayList<AccountDTO>();
            for (Account newAccount : accountChild)
            {
                // On recherche les enfants de l'enfant
                List<Account> ListAccount = accountDAO.findAllByMasterAccount(newAccount);
                // Création de l'enfant en DTO
                AccountDTO newAccountDTO = accountEntityToDto(newAccount,ListAccount);
                // Ajout de l'enfant à la liste
                newListDTO.add(newAccountDTO);
            }
            // Ajout de la liste des enfants au père DTO
            accountDTO.setAccountChildDTO(newListDTO);
            // Recherche du pere
            Account masterAccount = accountDAO.findContainsSubAccount(account);
            // Ajout du numéro de compte père au DTO
            if (masterAccount != null)
            {
                accountDTO.setMasterAccount(masterAccount.getAccountNumber());
            }
        }catch (TopiaException e) {
            log.error(e);
        }        
        return accountDTO;
    }

}