/* *##%
 Copyright (C) 2009 Callao
 *##%*/
package org.chorem.callao.entity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;

/**
 * Implantation POJO pour l'entité {@link Log}.
 */
public abstract class LogAbstract extends TopiaEntityAbstract implements Log {

    private Date logDate;

    private String type;

    private Date transDate;

    private String voucherRef;

    private String transDesc;

    private String entryDesc;

    private String amount;

    private boolean debit;

    private String lettering;

    public Entry entry;

    /**
     * Constructeur de LogAbstract par défaut.
     */
    public LogAbstract() {
    }

    @Override
    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Log.class).update(this);
    }

    @Override
    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Log.class).delete(this);
    }

    /**
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
     * avec leur nom, type et valeur.
     *
     * @param visitor le visiteur de l'entite.
     *
     * @throws TopiaException if any pb while visit 
     */
    @Override
    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, "logDate", Date.class, logDate);
        visitor.visit(this, "type", String.class, type);
        visitor.visit(this, "transDate", Date.class, transDate);
        visitor.visit(this, "voucherRef", String.class, voucherRef);
        visitor.visit(this, "transDesc", String.class, transDesc);
        visitor.visit(this, "entryDesc", String.class, entryDesc);
        visitor.visit(this, "amount", String.class, amount);
        visitor.visit(this, "debit", boolean.class, debit);
        visitor.visit(this, "lettering", String.class, lettering);
        visitor.visit(this, "entry", Entry.class, entry);
        visitor.end(this);
    }

    @Override
    public List<TopiaEntity> getAggregate() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
    }

    @Override
    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur 
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) { 
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }
        
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setLogDate(Date)
     */
    @Override
    public void setLogDate(Date value) {
        Date _oldValue = this.logDate;
        fireOnPreWrite("logDate", _oldValue, value);
        this.logDate = value;
        fireOnPostWrite("logDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getLogDate()
     */
    @Override
    public Date getLogDate() {
        fireOnPreRead("logDate", logDate);
        Date result = this.logDate;
        fireOnPostRead("logDate", logDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setType(String)
     */
    @Override
    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite("type", _oldValue, value);
        this.type = value;
        fireOnPostWrite("type", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getType()
     */
    @Override
    public String getType() {
        fireOnPreRead("type", type);
        String result = this.type;
        fireOnPostRead("type", type);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setTransDate(Date)
     */
    @Override
    public void setTransDate(Date value) {
        Date _oldValue = this.transDate;
        fireOnPreWrite("transDate", _oldValue, value);
        this.transDate = value;
        fireOnPostWrite("transDate", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getTransDate()
     */
    @Override
    public Date getTransDate() {
        fireOnPreRead("transDate", transDate);
        Date result = this.transDate;
        fireOnPostRead("transDate", transDate);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setVoucherRef(String)
     */
    @Override
    public void setVoucherRef(String value) {
        String _oldValue = this.voucherRef;
        fireOnPreWrite("voucherRef", _oldValue, value);
        this.voucherRef = value;
        fireOnPostWrite("voucherRef", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getVoucherRef()
     */
    @Override
    public String getVoucherRef() {
        fireOnPreRead("voucherRef", voucherRef);
        String result = this.voucherRef;
        fireOnPostRead("voucherRef", voucherRef);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setTransDesc(String)
     */
    @Override
    public void setTransDesc(String value) {
        String _oldValue = this.transDesc;
        fireOnPreWrite("transDesc", _oldValue, value);
        this.transDesc = value;
        fireOnPostWrite("transDesc", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getTransDesc()
     */
    @Override
    public String getTransDesc() {
        fireOnPreRead("transDesc", transDesc);
        String result = this.transDesc;
        fireOnPostRead("transDesc", transDesc);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setEntryDesc(String)
     */
    @Override
    public void setEntryDesc(String value) {
        String _oldValue = this.entryDesc;
        fireOnPreWrite("entryDesc", _oldValue, value);
        this.entryDesc = value;
        fireOnPostWrite("entryDesc", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getEntryDesc()
     */
    @Override
    public String getEntryDesc() {
        fireOnPreRead("entryDesc", entryDesc);
        String result = this.entryDesc;
        fireOnPostRead("entryDesc", entryDesc);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setAmount(String)
     */
    @Override
    public void setAmount(String value) {
        String _oldValue = this.amount;
        fireOnPreWrite("amount", _oldValue, value);
        this.amount = value;
        fireOnPostWrite("amount", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getAmount()
     */
    @Override
    public String getAmount() {
        fireOnPreRead("amount", amount);
        String result = this.amount;
        fireOnPostRead("amount", amount);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setDebit(boolean)
     */
    @Override
    public void setDebit(boolean value) {
        boolean _oldValue = this.debit;
        fireOnPreWrite("debit", _oldValue, value);
        this.debit = value;
        fireOnPostWrite("debit", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getDebit()
     */
    @Override
    public boolean getDebit() {
        fireOnPreRead("debit", debit);
        boolean result = this.debit;
        fireOnPostRead("debit", debit);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setLettering(String)
     */
    @Override
    public void setLettering(String value) {
        String _oldValue = this.lettering;
        fireOnPreWrite("lettering", _oldValue, value);
        this.lettering = value;
        fireOnPostWrite("lettering", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getLettering()
     */
    @Override
    public String getLettering() {
        fireOnPreRead("lettering", lettering);
        String result = this.lettering;
        fireOnPostRead("lettering", lettering);
        return result;
    }

    /* (non-Javadoc)
     * @see Log#setEntry(Entry)
     */
    @Override
    public void setEntry(Entry value) {
        Entry _oldValue = this.entry;
        fireOnPreWrite("entry", _oldValue, value);
        this.entry = value;
        fireOnPostWrite("entry", _oldValue, value);
    }

    /* (non-Javadoc)
     * @see Log#getEntry()
     */
    @Override
    public Entry getEntry() {
        fireOnPreRead("entry", entry);
        Entry result = this.entry;
        fireOnPostRead("entry", entry);
        return result;
    }

    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append("logDate", this.logDate).
            append("type", this.type).
            append("transDate", this.transDate).
            append("voucherRef", this.voucherRef).
            append("transDesc", this.transDesc).
            append("entryDesc", this.entryDesc).
            append("amount", this.amount).
            append("debit", this.debit).
            append("lettering", this.lettering).
         toString();
        return result;
    }
        
} //LogAbstract
