/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.macs;

import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Mac;

public class TruncatingMac
implements Mac {
    private final Mac mac;
    private final int macSizeInBits;

    public TruncatingMac(Mac mac, int n) {
        this.mac = mac;
        this.macSizeInBits = n;
    }

    @Override
    public void init(CipherParameters cipherParameters) throws IllegalArgumentException {
        this.mac.init(cipherParameters);
    }

    @Override
    public String getAlgorithmName() {
        return this.mac.getAlgorithmName();
    }

    @Override
    public int getMacSize() {
        return this.macSizeInBits / 8;
    }

    @Override
    public void update(byte by) throws IllegalStateException {
        this.mac.update(by);
    }

    @Override
    public void update(byte[] byArray, int n, int n2) throws DataLengthException, IllegalStateException {
        this.mac.update(byArray, n, n2);
    }

    @Override
    public int doFinal(byte[] byArray, int n) throws DataLengthException, IllegalStateException {
        byte[] byArray2 = new byte[this.mac.getMacSize()];
        this.mac.doFinal(byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n, this.macSizeInBits / 8);
        return this.macSizeInBits / 8;
    }

    @Override
    public void reset() {
    }
}

