/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.blur.impl;

import boofcv.alg.filter.misc.ImageLambdaFilters;
import boofcv.alg.filter.misc.ImageLambdaFilters_MT;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayF64;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayI8;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class GeometricMeanFilter_MT {
    public static <T extends ImageGray<T>> void filter(T src, int radiusX, int radiusY, double mean, T dst) {
        switch (src.getDataType()) {
            case U8: {
                GeometricMeanFilter_MT.filter((GrayU8)src, radiusX, radiusY, mean, (GrayU8)dst);
                break;
            }
            case U16: {
                GeometricMeanFilter_MT.filter((GrayU16)src, radiusX, radiusY, mean, (GrayU16)dst);
                break;
            }
            case F32: {
                GeometricMeanFilter_MT.filter((GrayF32)src, radiusX, radiusY, (float)mean, (GrayF32)dst);
                break;
            }
            case F64: {
                GeometricMeanFilter_MT.filter((GrayF64)src, radiusX, radiusY, mean, (GrayF64)dst);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + src.getDataType());
            }
        }
    }

    public static void filter(GrayU8 src, int radiusX, int radiusY, double mean, GrayU8 dst) {
        dst.reshape(src.width, src.height);
        int kx = radiusX * 2 + 1;
        int ky = radiusY * 2 + 1;
        double power = 1.0 / (double)(kx * ky);
        ImageLambdaFilters_MT.filterRectCenterInner((GrayI8)src, radiusX, radiusY, (GrayI8)dst, null, (indexCenter, w) -> {
            int indexRow = indexCenter - radiusX - src.stride * radiusY;
            double product = 1.0;
            for (int y = 0; y < ky; ++y) {
                int indexPixel = indexRow + src.stride * y;
                for (int x = 0; x < kx; ++x) {
                    product *= (double)(src.data[indexPixel++] & 0xFF) / mean;
                }
            }
            return (int)(mean * Math.pow(product, power) + 0.5);
        });
        ImageLambdaFilters.filterRectCenterEdge((GrayI8)src, radiusX, radiusY, (GrayI8)dst, null, (cx, cy, x0, y0, x1, y1, w) -> {
            double product = 1.0;
            for (int y = y0; y < y1; ++y) {
                int indexPixel = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    product *= (double)(src.data[indexPixel++] & 0xFF) / mean;
                }
            }
            return (int)(mean * Math.pow(product, 1.0 / (double)((x1 - x0) * (y1 - y0))) + 0.5);
        });
    }

    public static void filter(GrayU16 src, int radiusX, int radiusY, double mean, GrayU16 dst) {
        dst.reshape(src.width, src.height);
        int kx = radiusX * 2 + 1;
        int ky = radiusY * 2 + 1;
        double power = 1.0 / (double)(kx * ky);
        ImageLambdaFilters_MT.filterRectCenterInner((GrayI16)src, radiusX, radiusY, (GrayI16)dst, null, (indexCenter, w) -> {
            int indexRow = indexCenter - radiusX - src.stride * radiusY;
            double product = 1.0;
            for (int y = 0; y < ky; ++y) {
                int indexPixel = indexRow + src.stride * y;
                for (int x = 0; x < kx; ++x) {
                    product *= (double)(src.data[indexPixel++] & 0xFFFF) / mean;
                }
            }
            return (int)(mean * Math.pow(product, power) + 0.5);
        });
        ImageLambdaFilters.filterRectCenterEdge((GrayI16)src, radiusX, radiusY, (GrayI16)dst, null, (cx, cy, x0, y0, x1, y1, w) -> {
            double product = 1.0;
            for (int y = y0; y < y1; ++y) {
                int indexPixel = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    product *= (double)(src.data[indexPixel++] & 0xFFFF) / mean;
                }
            }
            return (int)(mean * Math.pow(product, 1.0 / (double)((x1 - x0) * (y1 - y0))) + 0.5);
        });
    }

    public static void filter(GrayF32 src, int radiusX, int radiusY, float mean, GrayF32 dst) {
        dst.reshape(src.width, src.height);
        int kx = radiusX * 2 + 1;
        int ky = radiusY * 2 + 1;
        float power = 1.0f / (float)(kx * ky);
        ImageLambdaFilters_MT.filterRectCenterInner(src, radiusX, radiusY, dst, null, (indexCenter, w) -> {
            int indexRow = indexCenter - radiusX - src.stride * radiusY;
            float product = 1.0f;
            for (int y = 0; y < ky; ++y) {
                int indexPixel = indexRow + src.stride * y;
                for (int x = 0; x < kx; ++x) {
                    product *= src.data[indexPixel++] / mean;
                }
            }
            return (float)((double)mean * Math.pow(product, power));
        });
        ImageLambdaFilters.filterRectCenterEdge(src, radiusX, radiusY, dst, null, (cx, cy, x0, y0, x1, y1, w) -> {
            float product = 1.0f;
            for (int y = y0; y < y1; ++y) {
                int indexPixel = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    product *= src.data[indexPixel++] / mean;
                }
            }
            return (float)((double)mean * Math.pow(product, 1.0f / (float)((x1 - x0) * (y1 - y0))));
        });
    }

    public static void filter(GrayF64 src, int radiusX, int radiusY, double mean, GrayF64 dst) {
        dst.reshape(src.width, src.height);
        int kx = radiusX * 2 + 1;
        int ky = radiusY * 2 + 1;
        double power = 1.0 / (double)(kx * ky);
        ImageLambdaFilters_MT.filterRectCenterInner(src, radiusX, radiusY, dst, null, (indexCenter, w) -> {
            int indexRow = indexCenter - radiusX - src.stride * radiusY;
            double product = 1.0;
            for (int y = 0; y < ky; ++y) {
                int indexPixel = indexRow + src.stride * y;
                for (int x = 0; x < kx; ++x) {
                    product *= src.data[indexPixel++] / mean;
                }
            }
            return mean * Math.pow(product, power);
        });
        ImageLambdaFilters.filterRectCenterEdge(src, radiusX, radiusY, dst, null, (cx, cy, x0, y0, x1, y1, w) -> {
            double product = 1.0;
            for (int y = y0; y < y1; ++y) {
                int indexPixel = src.startIndex + y * src.stride + x0;
                for (int x = x0; x < x1; ++x) {
                    product *= src.data[indexPixel++] / mean;
                }
            }
            return mean * Math.pow(product, 1.0 / (double)((x1 - x0) * (y1 - y0)));
        });
    }
}

