/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.biojava.nbio.genome.parsers.gff.Feature;
import org.biojava.nbio.genome.parsers.gff.FeatureI;
import org.biojava.nbio.genome.parsers.gff.FeatureList;
import org.biojava.nbio.genome.parsers.gff.Location;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneMarkGTFReader {
    private static final Logger logger = LoggerFactory.getLogger(GeneMarkGTFReader.class);

    public static FeatureList read(String filename) throws IOException {
        logger.info("Reading: {}", (Object)filename);
        FeatureList features = new FeatureList();
        BufferedReader br = new BufferedReader(new FileReader(filename));
        String s = br.readLine();
        while (null != s) {
            Feature f;
            if ((s = s.trim()).length() > 0 && s.charAt(0) != '#' && (f = GeneMarkGTFReader.parseLine(s)) != null) {
                features.add(f);
            }
            s = br.readLine();
        }
        br.close();
        return features;
    }

    private static Feature parseLine(String s) {
        int frame;
        Double score;
        int end;
        int start = 0;
        start = end = 0;
        end = s.indexOf(9, start);
        String seqname = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String source = s.substring(start, end).trim();
        start = end + 1;
        end = s.indexOf(9, start);
        String type = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locStart = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        String locEnd = s.substring(start, end);
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            score = Double.parseDouble(s.substring(start, end));
        }
        catch (Exception e) {
            score = 0.0;
        }
        start = end + 1;
        end = s.indexOf(9, start);
        char strand = s.charAt(end - 1);
        Location location = Location.fromBio(Integer.parseInt(locStart), Integer.parseInt(locEnd), strand);
        assert (strand == '-' == location.isNegative());
        start = end + 1;
        end = s.indexOf(9, start);
        try {
            frame = Integer.parseInt(s.substring(start, end));
        }
        catch (Exception e) {
            frame = -1;
        }
        start = end + 1;
        end = s.indexOf(35, start);
        String attributes = null;
        attributes = end < 0 ? new String(s.substring(start)) : new String(s.substring(start, end));
        return new Feature(seqname, source, type, location, score, frame, attributes);
    }

    public static void main(String[] args) throws Exception {
        FeatureList listGenes = GeneMarkGTFReader.read("/Users/Scooter/scripps/dyadic/analysis/454Scaffolds/genemark_hmm.gtf");
        for (FeatureI feature : listGenes) {
            logger.info("Gene Feature: {}", (Object)feature);
        }
    }
}

