/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.parsers.gff;

import java.util.Collection;
import org.biojava.nbio.core.sequence.DNASequence;

public class GCStats {
    public static double getGCStats(Collection<DNASequence> sequences) {
        double gcCount = 0.0;
        double total = 0.0;
        for (DNASequence sequence : sequences) {
            char[] dna;
            for (char d : dna = sequence.toString().toCharArray()) {
                if (d == 'G' || d == 'C' || d == 'g' || d == 'c') {
                    gcCount += 1.0;
                }
                total += 1.0;
            }
        }
        return gcCount / total * 100.0;
    }

    public static double getGCStatsString(Collection<String> sequences) {
        double gcCount = 0.0;
        double total = 0.0;
        for (String sequence : sequences) {
            char[] dna;
            for (char d : dna = sequence.toCharArray()) {
                if (d == 'G' || d == 'C' || d == 'g' || d == 'c') {
                    gcCount += 1.0;
                }
                total += 1.0;
            }
        }
        return gcCount / total * 100.0;
    }
}

