/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.nbio.genome.io.fastq;

import java.io.IOException;
import org.biojava.nbio.genome.io.fastq.FastqBuilder;
import org.biojava.nbio.genome.io.fastq.FastqParser;
import org.biojava.nbio.genome.io.fastq.FastqVariant;
import org.biojava.nbio.genome.io.fastq.ParseListener;
import org.biojava.nbio.genome.io.fastq.StreamListener;

final class StreamingFastqParser {
    StreamingFastqParser() {
    }

    static void stream(Readable readable, final FastqVariant variant, final StreamListener listener) throws IOException {
        if (readable == null) {
            throw new IllegalArgumentException("readable must not be null");
        }
        if (variant == null) {
            throw new IllegalArgumentException("variant must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        final FastqBuilder builder = new FastqBuilder().withVariant(variant);
        FastqParser.parse(readable, new ParseListener(){

            @Override
            public void description(String description) throws IOException {
                builder.withDescription(description);
            }

            @Override
            public void sequence(String sequence) throws IOException {
                builder.withSequence(sequence);
            }

            @Override
            public void appendSequence(String sequence) throws IOException {
                builder.appendSequence(sequence);
            }

            @Override
            public void repeatDescription(String repeatDescription) throws IOException {
                String description = builder.getDescription();
                if (description != null && description.length() > 0 && repeatDescription.length() > 0 && !description.equals(repeatDescription)) {
                    throw new IOException("repeat description must match description");
                }
            }

            private void validateQuality(String quality) throws IOException {
                int size = quality.length();
                for (int i = 0; i < size; ++i) {
                    char c = quality.charAt(i);
                    int qualityScore = variant.qualityScore(c);
                    if (qualityScore >= variant.minimumQualityScore() && qualityScore <= variant.maximumQualityScore()) continue;
                    throw new IOException("quality score must be between " + variant.minimumQualityScore() + " and " + variant.maximumQualityScore() + ", was " + qualityScore + " for ASCII char '" + c + "'");
                }
            }

            @Override
            public void quality(String quality) throws IOException {
                this.validateQuality(quality);
                builder.withQuality(quality);
            }

            @Override
            public void appendQuality(String quality) throws IOException {
                this.validateQuality(quality);
                builder.appendQuality(quality);
            }

            @Override
            public void complete() throws IOException {
                try {
                    listener.fastq(builder.build());
                }
                catch (IllegalStateException e) {
                    throw new IOException("caught an IllegalStateException", e);
                }
            }
        });
    }
}

