/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.apache.wink.common.DynamicResource;
import org.apache.wink.common.annotations.Parent;
import org.apache.wink.common.annotations.Workspace;
import org.apache.wink.common.internal.i18n.Messages;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.AbstractMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.apache.wink.common.internal.registry.metadata.MethodMetadata;
import org.apache.wink.common.internal.utils.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMetadataCollector
extends AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ResourceMetadataCollector.class);

    private ResourceMetadataCollector(Class<?> clazz) {
        super(clazz);
    }

    public static boolean isResource(Class<?> cls) {
        return ResourceMetadataCollector.isStaticResource(cls) || ResourceMetadataCollector.isDynamicResource(cls);
    }

    public static boolean isStaticResource(Class<?> cls) {
        if (Modifier.isInterface(cls.getModifiers()) || Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        if (cls.getAnnotation(Path.class) != null) {
            return true;
        }
        Class<?> declaringClass = cls;
        while (!declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass.getAnnotation(Path.class) != null) {
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("rootResourceShouldBeAnnotatedDirectly", cls));
                }
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                if (interfaceClass.getAnnotation(Path.class) == null) continue;
                if (logger.isWarnEnabled()) {
                    logger.warn(Messages.getMessage("rootResourceShouldBeAnnotatedDirectly", cls));
                }
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        return false;
    }

    public static boolean isDynamicResource(Class<?> cls) {
        return DynamicResource.class.isAssignableFrom(cls);
    }

    public static ClassMetadata collectMetadata(Class<?> clazz) {
        ResourceMetadataCollector collector = new ResourceMetadataCollector(clazz);
        collector.parseClass();
        collector.parseFields();
        collector.parseConstructors();
        collector.parseMethods();
        return collector.getMetadata();
    }

    @Override
    protected final Injectable parseAccessibleObject(AccessibleObject field, Type fieldType) {
        Injectable injectable = InjectableFactory.getInstance().create(fieldType, field.getAnnotations(), (Member)((Object)field), this.getMetadata().isEncoded(), null);
        if (injectable.getParamType() == Injectable.ParamType.ENTITY) {
            return null;
        }
        return injectable;
    }

    private void parseClass() {
        Class<?> cls = this.getMetadata().getResourceClass();
        this.parseClass(cls);
    }

    private boolean parseClass(Class<?> cls) {
        boolean workspacePresent = this.parseWorkspace(cls);
        boolean pathPresent = this.parsePath(cls);
        boolean consumesPresent = this.parseClassConsumes(cls);
        boolean producesPresent = this.parseClassProduces(cls);
        Parent parent = cls.getAnnotation(Parent.class);
        if (parent != null) {
            this.getMetadata().getParents().add(parent.value());
        }
        this.parseEncoded(cls);
        return workspacePresent || pathPresent || consumesPresent || producesPresent;
    }

    private boolean parseWorkspace(Class<?> cls) {
        Workspace workspace = cls.getAnnotation(Workspace.class);
        if (workspace != null) {
            this.getMetadata().setWorkspaceName(workspace.workspaceTitle());
            this.getMetadata().setCollectionTitle(workspace.collectionTitle());
            return true;
        }
        return false;
    }

    private boolean parsePath(Class<?> cls) {
        Path path = cls.getAnnotation(Path.class);
        if (path != null) {
            this.getMetadata().addPath(path.value());
            return true;
        }
        Class<?> declaringClass = cls;
        while (!declaringClass.equals(Object.class)) {
            Class<?>[] interfaces;
            Class<?> superclass = declaringClass.getSuperclass();
            path = superclass.getAnnotation(Path.class);
            if (path != null) {
                this.getMetadata().addPath(path.value());
                return true;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                path = interfaceClass.getAnnotation(Path.class);
                if (path == null) continue;
                this.getMetadata().addPath(path.value());
                return true;
            }
            declaringClass = declaringClass.getSuperclass();
        }
        return false;
    }

    private void parseMethods() {
        block0: for (Method method : this.getMetadata().getResourceClass().getMethods()) {
            MethodMetadata methodMetadata;
            Class<?> declaringClass = method.getDeclaringClass();
            if (method.getDeclaringClass() == Object.class || (methodMetadata = this.createMethodMetadata(method)) == null) continue;
            String path = methodMetadata.getPath();
            String httpMethod = methodMetadata.getHttpMethod();
            if (path != null) {
                if (httpMethod != null) {
                    this.getMetadata().getSubResourceMethods().add(methodMetadata);
                    continue;
                }
                String methodName = String.format("%s.%s", declaringClass.getName(), method.getName());
                for (Injectable id : methodMetadata.getFormalParameters()) {
                    if (id.getParamType() != Injectable.ParamType.ENTITY) continue;
                    if (!logger.isWarnEnabled()) continue block0;
                    logger.warn(Messages.getMessage("subresourceLocatorIllegalEntityParameter", methodName));
                    continue block0;
                }
                if (!(methodMetadata.getConsumes().isEmpty() && methodMetadata.getProduces().isEmpty() || !logger.isWarnEnabled())) {
                    logger.warn(Messages.getMessage("subresourceLocatorAnnotatedConsumesProduces", methodName));
                }
                this.getMetadata().getSubResourceLocators().add(methodMetadata);
                continue;
            }
            this.getMetadata().getResourceMethods().add(methodMetadata);
        }
    }

    private MethodMetadata createMethodMetadata(Method method) {
        String[] produces;
        String[] consumes;
        Path path;
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) {
            return null;
        }
        MethodMetadata metadata = new MethodMetadata(this.getMetadata());
        metadata.setReflectionMethod(method);
        boolean hasAnnotation = false;
        HttpMethod httpMethod = this.getHttpMethod(method);
        if (httpMethod != null) {
            hasAnnotation = true;
            metadata.setHttpMethod(httpMethod.value());
        }
        if ((path = this.getPath(method)) != null) {
            hasAnnotation = true;
            metadata.addPath(path.value());
        }
        for (String mediaType : consumes = this.getConsumes(method)) {
            hasAnnotation = true;
            metadata.addConsumes(MediaType.valueOf((String)mediaType));
        }
        for (String mediaType : produces = this.getProduces(method)) {
            hasAnnotation = true;
            metadata.addProduces(MediaType.valueOf((String)mediaType));
        }
        String defaultValue = this.getDefaultValue(method);
        if (defaultValue != null) {
            metadata.setDefaultValue(defaultValue);
            hasAnnotation = true;
        }
        if (method.getAnnotation(Encoded.class) != null) {
            metadata.setEncoded(true);
            hasAnnotation = true;
        }
        if (!hasAnnotation) {
            Class<?>[] interfaces;
            MethodMetadata createdMetadata;
            Class<?> declaringClass = method.getDeclaringClass();
            Class<?> superclass = declaringClass.getSuperclass();
            if (superclass != null && superclass != Object.class && (createdMetadata = this.createMethodMetadata(superclass, method)) != null) {
                return createdMetadata;
            }
            for (Class<?> interfaceClass : interfaces = declaringClass.getInterfaces()) {
                MethodMetadata createdMetadata2 = this.createMethodMetadata(interfaceClass, method);
                if (createdMetadata2 == null) continue;
                return createdMetadata2;
            }
            return null;
        }
        if (metadata.getHttpMethod() == null && metadata.getPath() == null) {
            if (metadata.isEncoded() || defaultValue != null) {
                return null;
            }
            if (logger.isWarnEnabled()) {
                logger.warn(Messages.getMessage("methodNotAnnotatedCorrectly", method.getName(), method.getDeclaringClass().getCanonicalName()));
            }
            return null;
        }
        this.parseMethodParameters(method, metadata);
        return metadata;
    }

    private MethodMetadata createMethodMetadata(Class<?> declaringClass, Method method) {
        try {
            Method declaredMethod = declaringClass.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return this.createMethodMetadata(declaredMethod);
        }
        catch (SecurityException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private boolean parseClassConsumes(Class<?> cls) {
        String[] consumes;
        for (String mediaType : consumes = this.getConsumes(cls)) {
            this.getMetadata().addConsumes(MediaType.valueOf((String)mediaType));
        }
        return true;
    }

    private boolean parseClassProduces(Class<?> cls) {
        String[] consumes;
        for (String mediaType : consumes = this.getProduces(cls)) {
            this.getMetadata().addProduces(MediaType.valueOf((String)mediaType));
        }
        return true;
    }

    private String[] getConsumes(AnnotatedElement element) {
        Consumes consumes = element.getAnnotation(Consumes.class);
        if (consumes != null) {
            return AnnotationUtils.parseConsumesProducesValues(consumes.value());
        }
        return new String[0];
    }

    private String[] getProduces(AnnotatedElement element) {
        Produces produces = element.getAnnotation(Produces.class);
        if (produces != null) {
            return AnnotationUtils.parseConsumesProducesValues(produces.value());
        }
        return new String[0];
    }

    private Path getPath(Method method) {
        return method.getAnnotation(Path.class);
    }

    private HttpMethod getHttpMethod(Method method) {
        HttpMethod httpMethod = null;
        for (Annotation annotation : method.getAnnotations()) {
            HttpMethod httpMethodCurr = annotation.annotationType().getAnnotation(HttpMethod.class);
            if (httpMethodCurr == null) continue;
            if (httpMethod != null) {
                throw new IllegalStateException(String.format("Multiple http method annotations on method %s in class %s", method.getName(), method.getDeclaringClass().getCanonicalName()));
            }
            httpMethod = httpMethodCurr;
        }
        return httpMethod;
    }

    private String getDefaultValue(Method method) {
        DefaultValue defaultValueAnn = method.getAnnotation(DefaultValue.class);
        if (defaultValueAnn != null) {
            return defaultValueAnn.value();
        }
        return null;
    }

    private void parseMethodParameters(Method method, MethodMetadata methodMetadata) {
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Type[] paramTypes = method.getGenericParameterTypes();
        boolean entityParamExists = false;
        int limit = paramTypes.length;
        for (int pos = 0; pos < limit; ++pos) {
            Injectable fp = InjectableFactory.getInstance().create(paramTypes[pos], parameterAnnotations[pos], method, this.getMetadata().isEncoded() || methodMetadata.isEncoded(), methodMetadata.getDefaultValue());
            if (fp.getParamType() == Injectable.ParamType.ENTITY) {
                if (entityParamExists) {
                    String methodName = method.getDeclaringClass().getName() + "." + method.getName();
                    throw new IllegalStateException("Resource method " + methodName + " has more than one entity parameter");
                }
                entityParamExists = true;
            }
            methodMetadata.getFormalParameters().add(fp);
        }
    }

    @Override
    protected final boolean isConstructorParameterValid(Injectable fp) {
        return fp.getParamType() != Injectable.ParamType.ENTITY;
    }
}

