/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMetadata {
    private List<String> paths = new ArrayList<String>();
    private Set<MediaType> consumes = new LinkedHashSet<MediaType>();
    private Set<MediaType> produces = new LinkedHashSet<MediaType>();
    private boolean encoded = false;
    private String defaultValue = null;

    public String getPath() {
        if (this.paths.size() == 0) {
            return null;
        }
        return this.paths.get(0);
    }

    public void addPath(String path) {
        this.paths.add(path);
    }

    public void addPaths(Collection<String> paths) {
        this.paths.addAll(paths);
    }

    public void addConsumes(MediaType mt) {
        this.consumes.add(mt);
    }

    public void addProduces(MediaType mt) {
        this.produces.add(mt);
    }

    public List<String> getPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public Set<MediaType> getConsumes() {
        return Collections.unmodifiableSet(this.consumes);
    }

    public Set<MediaType> getProduces() {
        return Collections.unmodifiableSet(this.produces);
    }

    public String toString() {
        return "[" + (this.consumes != null ? "consumes=" + this.consumes + ", " : "") + (this.paths != null ? "paths=" + this.paths + ", " : "") + (this.produces != null ? "produces=" + this.produces : "") + "]";
    }

    public void setEncoded(boolean encoded) {
        this.encoded = encoded;
    }

    public boolean isEncoded() {
        return this.encoded;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }
}

