/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity.app;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.wink.common.annotations.Scope;
import org.apache.wink.common.categories.Categories;
import org.apache.wink.common.model.app.AppCategories;
import org.apache.wink.common.model.app.AppYesNo;
import org.apache.wink.common.model.atom.AtomCategory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Scope(value=Scope.ScopeType.PROTOTYPE)
@Produces(value={"application/atomcat+xml"})
public class CategoriesProvider
implements MessageBodyWriter<Categories> {
    @Context
    Providers providers;
    MessageBodyWriter<AppCategories> appCatProvider;

    public long getSize(Categories t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type != Categories.class) {
            return false;
        }
        this.appCatProvider = this.providers.getMessageBodyWriter(AppCategories.class, null, null, mediaType);
        return this.appCatProvider != null && type == Categories.class;
    }

    public void writeTo(Categories categories, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        AppCategories catDoc = this.buildAppCatDoc(categories);
        this.appCatProvider.writeTo((Object)catDoc, AppCategories.class, AppCategories.class, annotations, mediaType, httpHeaders, entityStream);
    }

    private AppCategories buildAppCatDoc(Categories cats) {
        AppCategories appCategories = new AppCategories();
        List<AtomCategory> categoryList = appCategories.getCategory();
        List<AtomCategory> categories = cats.getCategories();
        for (AtomCategory cat : categories) {
            String catTerm;
            String catScheme;
            AtomCategory atomCategory = new AtomCategory();
            String catLabel = cat.getLabel();
            if (catLabel != null) {
                atomCategory.setLabel(catLabel);
            }
            if ((catScheme = cat.getScheme()) != null) {
                atomCategory.setScheme(catScheme);
            }
            if ((catTerm = cat.getTerm()) != null) {
                atomCategory.setTerm(catTerm);
            }
            categoryList.add(atomCategory);
        }
        String catsScheme = cats.getScheme();
        boolean fixed = cats.isFixed();
        if (catsScheme != null) {
            appCategories.setScheme(catsScheme);
        }
        if (fixed) {
            appCategories.setFixed(AppYesNo.YES);
        }
        return appCategories;
    }
}

