/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal;

import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.PathSegment;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathSegmentImpl
implements PathSegment,
Cloneable,
Comparable<PathSegment> {
    private static final String MATRIX_DELIMITER = ";";
    private String path;
    private MultivaluedMap<String, String> matrixParams;

    private PathSegmentImpl() {
        this.path = null;
        this.matrixParams = null;
    }

    public PathSegmentImpl(String path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.constructParts(path);
    }

    public PathSegmentImpl(String path, String matrix) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.constructMatrixParams(this.extractMatrixParams(matrix));
    }

    public PathSegmentImpl(String path, MultivaluedMap<String, String> matrixParams) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.path = path;
        this.matrixParams = matrixParams;
    }

    public MultivaluedMap<String, String> getMatrixParameters() {
        if (this.matrixParams == null) {
            this.matrixParams = new MultivaluedMapImpl<String, String>();
        }
        return this.matrixParams;
    }

    public void clearMatrixParameter(String name) {
        MultivaluedMap<String, String> matrixParameters = this.getMatrixParameters();
        matrixParameters.remove((Object)name);
    }

    public void clearAllMatrixParameters() {
        MultivaluedMap<String, String> matrixParameters = this.getMatrixParameters();
        matrixParameters.clear();
    }

    public void setMatrixParameters(String matrix) {
        this.constructMatrixParams(this.extractMatrixParams(matrix));
    }

    public String getPath() {
        return this.path;
    }

    private void constructParts(String path) {
        String[] parts = this.extractMatrixParams(path);
        this.path = parts[0];
        this.constructMatrixParams(parts, 1);
    }

    private String[] extractMatrixParams(String path) {
        return StringUtils.fastSplitTemplate(path, MATRIX_DELIMITER);
    }

    private void constructMatrixParams(String[] matrixParamsArray) {
        this.constructMatrixParams(matrixParamsArray, 0);
    }

    private void constructMatrixParams(String[] matrixParamsArray, int offset) {
        this.getMatrixParameters().clear();
        for (int i = offset; i < matrixParamsArray.length; ++i) {
            String matrixParam = matrixParamsArray[i];
            int index = matrixParam.indexOf(61);
            if (index == -1) continue;
            String name = matrixParam.substring(0, index);
            String value = matrixParam.substring(index + 1);
            this.matrixParams.add((Object)name, (Object)value);
        }
    }

    public PathSegmentImpl clone() {
        try {
            PathSegmentImpl ps = (PathSegmentImpl)super.clone();
            if (this.matrixParams != null) {
                ps.matrixParams = ((MultivaluedMapImpl)this.matrixParams).clone();
            }
            return ps;
        }
        catch (CloneNotSupportedException e) {
            throw new WebApplicationException((Throwable)e);
        }
    }

    public static PathSegmentImpl decode(PathSegment segment) {
        PathSegmentImpl clone = new PathSegmentImpl();
        clone.path = UriEncoder.decodeString(segment.getPath());
        clone.matrixParams = UriEncoder.decodeMultivaluedMap((MultivaluedMap<String, String>)segment.getMatrixParameters(), true);
        return clone;
    }

    public String toString() {
        MultivaluedMap<String, String> matrixParameters = this.getMatrixParameters();
        String parameters = MultivaluedMapImpl.toString(matrixParameters, MATRIX_DELIMITER);
        String delim = matrixParameters.isEmpty() ? "" : MATRIX_DELIMITER;
        String result = this.getPath() + delim + parameters;
        return result;
    }

    public static String toString(List<PathSegment> segments) {
        StringBuilder builder = new StringBuilder();
        String delim = "";
        for (PathSegment segment : segments) {
            builder.append(delim);
            builder.append(segment.toString());
            delim = "/";
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.matrixParams == null ? 0 : this.matrixParams.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathSegmentImpl other = (PathSegmentImpl)obj;
        if (this.matrixParams == null ? other.matrixParams != null : !this.matrixParams.equals(other.matrixParams)) {
            return false;
        }
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public int compareTo(PathSegment o) {
        return this.path.compareTo(o.getPath());
    }
}

