/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.flow;

import org.apache.wicket.request.ILogData;
import org.apache.wicket.request.ILoggableRequestHandler;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestHandlerDelegate;
import org.apache.wicket.request.RequestHandlerStack;
import org.apache.wicket.request.handler.logger.DelegateLogData;
import org.apache.wicket.request.handler.logger.NoLogData;

public abstract class ResetResponseException
extends RequestHandlerStack.ReplaceHandlerException {
    private static final long serialVersionUID = 1L;

    protected ResetResponseException(IRequestHandler handler) {
        super(new ResponseResettingDecorator(handler), true);
    }

    private static class ResponseResettingDecorator
    implements IRequestHandler,
    IRequestHandlerDelegate,
    ILoggableRequestHandler {
        private final IRequestHandler delegate;
        private DelegateLogData logData;

        public ResponseResettingDecorator(IRequestHandler delegate) {
            this.delegate = delegate;
        }

        public void detach(IRequestCycle requestCycle) {
            this.delegate.detach(requestCycle);
            if (this.logData == null) {
                ILogData delegateData = this.delegate instanceof ILoggableRequestHandler ? ((ILoggableRequestHandler)this.delegate).getLogData() : new NoLogData();
                this.logData = new DelegateLogData(delegateData);
            }
        }

        public void respond(IRequestCycle requestCycle) {
            requestCycle.getResponse().reset();
            this.delegate.respond(requestCycle);
        }

        public IRequestHandler getDelegateHandler() {
            return this.delegate;
        }

        public DelegateLogData getLogData() {
            return this.logData;
        }
    }
}

