/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.guice.GuiceInjectorHolder;
import org.apache.wicket.proxy.IProxyTargetLocator;
import org.apache.wicket.util.lang.Classes;

class GuiceProxyTargetLocator
implements IProxyTargetLocator {
    private static final long serialVersionUID = 1L;
    private final Annotation bindingAnnotation;
    private final boolean optional;
    private final String[] data;
    private final int argIndex;

    public GuiceProxyTargetLocator(Field field, Annotation bindingAnnotation, boolean optional) {
        this.bindingAnnotation = bindingAnnotation;
        this.optional = optional;
        this.data = new String[2];
        this.data[0] = field.getDeclaringClass().getName();
        this.data[1] = field.getName();
        this.argIndex = -1;
    }

    public GuiceProxyTargetLocator(Method method, int argIndex, Annotation bindingAnnotation, boolean optional) {
        this.bindingAnnotation = bindingAnnotation;
        this.optional = optional;
        this.data = new String[2 + method.getParameterTypes().length];
        this.data[0] = method.getDeclaringClass().getName();
        this.data[1] = method.getName();
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            this.data[2 + i] = method.getParameterTypes()[i].getName();
        }
        this.argIndex = argIndex;
    }

    public Object locateProxyTarget() {
        Type type;
        GuiceInjectorHolder holder = (GuiceInjectorHolder)Application.get().getMetaData(GuiceInjectorHolder.INJECTOR_KEY);
        try {
            Class clazz = Classes.resolveClass((String)this.data[0]);
            if (this.argIndex < 0) {
                Field field = clazz.getDeclaredField(this.data[1]);
                type = field.getGenericType();
            } else {
                Class[] paramTypes = new Class[this.data.length - 2];
                for (int i = 2; i < this.data.length; ++i) {
                    paramTypes[i - 2] = Classes.resolveClass((String)this.data[i]);
                }
                Method method = clazz.getDeclaredMethod(this.data[1], paramTypes);
                type = method.getGenericParameterTypes()[this.argIndex];
            }
        }
        catch (Exception e) {
            throw new WicketRuntimeException("Error accessing member: " + this.data[1] + " of class: " + this.data[0], (Throwable)e);
        }
        Key key = this.bindingAnnotation == null ? Key.get((TypeLiteral)TypeLiteral.get((Type)type)) : Key.get((TypeLiteral)TypeLiteral.get((Type)type), (Annotation)this.bindingAnnotation);
        Injector injector = holder.getInjector();
        if (this.optional) {
            try {
                if (injector.getBinding(key) == null) {
                    return null;
                }
            }
            catch (RuntimeException e) {
                return null;
            }
        }
        return injector.getInstance(key);
    }
}

