/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.tipis;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.catalina.tribes.Channel;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.group.Response;
import org.apache.catalina.tribes.group.RpcCallback;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.membership.MemberImpl;
import org.apache.catalina.tribes.tipis.ReplicatedMapEntry;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class AbstractReplicatedMap
extends ConcurrentHashMap
implements RpcCallback,
ChannelListener,
MembershipListener,
Heartbeat {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AbstractReplicatedMap.class);
    public static final int DEFAULT_INITIAL_CAPACITY = 16;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final Charset CHARSET_ISO_8859_1 = Charset.forName("ISO-8859-1");
    protected transient long rpcTimeout = 5000L;
    protected transient Channel channel;
    protected transient RpcChannel rpcChannel;
    protected transient byte[] mapContextName;
    protected transient boolean stateTransferred = false;
    protected transient Object stateMutex = new Object();
    protected transient HashMap<Member, Long> mapMembers = new HashMap();
    protected transient int channelSendOptions = 2;
    protected transient MapOwner mapOwner;
    protected transient ClassLoader[] externalLoaders;
    protected transient int currentNode = 0;
    protected transient long accessTimeout = 5000L;
    protected transient String mapname = "";

    protected abstract int getStateMessageType();

    public AbstractReplicatedMap(MapOwner owner, Channel channel, long timeout, String mapContextName, int initialCapacity, float loadFactor, int channelSendOptions, ClassLoader[] cls, boolean terminate) {
        super(initialCapacity, loadFactor, 15);
        this.init(owner, channel, mapContextName, timeout, channelSendOptions, cls, terminate);
    }

    protected Member[] wrap(Member m) {
        if (m == null) {
            return new Member[0];
        }
        return new Member[]{m};
    }

    protected void init(MapOwner owner, Channel channel, String mapContextName, long timeout, int channelSendOptions, ClassLoader[] cls, boolean terminate) {
        block3: {
            log.info((Object)("Initializing AbstractReplicatedMap with context name:" + mapContextName));
            this.mapOwner = owner;
            this.externalLoaders = cls;
            this.channelSendOptions = channelSendOptions;
            this.channel = channel;
            this.rpcTimeout = timeout;
            this.mapname = mapContextName;
            this.mapContextName = mapContextName.getBytes(CHARSET_ISO_8859_1);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Created Lazy Map with name:" + mapContextName + ", bytes:" + Arrays.toString(this.mapContextName)));
            }
            this.rpcChannel = new RpcChannel(this.mapContextName, channel, this);
            this.channel.addChannelListener(this);
            this.channel.addMembershipListener(this);
            try {
                this.broadcast(8, true);
                this.transferState();
                this.broadcast(6, true);
            }
            catch (ChannelException x) {
                log.warn((Object)"Unable to send map start message.");
                if (!terminate) break block3;
                this.breakdown();
                throw new RuntimeException("Unable to start replicated map.", x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ping(long timeout) throws ChannelException {
        MapMessage msg = new MapMessage(this.mapContextName, 8, false, null, null, null, this.channel.getLocalMember(false), null);
        if (this.channel.getMembers().length > 0) {
            try {
                Response[] resp = this.rpcChannel.send(this.channel.getMembers(), msg, 3, this.channelSendOptions, (int)this.accessTimeout);
                for (int i = 0; i < resp.length; ++i) {
                    this.memberAlive(resp[i].getSource());
                }
            }
            catch (ChannelException ce) {
                ChannelException.FaultyMember[] faultyMembers;
                for (ChannelException.FaultyMember faultyMember : faultyMembers = ce.getFaultyMembers()) {
                    this.memberDisappeared(faultyMember.getMember());
                }
            }
        }
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            Iterator<Map.Entry<Member, Long>> it = this.mapMembers.entrySet().iterator();
            long now = System.currentTimeMillis();
            while (it.hasNext()) {
                Map.Entry<Member, Long> entry = it.next();
                long access = entry.getValue();
                if (now - access <= timeout) continue;
                it.remove();
                this.memberDisappeared(entry.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void memberAlive(Member member) {
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            if (!this.mapMembers.containsKey(member)) {
                this.mapMemberAdded(member);
            }
            this.mapMembers.put(member, new Long(System.currentTimeMillis()));
        }
    }

    protected void broadcast(int msgtype, boolean rpc) throws ChannelException {
        Member[] members = this.channel.getMembers();
        if (members.length == 0) {
            return;
        }
        MapMessage msg = new MapMessage(this.mapContextName, msgtype, false, null, null, null, this.channel.getLocalMember(false), null);
        if (rpc) {
            Response[] resp = this.rpcChannel.send(members, msg, 1, this.channelSendOptions, this.rpcTimeout);
            if (resp.length > 0) {
                for (int i = 0; i < resp.length; ++i) {
                    this.mapMemberAdded(resp[i].getSource());
                    this.messageReceived(resp[i].getMessage(), resp[i].getSource());
                }
            } else {
                log.warn((Object)"broadcast received 0 replies, probably a timeout.");
            }
        } else {
            this.channel.send(this.channel.getMembers(), msg, this.channelSendOptions);
        }
    }

    public void breakdown() {
        this.finalize();
    }

    public void finalize() {
        try {
            this.broadcast(7, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.rpcChannel != null) {
            this.rpcChannel.breakdown();
        }
        if (this.channel != null) {
            this.channel.removeChannelListener(this);
            this.channel.removeMembershipListener(this);
        }
        this.rpcChannel = null;
        this.channel = null;
        this.mapMembers.clear();
        super.clear();
        this.stateTransferred = false;
        this.externalLoaders = null;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mapContextName);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof AbstractReplicatedMap)) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        AbstractReplicatedMap other = (AbstractReplicatedMap)o;
        return Arrays.equals(this.mapContextName, other.mapContextName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMapMembers(HashMap<Member, Long> members) {
        HashMap<Member, Long> hashMap = members;
        synchronized (hashMap) {
            Member[] result = new Member[members.size()];
            members.keySet().toArray(result);
            return result;
        }
    }

    public Member[] getMapMembers() {
        return this.getMapMembers(this.mapMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Member[] getMapMembersExcl(Member[] exclude) {
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            HashMap list = (HashMap)this.mapMembers.clone();
            for (int i = 0; i < exclude.length; ++i) {
                list.remove(exclude[i]);
            }
            return this.getMapMembers(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicate(Object key, boolean complete) {
        MapEntry entry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Replicate invoked on key:" + key));
        }
        if ((entry = (MapEntry)super.get(key)) == null) {
            return;
        }
        if (!entry.isSerializable()) {
            return;
        }
        if (entry.isPrimary() && entry.getBackupNodes() != null && entry.getBackupNodes().length > 0) {
            boolean repl;
            ReplicatedMapEntry rentry = null;
            if (entry.getValue() instanceof ReplicatedMapEntry) {
                rentry = (ReplicatedMapEntry)entry.getValue();
            }
            boolean isDirty = rentry != null && rentry.isDirty();
            boolean isAccess = rentry != null && rentry.isAccessReplicate();
            boolean bl = repl = complete || isDirty || isAccess;
            if (!repl) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Not replicating:" + key + ", no change made"));
                }
                return;
            }
            boolean diff = rentry != null && rentry.isDiffable();
            MapMessage msg = null;
            if (diff && (isDirty || complete)) {
                try {
                    rentry.lock();
                    msg = new MapMessage(this.mapContextName, 1, true, (Serializable)entry.getKey(), null, rentry.getDiff(), entry.getPrimary(), entry.getBackupNodes());
                    rentry.resetDiff();
                }
                catch (IOException x) {
                    log.error((Object)"Unable to diff object. Will replicate the entire object instead.", (Throwable)x);
                }
                finally {
                    rentry.unlock();
                }
            }
            if (msg == null && complete) {
                msg = new MapMessage(this.mapContextName, 1, false, (Serializable)entry.getKey(), (Serializable)entry.getValue(), null, entry.getPrimary(), entry.getBackupNodes());
            }
            if (msg == null) {
                msg = new MapMessage(this.mapContextName, 11, false, (Serializable)entry.getKey(), null, null, entry.getPrimary(), entry.getBackupNodes());
            }
            try {
                if (this.channel != null && entry.getBackupNodes() != null && entry.getBackupNodes().length > 0) {
                    if (rentry != null) {
                        rentry.setLastTimeReplicated(System.currentTimeMillis());
                    }
                    this.channel.send(entry.getBackupNodes(), msg, this.channelSendOptions);
                }
            }
            catch (ChannelException x) {
                log.error((Object)"Unable to replicate data.", (Throwable)x);
            }
        }
    }

    public void replicate(boolean complete) {
        for (Map.Entry e : super.entrySet()) {
            this.replicate(e.getKey(), complete);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transferState() {
        block9: {
            try {
                Member backup;
                Member[] members = this.getMapMembers();
                Member member = backup = members.length > 0 ? members[0] : null;
                if (backup == null) break block9;
                MapMessage msg = new MapMessage(this.mapContextName, this.getStateMessageType(), false, null, null, null, null, null);
                Response[] resp = this.rpcChannel.send(new Member[]{backup}, msg, 1, this.channelSendOptions, this.rpcTimeout);
                if (resp.length > 0) {
                    Object object = this.stateMutex;
                    synchronized (object) {
                        msg = (MapMessage)resp[0].getMessage();
                        msg.deserialize(this.getExternalLoaders());
                        ArrayList list = (ArrayList)msg.getValue();
                        for (int i = 0; i < list.size(); ++i) {
                            this.messageReceived((Serializable)list.get(i), resp[0].getSource());
                        }
                        break block9;
                    }
                }
                log.warn((Object)"Transfer state, 0 replies, probably a timeout.");
            }
            catch (ChannelException x) {
                log.error((Object)"Unable to transfer LazyReplicatedMap state.", (Throwable)x);
            }
            catch (IOException x) {
                log.error((Object)"Unable to transfer LazyReplicatedMap state.", (Throwable)x);
            }
            catch (ClassNotFoundException x) {
                log.error((Object)"Unable to transfer LazyReplicatedMap state.", (Throwable)x);
            }
        }
        this.stateTransferred = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable replyRequest(Serializable msg, Member sender) {
        if (!(msg instanceof MapMessage)) {
            return null;
        }
        MapMessage mapmsg = (MapMessage)msg;
        if (mapmsg.getMsgType() == 8) {
            mapmsg.setPrimary(this.channel.getLocalMember(false));
            return mapmsg;
        }
        if (mapmsg.getMsgType() == 6) {
            mapmsg.setPrimary(this.channel.getLocalMember(false));
            this.mapMemberAdded(sender);
            return mapmsg;
        }
        if (mapmsg.getMsgType() == 2) {
            MapEntry entry = (MapEntry)super.get(mapmsg.getKey());
            if (entry == null || !entry.isSerializable()) {
                return null;
            }
            mapmsg.setValue((Serializable)entry.getValue());
            return mapmsg;
        }
        if (mapmsg.getMsgType() == 5 || mapmsg.getMsgType() == 10) {
            Object object = this.stateMutex;
            synchronized (object) {
                ArrayList<MapMessage> list = new ArrayList<MapMessage>();
                for (Map.Entry e : super.entrySet()) {
                    MapEntry entry = (MapEntry)super.get(e.getKey());
                    if (entry == null || !entry.isSerializable()) continue;
                    boolean copy = mapmsg.getMsgType() == 10;
                    MapMessage me = new MapMessage(this.mapContextName, copy ? 9 : 3, false, (Serializable)entry.getKey(), copy ? (Serializable)entry.getValue() : null, null, entry.getPrimary(), entry.getBackupNodes());
                    list.add(me);
                }
                mapmsg.setValue(list);
                return mapmsg;
            }
        }
        return null;
    }

    @Override
    public void leftOver(Serializable msg, Member sender) {
        if (!(msg instanceof MapMessage)) {
            return;
        }
        MapMessage mapmsg = (MapMessage)msg;
        try {
            mapmsg.deserialize(this.getExternalLoaders());
            if (mapmsg.getMsgType() == 6) {
                this.mapMemberAdded(mapmsg.getPrimary());
            } else if (mapmsg.getMsgType() == 8) {
                this.memberAlive(mapmsg.getPrimary());
            }
        }
        catch (IOException x) {
            log.error((Object)"Unable to deserialize MapMessage.", (Throwable)x);
        }
        catch (ClassNotFoundException x) {
            log.error((Object)"Unable to deserialize MapMessage.", (Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void messageReceived(Serializable msg, Member sender) {
        MapEntry entry;
        if (!(msg instanceof MapMessage)) {
            return;
        }
        MapMessage mapmsg = (MapMessage)msg;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Map[" + this.mapname + "] received message:" + mapmsg));
        }
        try {
            mapmsg.deserialize(this.getExternalLoaders());
        }
        catch (IOException x) {
            log.error((Object)"Unable to deserialize MapMessage.", (Throwable)x);
            return;
        }
        catch (ClassNotFoundException x) {
            log.error((Object)"Unable to deserialize MapMessage.", (Throwable)x);
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Map message received from:" + sender.getName() + " msg:" + mapmsg));
        }
        if (mapmsg.getMsgType() == 6) {
            this.mapMemberAdded(mapmsg.getPrimary());
        }
        if (mapmsg.getMsgType() == 7) {
            this.memberDisappeared(mapmsg.getPrimary());
        }
        if (mapmsg.getMsgType() == 3) {
            entry = (MapEntry)super.get(mapmsg.getKey());
            if (entry == null) {
                entry = new MapEntry(mapmsg.getKey(), mapmsg.getValue());
                entry.setBackup(false);
                entry.setProxy(true);
                entry.setBackupNodes(mapmsg.getBackupNodes());
                entry.setPrimary(mapmsg.getPrimary());
                super.put(entry.getKey(), entry);
            } else {
                entry.setProxy(true);
                entry.setBackup(false);
                entry.setBackupNodes(mapmsg.getBackupNodes());
                entry.setPrimary(mapmsg.getPrimary());
            }
        }
        if (mapmsg.getMsgType() == 4) {
            super.remove(mapmsg.getKey());
        }
        if (mapmsg.getMsgType() == 1 || mapmsg.getMsgType() == 9) {
            entry = (MapEntry)super.get(mapmsg.getKey());
            if (entry == null) {
                entry = new MapEntry(mapmsg.getKey(), mapmsg.getValue());
                entry.setBackup(mapmsg.getMsgType() == 1);
                entry.setProxy(false);
                entry.setBackupNodes(mapmsg.getBackupNodes());
                entry.setPrimary(mapmsg.getPrimary());
                if (mapmsg.getValue() != null && mapmsg.getValue() instanceof ReplicatedMapEntry) {
                    ((ReplicatedMapEntry)mapmsg.getValue()).setOwner(this.getMapOwner());
                }
            } else {
                entry.setBackup(mapmsg.getMsgType() == 1);
                entry.setProxy(false);
                entry.setBackupNodes(mapmsg.getBackupNodes());
                entry.setPrimary(mapmsg.getPrimary());
                if (entry.getValue() instanceof ReplicatedMapEntry) {
                    ReplicatedMapEntry diff = (ReplicatedMapEntry)entry.getValue();
                    if (mapmsg.isDiff()) {
                        try {
                            diff.lock();
                            diff.applyDiff(mapmsg.getDiffValue(), 0, mapmsg.getDiffValue().length);
                        }
                        catch (Exception x) {
                            log.error((Object)("Unable to apply diff to key:" + entry.getKey()), (Throwable)x);
                        }
                        finally {
                            diff.unlock();
                        }
                    } else {
                        if (mapmsg.getValue() != null) {
                            entry.setValue(mapmsg.getValue());
                        }
                        ((ReplicatedMapEntry)entry.getValue()).setOwner(this.getMapOwner());
                    }
                } else if (mapmsg.getValue() instanceof ReplicatedMapEntry) {
                    ReplicatedMapEntry re = (ReplicatedMapEntry)mapmsg.getValue();
                    re.setOwner(this.getMapOwner());
                    entry.setValue(re);
                } else if (mapmsg.getValue() != null) {
                    entry.setValue(mapmsg.getValue());
                }
            }
            super.put(entry.getKey(), entry);
        }
        if (mapmsg.getMsgType() == 11 && (entry = (MapEntry)super.get(mapmsg.getKey())) != null) {
            entry.setBackupNodes(mapmsg.getBackupNodes());
            entry.setPrimary(mapmsg.getPrimary());
            if (entry.getValue() instanceof ReplicatedMapEntry) {
                ((ReplicatedMapEntry)entry.getValue()).accessEntry();
            }
        }
    }

    @Override
    public boolean accept(Serializable msg, Member sender) {
        boolean result = false;
        if (msg instanceof MapMessage) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Map[" + this.mapname + "] accepting...." + msg));
            }
            result = Arrays.equals(this.mapContextName, ((MapMessage)msg).getMapId());
            if (log.isTraceEnabled()) {
                log.trace((Object)("Msg[" + this.mapname + "] accepted[" + result + "]...." + msg));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mapMemberAdded(Member member) {
        if (member.equals(this.getChannel().getLocalMember(false))) {
            return;
        }
        boolean memberAdded = false;
        Object object = this.mapMembers;
        synchronized (object) {
            if (!this.mapMembers.containsKey(member)) {
                this.mapMembers.put(member, new Long(System.currentTimeMillis()));
                memberAdded = true;
            }
        }
        if (memberAdded) {
            object = this.stateMutex;
            synchronized (object) {
                for (Map.Entry e : super.entrySet()) {
                    MapEntry entry = (MapEntry)super.get(e.getKey());
                    if (entry == null || !entry.isPrimary() || entry.getBackupNodes() != null && entry.getBackupNodes().length != 0) continue;
                    try {
                        Member[] backup = this.publishEntryInfo(entry.getKey(), entry.getValue());
                        entry.setBackupNodes(backup);
                        entry.setPrimary(this.channel.getLocalMember(false));
                    }
                    catch (ChannelException x) {
                        log.error((Object)"Unable to select backup node.", (Throwable)x);
                    }
                }
            }
        }
    }

    public boolean inSet(Member m, Member[] set) {
        if (set == null) {
            return false;
        }
        boolean result = false;
        for (int i = 0; i < set.length && !result; ++i) {
            if (!m.equals(set[i])) continue;
            result = true;
        }
        return result;
    }

    public Member[] excludeFromSet(Member[] mbrs, Member[] set) {
        ArrayList<Member> result = new ArrayList<Member>();
        for (int i = 0; i < set.length; ++i) {
            boolean include = true;
            for (int j = 0; j < mbrs.length && include; ++j) {
                if (!mbrs[j].equals(set[i])) continue;
                include = false;
            }
            if (!include) continue;
            result.add(set[i]);
        }
        return result.toArray(new Member[result.size()]);
    }

    @Override
    public void memberAdded(Member member) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void memberDisappeared(Member member) {
        boolean removed = false;
        HashMap<Member, Long> hashMap = this.mapMembers;
        synchronized (hashMap) {
            boolean bl = removed = this.mapMembers.remove(member) != null;
            if (!removed) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Member[" + member + "] disappeared, but was not present in the map."));
                }
                return;
            }
        }
        Iterator i = super.entrySet().iterator();
        while (i.hasNext()) {
            Member[] backup;
            Map.Entry e = i.next();
            MapEntry entry = (MapEntry)super.get(e.getKey());
            if (entry == null) continue;
            if (entry.isPrimary() && this.inSet(member, entry.getBackupNodes())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[1] Primary choosing a new backup");
                }
                try {
                    backup = this.publishEntryInfo(entry.getKey(), entry.getValue());
                    entry.setBackupNodes(backup);
                    entry.setPrimary(this.channel.getLocalMember(false));
                }
                catch (ChannelException x) {
                    log.error((Object)("Unable to relocate[" + entry.getKey() + "] to a new backup node"), (Throwable)x);
                }
            } else if (member.equals(entry.getPrimary())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[2] Primary disappeared");
                }
                entry.setPrimary(null);
            }
            if (entry.isProxy() && entry.getPrimary() == null && entry.getBackupNodes() != null && entry.getBackupNodes().length == 1 && entry.getBackupNodes()[0].equals(member)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[3] Removing orphaned proxy");
                }
                i.remove();
                continue;
            }
            if (entry.getPrimary() != null || !entry.isBackup() || entry.getBackupNodes() == null || entry.getBackupNodes().length != 1 || !entry.getBackupNodes()[0].equals(this.channel.getLocalMember(false))) continue;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"[4] Backup becoming primary");
                }
                entry.setPrimary(this.channel.getLocalMember(false));
                entry.setBackup(false);
                entry.setProxy(false);
                backup = this.publishEntryInfo(entry.getKey(), entry.getValue());
                entry.setBackupNodes(backup);
                if (this.mapOwner == null) continue;
                this.mapOwner.objectMadePrimay(entry.getKey(), entry.getValue());
            }
            catch (ChannelException x) {
                log.error((Object)("Unable to relocate[" + entry.getKey() + "] to a new backup node"), (Throwable)x);
            }
        }
    }

    public int getNextBackupIndex() {
        int node;
        int size = this.mapMembers.size();
        if (this.mapMembers.size() == 0) {
            return -1;
        }
        if ((node = this.currentNode++) >= size) {
            node = 0;
            this.currentNode = 0;
        }
        return node;
    }

    public Member getNextBackupNode() {
        Member[] members = this.getMapMembers();
        int node = this.getNextBackupIndex();
        if (members.length == 0 || node == -1) {
            return null;
        }
        if (node >= members.length) {
            node = 0;
        }
        return members[node];
    }

    protected abstract Member[] publishEntryInfo(Object var1, Object var2) throws ChannelException;

    @Override
    public void heartbeat() {
        try {
            this.ping(this.accessTimeout);
        }
        catch (Exception x) {
            log.error((Object)"Unable to send AbstractReplicatedMap.ping message", (Throwable)x);
        }
    }

    @Override
    public Object remove(Object key) {
        return this.remove(key, true);
    }

    public Object remove(Object key, boolean notify) {
        MapEntry entry = (MapEntry)super.remove(key);
        try {
            if (this.getMapMembers().length > 0 && notify) {
                MapMessage msg = new MapMessage(this.getMapContextName(), 4, false, (Serializable)key, null, null, null, null);
                this.getChannel().send(this.getMapMembers(), msg, this.getChannelSendOptions());
            }
        }
        catch (ChannelException x) {
            log.error((Object)"Unable to replicate out data for a LazyReplicatedMap.remove operation", (Throwable)x);
        }
        return entry != null ? entry.getValue() : null;
    }

    public MapEntry getInternal(Object key) {
        return (MapEntry)super.get(key);
    }

    @Override
    public Object get(Object key) {
        MapEntry entry = (MapEntry)super.get(key);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Requesting id:" + key + " entry:" + entry));
        }
        if (entry == null) {
            return null;
        }
        if (!entry.isPrimary()) {
            try {
                ReplicatedMapEntry val;
                Member[] backup = null;
                MapMessage msg = null;
                if (!entry.isBackup()) {
                    msg = new MapMessage(this.getMapContextName(), 2, false, (Serializable)key, null, null, null, null);
                    Response[] resp = this.getRpcChannel().send(entry.getBackupNodes(), msg, 1, 2, this.getRpcTimeout());
                    if (resp == null || resp.length == 0) {
                        log.warn((Object)("Unable to retrieve remote object for key:" + key));
                        return null;
                    }
                    msg = (MapMessage)resp[0].getMessage();
                    msg.deserialize(this.getExternalLoaders());
                    backup = entry.getBackupNodes();
                    if (entry.getValue() instanceof ReplicatedMapEntry) {
                        val = (ReplicatedMapEntry)entry.getValue();
                        val.setOwner(this.getMapOwner());
                    }
                    if (msg.getValue() != null) {
                        entry.setValue(msg.getValue());
                    }
                }
                if (entry.isBackup()) {
                    backup = this.publishEntryInfo(key, entry.getValue());
                } else if (entry.isProxy()) {
                    msg = new MapMessage(this.getMapContextName(), 3, false, (Serializable)key, null, null, this.channel.getLocalMember(false), backup);
                    Member[] dest = this.getMapMembersExcl(backup);
                    if (dest != null && dest.length > 0) {
                        this.getChannel().send(dest, msg, this.getChannelSendOptions());
                    }
                    if (entry.getValue() != null && entry.getValue() instanceof ReplicatedMapEntry) {
                        val = (ReplicatedMapEntry)entry.getValue();
                        val.setOwner(this.getMapOwner());
                    }
                }
                entry.setPrimary(this.channel.getLocalMember(false));
                entry.setBackupNodes(backup);
                entry.setBackup(false);
                entry.setProxy(false);
                if (this.getMapOwner() != null) {
                    this.getMapOwner().objectMadePrimay(key, entry.getValue());
                }
            }
            catch (Exception x) {
                log.error((Object)"Unable to replicate out data for a LazyReplicatedMap.get operation", (Throwable)x);
                return null;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("Requesting id:" + key + " result:" + entry.getValue()));
        }
        return entry.getValue();
    }

    protected void printMap(String header) {
        try {
            System.out.println("\nDEBUG MAP:" + header);
            System.out.println("Map[" + new String(this.mapContextName, CHARSET_ISO_8859_1) + ", Map Size:" + super.size());
            Member[] mbrs = this.getMapMembers();
            for (int i = 0; i < mbrs.length; ++i) {
                System.out.println("Mbr[" + (i + 1) + "=" + mbrs[i].getName());
            }
            Iterator i = super.entrySet().iterator();
            int cnt = 0;
            while (i.hasNext()) {
                Map.Entry e = i.next();
                System.out.println(++cnt + ". " + super.get(e.getKey()));
            }
            System.out.println("EndMap]\n\n");
        }
        catch (Exception ignore) {
            ignore.printStackTrace();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    @Override
    public Object put(Object key, Object value) {
        return this.put(key, value, true);
    }

    public Object put(Object key, Object value, boolean notify) {
        MapEntry entry = new MapEntry(key, value);
        entry.setBackup(false);
        entry.setProxy(false);
        entry.setPrimary(this.channel.getLocalMember(false));
        Object old = null;
        if (this.containsKey(key)) {
            old = this.remove(key);
        }
        try {
            if (notify) {
                Member[] backup = this.publishEntryInfo(key, value);
                entry.setBackupNodes(backup);
            }
        }
        catch (ChannelException x) {
            log.error((Object)"Unable to replicate out data for a LazyReplicatedMap.put operation", (Throwable)x);
        }
        super.put(key, entry);
        return old;
    }

    @Override
    public void putAll(Map m) {
        for (Map.Entry entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.clear(true);
    }

    public void clear(boolean notify) {
        if (notify) {
            Iterator<Object> keys = this.keySet().iterator();
            while (keys.hasNext()) {
                this.remove(keys.next());
            }
        } else {
            super.clear();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return super.containsValue(value);
        }
        for (Map.Entry e : super.entrySet()) {
            MapEntry entry = (MapEntry)super.get(e.getKey());
            if (entry == null || !entry.isActive() || !value.equals(entry.getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        throw new UnsupportedOperationException("This operation is not valid on a replicated map");
    }

    public Set entrySetFull() {
        return super.entrySet();
    }

    public Set keySetFull() {
        return super.keySet();
    }

    public int sizeFull() {
        return super.size();
    }

    @Override
    public Set<MapEntry> entrySet() {
        LinkedHashSet<MapEntry> set = new LinkedHashSet<MapEntry>(super.size());
        for (Map.Entry e : super.entrySet()) {
            Object key = e.getKey();
            MapEntry entry = (MapEntry)super.get(key);
            if (entry == null || !entry.isActive()) continue;
            set.add(new MapEntry(key, entry.getValue()));
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public Set<Object> keySet() {
        LinkedHashSet set = new LinkedHashSet(super.size());
        for (Map.Entry e : super.entrySet()) {
            Object key = e.getKey();
            MapEntry entry = (MapEntry)super.get(key);
            if (entry == null || !entry.isActive()) continue;
            set.add(key);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public int size() {
        int counter = 0;
        Iterator it = super.entrySet().iterator();
        while (it != null && it.hasNext()) {
            MapEntry entry;
            Map.Entry e = it.next();
            if (e == null || (entry = (MapEntry)super.get(e.getKey())) == null || !entry.isActive() || entry.getValue() == null) continue;
            ++counter;
        }
        return counter;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Map.Entry e : super.entrySet()) {
            MapEntry entry = (MapEntry)super.get(e.getKey());
            if (entry == null || !entry.isActive() || entry.getValue() == null) continue;
            values.add(entry.getValue());
        }
        return Collections.unmodifiableCollection(values);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public byte[] getMapContextName() {
        return this.mapContextName;
    }

    public RpcChannel getRpcChannel() {
        return this.rpcChannel;
    }

    public long getRpcTimeout() {
        return this.rpcTimeout;
    }

    public Object getStateMutex() {
        return this.stateMutex;
    }

    public boolean isStateTransferred() {
        return this.stateTransferred;
    }

    public MapOwner getMapOwner() {
        return this.mapOwner;
    }

    public ClassLoader[] getExternalLoaders() {
        return this.externalLoaders;
    }

    public int getChannelSendOptions() {
        return this.channelSendOptions;
    }

    public long getAccessTimeout() {
        return this.accessTimeout;
    }

    public void setMapOwner(MapOwner mapOwner) {
        this.mapOwner = mapOwner;
    }

    public void setExternalLoaders(ClassLoader[] externalLoaders) {
        this.externalLoaders = externalLoaders;
    }

    public void setChannelSendOptions(int channelSendOptions) {
        this.channelSendOptions = channelSendOptions;
    }

    public void setAccessTimeout(long accessTimeout) {
        this.accessTimeout = accessTimeout;
    }

    public static class MapMessage
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public static final int MSG_BACKUP = 1;
        public static final int MSG_RETRIEVE_BACKUP = 2;
        public static final int MSG_PROXY = 3;
        public static final int MSG_REMOVE = 4;
        public static final int MSG_STATE = 5;
        public static final int MSG_START = 6;
        public static final int MSG_STOP = 7;
        public static final int MSG_INIT = 8;
        public static final int MSG_COPY = 9;
        public static final int MSG_STATE_COPY = 10;
        public static final int MSG_ACCESS = 11;
        private byte[] mapId;
        private int msgtype;
        private boolean diff;
        private transient Serializable key;
        private transient Serializable value;
        private byte[] valuedata;
        private byte[] keydata;
        private byte[] diffvalue;
        private Member[] nodes;
        private Member primary;

        public String toString() {
            StringBuilder buf = new StringBuilder("MapMessage[context=");
            buf.append(new String(this.mapId));
            buf.append("; type=");
            buf.append(this.getTypeDesc());
            buf.append("; key=");
            buf.append(this.key);
            buf.append("; value=");
            buf.append(this.value);
            return buf.toString();
        }

        public String getTypeDesc() {
            switch (this.msgtype) {
                case 1: {
                    return "MSG_BACKUP";
                }
                case 2: {
                    return "MSG_RETRIEVE_BACKUP";
                }
                case 3: {
                    return "MSG_PROXY";
                }
                case 4: {
                    return "MSG_REMOVE";
                }
                case 5: {
                    return "MSG_STATE";
                }
                case 6: {
                    return "MSG_START";
                }
                case 7: {
                    return "MSG_STOP";
                }
                case 8: {
                    return "MSG_INIT";
                }
                case 10: {
                    return "MSG_STATE_COPY";
                }
                case 9: {
                    return "MSG_COPY";
                }
                case 11: {
                    return "MSG_ACCESS";
                }
            }
            return "UNKNOWN";
        }

        @Deprecated
        public MapMessage() {
        }

        public MapMessage(byte[] mapId, int msgtype, boolean diff, Serializable key, Serializable value, byte[] diffvalue, Member primary, Member[] nodes) {
            this.mapId = mapId;
            this.msgtype = msgtype;
            this.diff = diff;
            this.key = key;
            this.value = value;
            this.diffvalue = diffvalue;
            this.nodes = nodes;
            this.primary = primary;
            this.setValue(value);
            this.setKey(key);
        }

        public void deserialize(ClassLoader[] cls) throws IOException, ClassNotFoundException {
            this.key(cls);
            this.value(cls);
        }

        public int getMsgType() {
            return this.msgtype;
        }

        public boolean isDiff() {
            return this.diff;
        }

        public Serializable getKey() {
            try {
                return this.key(null);
            }
            catch (Exception x) {
                log.error((Object)"Deserialization error of the MapMessage.key", (Throwable)x);
                return null;
            }
        }

        public Serializable key(ClassLoader[] cls) throws IOException, ClassNotFoundException {
            if (this.key != null) {
                return this.key;
            }
            if (this.keydata == null || this.keydata.length == 0) {
                return null;
            }
            this.key = XByteBuffer.deserialize(this.keydata, 0, this.keydata.length, cls);
            this.keydata = null;
            return this.key;
        }

        public byte[] getKeyData() {
            return this.keydata;
        }

        public Serializable getValue() {
            try {
                return this.value(null);
            }
            catch (Exception x) {
                log.error((Object)"Deserialization error of the MapMessage.value", (Throwable)x);
                return null;
            }
        }

        public Serializable value(ClassLoader[] cls) throws IOException, ClassNotFoundException {
            if (this.value != null) {
                return this.value;
            }
            if (this.valuedata == null || this.valuedata.length == 0) {
                return null;
            }
            this.value = XByteBuffer.deserialize(this.valuedata, 0, this.valuedata.length, cls);
            this.valuedata = null;
            return this.value;
        }

        public byte[] getValueData() {
            return this.valuedata;
        }

        public byte[] getDiffValue() {
            return this.diffvalue;
        }

        public Member[] getBackupNodes() {
            return this.nodes;
        }

        public Member getPrimary() {
            return this.primary;
        }

        private void setPrimary(Member m) {
            this.primary = m;
        }

        public byte[] getMapId() {
            return this.mapId;
        }

        public void setValue(Serializable value) {
            try {
                if (value != null) {
                    this.valuedata = XByteBuffer.serialize(value);
                }
                this.value = value;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }

        public void setKey(Serializable key) {
            try {
                if (key != null) {
                    this.keydata = XByteBuffer.serialize(key);
                }
                this.key = key;
            }
            catch (IOException x) {
                throw new RuntimeException(x);
            }
        }

        @Deprecated
        protected Member[] readMembers(ObjectInput in) throws IOException, ClassNotFoundException {
            int nodecount = in.readInt();
            Member[] members = new Member[nodecount];
            for (int i = 0; i < members.length; ++i) {
                byte[] d = new byte[in.readInt()];
                in.readFully(d);
                if (d.length <= 0) continue;
                members[i] = MemberImpl.getMember(d);
            }
            return members;
        }

        @Deprecated
        protected void writeMembers(ObjectOutput out, Member[] members) throws IOException {
            if (members == null) {
                members = new Member[]{};
            }
            out.writeInt(members.length);
            for (int i = 0; i < members.length; ++i) {
                if (members[i] == null) continue;
                byte[] d = members[i] != null ? ((MemberImpl)members[i]).getData(false) : new byte[]{};
                out.writeInt(d.length);
                out.write(d);
            }
        }

        public Object clone() {
            MapMessage msg = new MapMessage(this.mapId, this.msgtype, this.diff, this.key, this.value, this.diffvalue, this.primary, this.nodes);
            msg.keydata = this.keydata;
            msg.valuedata = this.valuedata;
            return msg;
        }
    }

    public static class MapEntry
    implements Map.Entry<Object, Object> {
        private boolean backup;
        private boolean proxy;
        private Member[] backupNodes;
        private Member primary;
        private Object key;
        private Object value;

        public MapEntry(Object key, Object value) {
            this.setKey(key);
            this.setValue(value);
        }

        public boolean isKeySerializable() {
            return this.key == null || this.key instanceof Serializable;
        }

        public boolean isValueSerializable() {
            return this.value == null || this.value instanceof Serializable;
        }

        public boolean isSerializable() {
            return this.isKeySerializable() && this.isValueSerializable();
        }

        public boolean isBackup() {
            return this.backup;
        }

        public void setBackup(boolean backup) {
            this.backup = backup;
        }

        public boolean isProxy() {
            return this.proxy;
        }

        public boolean isPrimary() {
            return !this.proxy && !this.backup;
        }

        public boolean isActive() {
            return !this.proxy;
        }

        public void setProxy(boolean proxy) {
            this.proxy = proxy;
        }

        public boolean isDiffable() {
            return this.value instanceof ReplicatedMapEntry && ((ReplicatedMapEntry)this.value).isDiffable();
        }

        public void setBackupNodes(Member[] nodes) {
            this.backupNodes = nodes;
        }

        public Member[] getBackupNodes() {
            return this.backupNodes;
        }

        public void setPrimary(Member m) {
            this.primary = m;
        }

        public Member getPrimary() {
            return this.primary;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object setValue(Object value) {
            Object old = this.value;
            this.value = value;
            return old;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        public Object setKey(Object key) {
            Object old = this.key;
            this.key = key;
            return old;
        }

        @Override
        public int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return this.key.equals(o);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void apply(byte[] data, int offset, int length, boolean diff) throws IOException, ClassNotFoundException {
            if (this.isDiffable() && diff) {
                ReplicatedMapEntry rentry = (ReplicatedMapEntry)this.value;
                try {
                    rentry.lock();
                    rentry.applyDiff(data, offset, length);
                }
                finally {
                    rentry.unlock();
                }
            } else if (length == 0) {
                this.value = null;
                this.proxy = true;
            } else {
                this.value = XByteBuffer.deserialize(data, offset, length);
            }
        }

        public String toString() {
            StringBuilder buf = new StringBuilder("MapEntry[key:");
            buf.append(this.getKey()).append("; ");
            buf.append("value:").append(this.getValue()).append("; ");
            buf.append("primary:").append(this.isPrimary()).append("; ");
            buf.append("backup:").append(this.isBackup()).append("; ");
            buf.append("proxy:").append(this.isProxy()).append(";]");
            return buf.toString();
        }
    }

    public static interface MapOwner {
        public void objectMadePrimay(Object var1, Object var2);
    }
}

