/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import java.io.IOException;
import java.util.Random;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.catalina.filters.FilterBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class CsrfPreventionFilter
extends FilterBase {
    private static final Log log = LogFactory.getLog(CsrfPreventionFilter.class);
    private final Random randomSource = new Random();

    @Override
    protected Log getLogger() {
        return log;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wResponse = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String previousNonce = req.getParameter("org.apache.catalina.filters.CSRF_NONCE");
            String expectedNonce = (String)req.getSession(true).getAttribute("org.apache.catalina.filters.CSRF_NONCE");
            if (expectedNonce != null && !expectedNonce.equals(previousNonce)) {
                res.sendError(403);
                return;
            }
            String newNonce = this.generateNonce();
            req.getSession(true).setAttribute("org.apache.catalina.filters.CSRF_NONCE", (Object)newNonce);
            wResponse = new CsrfResponseWrapper(res, newNonce);
        } else {
            wResponse = response;
        }
        chain.doFilter(request, wResponse);
    }

    protected String generateNonce() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        this.randomSource.nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }

    private static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private String nonce;

        public CsrfResponseWrapper(HttpServletResponse response, String nonce) {
            super(response);
            this.nonce = nonce;
        }

        @Deprecated
        public String encodeRedirectUrl(String url) {
            return this.encodeRedirectURL(url);
        }

        public String encodeRedirectURL(String url) {
            return this.addNonce(super.encodeRedirectURL(url));
        }

        @Deprecated
        public String encodeUrl(String url) {
            return this.encodeURL(url);
        }

        public String encodeURL(String url) {
            return this.addNonce(super.encodeURL(url));
        }

        private String addNonce(String url) {
            int pound;
            if (url == null || this.nonce == null) {
                return url;
            }
            String path = url;
            String query = "";
            String anchor = "";
            int question = url.indexOf(63);
            if (question >= 0) {
                path = url.substring(0, question);
                query = url.substring(question);
            }
            if ((pound = path.indexOf(35)) >= 0) {
                anchor = path.substring(pound);
                path = path.substring(0, pound);
            }
            StringBuilder sb = new StringBuilder(path);
            sb.append(anchor);
            if (query.length() > 0) {
                sb.append(query);
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append("org.apache.catalina.filters.CSRF_NONCE");
            sb.append('=');
            sb.append(this.nonce);
            return sb.toString();
        }
    }
}

