/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.upload.internal.services;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.tapestry.ioc.internal.util.CollectionFactory;
import org.apache.tapestry.upload.internal.services.ParameterValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersServletRequestWrapper
extends HttpServletRequestWrapper {
    private final Map<String, ParameterValue> _parameters = CollectionFactory.newMap();

    public ParametersServletRequestWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public String getParameter(String name) {
        return this.getValueFor(name).single();
    }

    public Map<String, Object> getParameterMap() {
        Map paramMap = CollectionFactory.newMap();
        for (Map.Entry<String, ParameterValue> e : this._parameters.entrySet()) {
            ParameterValue value = e.getValue();
            paramMap.put(e.getKey(), value.isMulti() ? value.multi() : value.single());
        }
        return paramMap;
    }

    public Enumeration getParameterNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getValueFor(name).multi();
    }

    public void addParameter(String name, String value) {
        ParameterValue pv = this._parameters.get(name);
        if (pv == null) {
            pv = new ParameterValue(value);
            this._parameters.put(name, pv);
        } else {
            pv.add(value);
        }
    }

    ParameterValue getValueFor(String name) {
        ParameterValue value = this._parameters.get(name);
        return value == null ? ParameterValue.NULL : value;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
    }
}

